/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.spark.structuredstreaming.metrics.BeamMetricSet;
import org.apache.beam.runners.spark.structuredstreaming.metrics.MetricsAccumulator;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Streams;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class SparkBeamMetric
extends BeamMetricSet {
    private static final @UnknownKeyFor @NonNull @Initialized String ILLEGAL_CHARACTERS = "[^A-Za-z0-9-]";
    private final @UnknownKeyFor @NonNull @Initialized MetricsAccumulator metrics;

    SparkBeamMetric(@UnknownKeyFor @NonNull @Initialized MetricsAccumulator metrics) {
        this.metrics = metrics;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Gauge<@UnknownKeyFor @NonNull @Initialized Double>> getValue(@UnknownKeyFor @NonNull @Initialized String prefix, @UnknownKeyFor @NonNull @Initialized MetricFilter filter) {
        MetricResults metricResults = MetricsContainerStepMap.asAttemptedOnlyMetricResults((MetricsContainerStepMap)this.metrics.value());
        HashMap<String, Gauge<Double>> metrics = new HashMap<String, Gauge<Double>>();
        MetricQueryResults allMetrics = metricResults.allMetrics();
        for (MetricResult metricResult : allMetrics.getCounters()) {
            this.putFiltered(metrics, filter, SparkBeamMetric.renderName(prefix, metricResult), (Number)metricResult.getAttempted());
        }
        for (MetricResult metricResult : allMetrics.getDistributions()) {
            DistributionResult result = (DistributionResult)metricResult.getAttempted();
            String baseName = SparkBeamMetric.renderName(prefix, metricResult);
            this.putFiltered(metrics, filter, baseName + ".count", result.getCount());
            this.putFiltered(metrics, filter, baseName + ".sum", result.getSum());
            this.putFiltered(metrics, filter, baseName + ".min", result.getMin());
            this.putFiltered(metrics, filter, baseName + ".max", result.getMax());
            this.putFiltered(metrics, filter, baseName + ".mean", result.getMean());
        }
        for (MetricResult metricResult : allMetrics.getGauges()) {
            this.putFiltered(metrics, filter, SparkBeamMetric.renderName(prefix, metricResult), ((GaugeResult)metricResult.getAttempted()).getValue());
        }
        return metrics;
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized String renderName(@UnknownKeyFor @NonNull @Initialized String prefix, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> metricResult) {
        MetricKey key = metricResult.getKey();
        MetricName name = key.metricName();
        String step = key.stepName();
        return Streams.concat((Stream[])new Stream[]{Stream.of(prefix), Stream.of(SparkBeamMetric.stripSuffix(SparkBeamMetric.normalizePart(step))), Stream.of(name.getNamespace(), name.getName()).map(SparkBeamMetric::normalizePart)}).filter(Predicates.not(Strings::isNullOrEmpty)).collect(Collectors.joining("."));
    }

    @Nullable
    private static @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String normalizePart(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String str) {
        return str != null ? str.replaceAll(ILLEGAL_CHARACTERS, "_") : null;
    }

    @Nullable
    private static @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String stripSuffix(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String str) {
        return str != null && str.endsWith("_") ? str.substring(0, str.length() - 1) : str;
    }

    private void putFiltered(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Gauge<@UnknownKeyFor @NonNull @Initialized Double>> metrics, @UnknownKeyFor @NonNull @Initialized MetricFilter filter, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Number value) {
        Gauge<Double> metric = this.staticGauge(value);
        if (filter.matches(name, metric)) {
            metrics.put(name, metric);
        }
    }
}

