/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.cloud.bigquery.Field;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FieldList
extends AbstractList<Field>
implements Serializable {
    private static final long serialVersionUID = 8736258375638733316L;
    private final List<Field> fields;
    private final Map<String, Integer> nameIndex;

    private FieldList(Iterable<Field> fields) {
        this.fields = ImmutableList.copyOf(fields);
        CaseInsensitiveMap caseInsensitiveMap = new CaseInsensitiveMap();
        int index = 0;
        for (Field field : fields) {
            caseInsensitiveMap.put(field.getName(), index);
            ++index;
        }
        this.nameIndex = caseInsensitiveMap;
    }

    @Override
    public Field get(int index) {
        return this.fields.get(index);
    }

    public Field get(String name) {
        return this.get(this.getIndex(name));
    }

    public int getIndex(String name) {
        Integer index = this.nameIndex.get(name);
        if (index == null) {
            throw new IllegalArgumentException("Field with name '" + name + "' was not found");
        }
        return index;
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    public static FieldList of(Field ... fields) {
        return new FieldList((Iterable<Field>)ImmutableList.copyOf((Object[])fields));
    }

    public static FieldList of(Iterable<Field> fields) {
        return new FieldList(fields);
    }

    List<TableFieldSchema> toPb() {
        return Lists.transform(this.fields, Field.TO_PB_FUNCTION);
    }

    static FieldList fromPb(List<TableFieldSchema> fields) {
        return FieldList.of(Lists.transform(fields, Field.FROM_PB_FUNCTION));
    }

    private static class CaseInsensitiveMap
    extends HashMap<String, Integer> {
        private CaseInsensitiveMap() {
        }

        @Override
        public Integer put(String key, Integer value) {
            return super.put(key.toLowerCase(), value);
        }

        @Override
        public Integer get(Object key) {
            return (Integer)super.get(key.toString().toLowerCase());
        }
    }
}

