/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.PartitionInfo;
import org.apache.flink.runtime.io.disk.BatchShuffleReadBufferPool;
import org.apache.flink.runtime.io.disk.FileChannelManager;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.metrics.InputChannelMetrics;
import org.apache.flink.runtime.io.network.metrics.NettyShuffleMetricFactory;
import org.apache.flink.runtime.io.network.partition.PartitionProducerStateProvider;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionFactory;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputGateID;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGateFactory;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.shuffle.NettyShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleEnvironment;
import org.apache.flink.runtime.shuffle.ShuffleIOOwnerContext;
import org.apache.flink.runtime.taskmanager.NettyShuffleEnvironmentConfiguration;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyShuffleEnvironment
implements ShuffleEnvironment<ResultPartition, SingleInputGate> {
    private static final Logger LOG = LoggerFactory.getLogger(NettyShuffleEnvironment.class);
    private final Object lock = new Object();
    private final ResourceID taskExecutorResourceId;
    private final NettyShuffleEnvironmentConfiguration config;
    private final NetworkBufferPool networkBufferPool;
    private final ConnectionManager connectionManager;
    private final ResultPartitionManager resultPartitionManager;
    private final FileChannelManager fileChannelManager;
    private final Map<InputGateID, SingleInputGate> inputGatesById;
    private final ResultPartitionFactory resultPartitionFactory;
    private final SingleInputGateFactory singleInputGateFactory;
    private final Executor ioExecutor;
    private final BatchShuffleReadBufferPool batchShuffleReadBufferPool;
    private final ExecutorService batchShuffleReadIOExecutor;
    private boolean isClosed;

    NettyShuffleEnvironment(ResourceID taskExecutorResourceId, NettyShuffleEnvironmentConfiguration config, NetworkBufferPool networkBufferPool, ConnectionManager connectionManager, ResultPartitionManager resultPartitionManager, FileChannelManager fileChannelManager, ResultPartitionFactory resultPartitionFactory, SingleInputGateFactory singleInputGateFactory, Executor ioExecutor, BatchShuffleReadBufferPool batchShuffleReadBufferPool, ExecutorService batchShuffleReadIOExecutor) {
        this.taskExecutorResourceId = taskExecutorResourceId;
        this.config = config;
        this.networkBufferPool = networkBufferPool;
        this.connectionManager = connectionManager;
        this.resultPartitionManager = resultPartitionManager;
        this.inputGatesById = new ConcurrentHashMap<InputGateID, SingleInputGate>(10);
        this.fileChannelManager = fileChannelManager;
        this.resultPartitionFactory = resultPartitionFactory;
        this.singleInputGateFactory = singleInputGateFactory;
        this.ioExecutor = ioExecutor;
        this.batchShuffleReadBufferPool = batchShuffleReadBufferPool;
        this.batchShuffleReadIOExecutor = batchShuffleReadIOExecutor;
        this.isClosed = false;
    }

    @VisibleForTesting
    public ResultPartitionManager getResultPartitionManager() {
        return this.resultPartitionManager;
    }

    @VisibleForTesting
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @VisibleForTesting
    public NetworkBufferPool getNetworkBufferPool() {
        return this.networkBufferPool;
    }

    @VisibleForTesting
    public BatchShuffleReadBufferPool getBatchShuffleReadBufferPool() {
        return this.batchShuffleReadBufferPool;
    }

    @VisibleForTesting
    public ExecutorService getBatchShuffleReadIOExecutor() {
        return this.batchShuffleReadIOExecutor;
    }

    @VisibleForTesting
    public NettyShuffleEnvironmentConfiguration getConfiguration() {
        return this.config;
    }

    @VisibleForTesting
    public Optional<InputGate> getInputGate(InputGateID id) {
        return Optional.ofNullable(this.inputGatesById.get(id));
    }

    @Override
    public void releasePartitionsLocally(Collection<ResultPartitionID> partitionIds) {
        this.ioExecutor.execute(() -> {
            for (ResultPartitionID partitionId : partitionIds) {
                this.resultPartitionManager.releasePartition(partitionId, null);
            }
        });
    }

    @Override
    public Collection<ResultPartitionID> getPartitionsOccupyingLocalResources() {
        return this.resultPartitionManager.getUnreleasedPartitions();
    }

    @Override
    public ShuffleIOOwnerContext createShuffleIOOwnerContext(String ownerName, ExecutionAttemptID executionAttemptID, MetricGroup parentGroup) {
        MetricGroup nettyGroup = NettyShuffleMetricFactory.createShuffleIOOwnerMetricGroup((MetricGroup)Preconditions.checkNotNull((Object)parentGroup));
        return new ShuffleIOOwnerContext((String)Preconditions.checkNotNull((Object)ownerName), (ExecutionAttemptID)Preconditions.checkNotNull((Object)executionAttemptID), parentGroup, nettyGroup.addGroup("Output"), nettyGroup.addGroup("Input"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResultPartition> createResultPartitionWriters(ShuffleIOOwnerContext ownerContext, List<ResultPartitionDeploymentDescriptor> resultPartitionDeploymentDescriptors) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"The NettyShuffleEnvironment has already been shut down.");
            ResultPartition[] resultPartitions = new ResultPartition[resultPartitionDeploymentDescriptors.size()];
            for (int partitionIndex = 0; partitionIndex < resultPartitions.length; ++partitionIndex) {
                resultPartitions[partitionIndex] = this.resultPartitionFactory.create(ownerContext.getOwnerName(), partitionIndex, resultPartitionDeploymentDescriptors.get(partitionIndex));
            }
            NettyShuffleMetricFactory.registerOutputMetrics(this.config.isNetworkDetailedMetrics(), ownerContext.getOutputGroup(), resultPartitions);
            return Arrays.asList(resultPartitions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SingleInputGate> createInputGates(ShuffleIOOwnerContext ownerContext, PartitionProducerStateProvider partitionProducerStateProvider, List<InputGateDeploymentDescriptor> inputGateDeploymentDescriptors) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"The NettyShuffleEnvironment has already been shut down.");
            MetricGroup networkInputGroup = ownerContext.getInputGroup();
            InputChannelMetrics inputChannelMetrics = new InputChannelMetrics(networkInputGroup, ownerContext.getParentGroup());
            SingleInputGate[] inputGates = new SingleInputGate[inputGateDeploymentDescriptors.size()];
            for (int gateIndex = 0; gateIndex < inputGates.length; ++gateIndex) {
                InputGateDeploymentDescriptor igdd = inputGateDeploymentDescriptors.get(gateIndex);
                SingleInputGate inputGate = this.singleInputGateFactory.create(ownerContext, gateIndex, igdd, partitionProducerStateProvider, inputChannelMetrics);
                InputGateID id = new InputGateID(igdd.getConsumedResultId(), ownerContext.getExecutionAttemptID());
                this.inputGatesById.put(id, inputGate);
                inputGate.getCloseFuture().thenRun(() -> this.inputGatesById.remove(id));
                inputGates[gateIndex] = inputGate;
            }
            if (this.config.getDebloatConfiguration().isEnabled()) {
                NettyShuffleMetricFactory.registerDebloatingTaskMetrics(inputGates, ownerContext.getParentGroup());
            }
            NettyShuffleMetricFactory.registerInputMetrics(this.config.isNetworkDetailedMetrics(), networkInputGroup, inputGates);
            return Arrays.asList(inputGates);
        }
    }

    @Deprecated
    public void registerLegacyNetworkMetrics(MetricGroup metricGroup, ResultPartitionWriter[] producedPartitions, InputGate[] inputGates) {
        NettyShuffleMetricFactory.registerLegacyNetworkMetrics(this.config.isNetworkDetailedMetrics(), metricGroup, producedPartitions, inputGates);
    }

    @Override
    public boolean updatePartitionInfo(ExecutionAttemptID consumerID, PartitionInfo partitionInfo) throws IOException, InterruptedException {
        IntermediateDataSetID intermediateResultPartitionID = partitionInfo.getIntermediateDataSetID();
        InputGateID id = new InputGateID(intermediateResultPartitionID, consumerID);
        SingleInputGate inputGate = this.inputGatesById.get(id);
        if (inputGate == null) {
            return false;
        }
        ShuffleDescriptor shuffleDescriptor = partitionInfo.getShuffleDescriptor();
        Preconditions.checkArgument((boolean)(shuffleDescriptor instanceof NettyShuffleDescriptor), (String)"Tried to update unknown channel with unknown ShuffleDescriptor %s.", (Object[])new Object[]{shuffleDescriptor.getClass().getName()});
        inputGate.updateInputChannel(this.taskExecutorResourceId, (NettyShuffleDescriptor)shuffleDescriptor);
        return true;
    }

    @Override
    public int start() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"The NettyShuffleEnvironment has already been shut down.");
            LOG.info("Starting the network environment and its components.");
            try {
                LOG.debug("Starting network connection manager");
                return this.connectionManager.start();
            }
            catch (IOException t) {
                throw new IOException("Failed to instantiate network connection manager.", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            LOG.info("Shutting down the network environment and its components.");
            try {
                LOG.debug("Shutting down network connection manager");
                this.connectionManager.shutdown();
            }
            catch (Throwable t) {
                LOG.warn("Cannot shut down the network connection manager.", t);
            }
            try {
                LOG.debug("Shutting down intermediate result partition manager");
                this.resultPartitionManager.shutdown();
            }
            catch (Throwable t) {
                LOG.warn("Cannot shut down the result partition manager.", t);
            }
            try {
                this.networkBufferPool.destroyAllBufferPools();
            }
            catch (Throwable t) {
                LOG.warn("Could not destroy all buffer pools.", t);
            }
            try {
                this.networkBufferPool.destroy();
            }
            catch (Throwable t) {
                LOG.warn("Network buffer pool did not shut down properly.", t);
            }
            try {
                this.fileChannelManager.close();
            }
            catch (Throwable t) {
                LOG.warn("Cannot close the file channel manager properly.", t);
            }
            try {
                this.batchShuffleReadBufferPool.destroy();
            }
            catch (Throwable t) {
                LOG.warn("Cannot shut down batch shuffle read buffer pool properly.", t);
            }
            try {
                this.batchShuffleReadIOExecutor.shutdown();
            }
            catch (Throwable t) {
                LOG.warn("Cannot shut down batch shuffle read IO executor properly.", t);
            }
            this.isClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.isClosed;
        }
    }
}

