/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationRequestHandler;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinatorHolder;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.operators.coordination.TaskNotRunningException;
import org.apache.flink.runtime.scheduler.GlobalFailureHandler;
import org.apache.flink.runtime.scheduler.OperatorCoordinatorHandler;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.IOUtils;

public class DefaultOperatorCoordinatorHandler
implements OperatorCoordinatorHandler {
    private final ExecutionGraph executionGraph;
    private final Map<OperatorID, OperatorCoordinatorHolder> coordinatorMap;
    private final GlobalFailureHandler globalFailureHandler;

    public DefaultOperatorCoordinatorHandler(ExecutionGraph executionGraph, GlobalFailureHandler globalFailureHandler) {
        this.executionGraph = executionGraph;
        this.coordinatorMap = DefaultOperatorCoordinatorHandler.createCoordinatorMap(executionGraph);
        this.globalFailureHandler = globalFailureHandler;
    }

    private static Map<OperatorID, OperatorCoordinatorHolder> createCoordinatorMap(ExecutionGraph executionGraph) {
        return executionGraph.getAllVertices().values().stream().filter(ExecutionJobVertex::isInitialized).flatMap(v -> v.getOperatorCoordinators().stream()).collect(Collectors.toMap(OperatorCoordinatorHolder::operatorId, Function.identity()));
    }

    @Override
    public void initializeOperatorCoordinators(ComponentMainThreadExecutor mainThreadExecutor) {
        for (OperatorCoordinatorHolder coordinatorHolder : this.coordinatorMap.values()) {
            coordinatorHolder.lazyInitialize(this.globalFailureHandler, mainThreadExecutor);
        }
    }

    @Override
    public void startAllOperatorCoordinators() {
        this.startOperatorCoordinators(this.coordinatorMap.values());
    }

    @Override
    public void disposeAllOperatorCoordinators() {
        this.coordinatorMap.values().forEach(IOUtils::closeQuietly);
    }

    @Override
    public void deliverOperatorEventToCoordinator(ExecutionAttemptID taskExecutionId, OperatorID operatorId, OperatorEvent evt) throws FlinkException {
        Execution exec = this.executionGraph.getRegisteredExecutions().get(taskExecutionId);
        if (exec == null || exec.getState() != ExecutionState.RUNNING && exec.getState() != ExecutionState.INITIALIZING) {
            throw new TaskNotRunningException("Task is not known or in state running on the JobManager.");
        }
        OperatorCoordinatorHolder coordinator = this.coordinatorMap.get((Object)operatorId);
        if (coordinator == null) {
            throw new FlinkException("No coordinator registered for operator " + (Object)((Object)operatorId));
        }
        try {
            coordinator.handleEventFromOperator(exec.getParallelSubtaskIndex(), evt);
        }
        catch (Throwable t) {
            ExceptionUtils.rethrowIfFatalErrorOrOOM((Throwable)t);
            this.globalFailureHandler.handleGlobalFailure(t);
        }
    }

    @Override
    public CompletableFuture<CoordinationResponse> deliverCoordinationRequestToCoordinator(OperatorID operator, CoordinationRequest request) throws FlinkException {
        OperatorCoordinatorHolder coordinatorHolder = this.coordinatorMap.get((Object)operator);
        if (coordinatorHolder == null) {
            throw new FlinkException("Coordinator of operator " + (Object)((Object)operator) + " does not exist or the job vertex this operator belongs to is not initialized.");
        }
        OperatorCoordinator coordinator = coordinatorHolder.coordinator();
        if (coordinator instanceof CoordinationRequestHandler) {
            return ((CoordinationRequestHandler)((Object)coordinator)).handleCoordinationRequest(request);
        }
        throw new FlinkException("Coordinator of operator " + (Object)((Object)operator) + " cannot handle client event");
    }

    @Override
    public void registerAndStartNewCoordinators(Collection<OperatorCoordinatorHolder> coordinators, ComponentMainThreadExecutor mainThreadExecutor) {
        for (OperatorCoordinatorHolder coordinator : coordinators) {
            this.coordinatorMap.put(coordinator.operatorId(), coordinator);
            coordinator.lazyInitialize(this.globalFailureHandler, mainThreadExecutor);
        }
        this.startOperatorCoordinators(coordinators);
    }

    private void startOperatorCoordinators(Collection<OperatorCoordinatorHolder> coordinators) {
        try {
            for (OperatorCoordinatorHolder coordinator : coordinators) {
                coordinator.start();
            }
        }
        catch (Throwable t) {
            ExceptionUtils.rethrowIfFatalErrorOrOOM((Throwable)t);
            coordinators.forEach(IOUtils::closeQuietly);
            throw new FlinkRuntimeException("Failed to start the operator coordinators", t);
        }
    }

    @VisibleForTesting
    Map<OperatorID, OperatorCoordinatorHolder> getCoordinatorMap() {
        return this.coordinatorMap;
    }
}

