/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.git;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.callback.GuiCallback;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.git.info.GitInfoExplorerFileType;
import org.apache.hop.git.info.GitInfoExplorerFileTypeHandler;
import org.apache.hop.git.model.UIFile;
import org.apache.hop.git.model.UIGit;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterStringDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerFile;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerFilePaintListener;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerRefreshListener;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerRootChangedListener;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerSelectionListener;
import org.apache.hop.ui.hopgui.perspective.explorer.file.IExplorerFileType;
import org.apache.hop.ui.hopgui.perspective.explorer.file.IExplorerFileTypeHandler;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

@GuiPlugin
public class GitGuiPlugin
implements IExplorerRootChangedListener,
IExplorerFilePaintListener,
IExplorerRefreshListener,
IExplorerSelectionListener {
    public static final Class<?> PKG = GitGuiPlugin.class;
    public static final String TOOLBAR_ITEM_GIT_INFO = "ExplorerPerspective-Toolbar-20000-GitInfo";
    public static final String TOOLBAR_ITEM_ADD = "ExplorerPerspective-Toolbar-20100-Add";
    public static final String TOOLBAR_ITEM_REVERT = "ExplorerPerspective-Toolbar-20200-Revert";
    public static final String TOOLBAR_ITEM_COMMIT = "ExplorerPerspective-Toolbar-21000-Commit";
    public static final String TOOLBAR_ITEM_PUSH = "ExplorerPerspective-Toolbar-21100-Push";
    public static final String TOOLBAR_ITEM_PULL = "ExplorerPerspective-Toolbar-21200-Pull";
    private static GitGuiPlugin instance;
    private UIGit git;
    private Map<String, UIFile> changedFiles;
    private Map<String, String> ignoredFiles;
    private Color colorIgnored;
    private Color colorStaged;
    private Color colorUnstaged;

    public static GitGuiPlugin getInstance() {
        if (instance == null) {
            instance = new GitGuiPlugin();
        }
        return instance;
    }

    public GitGuiPlugin() {
        if (instance != null) {
            this.git = GitGuiPlugin.instance.git;
        } else {
            instance = this;
            this.git = null;
        }
        this.colorIgnored = new Color((Device)HopGui.getInstance().getDisplay(), 125, 125, 125);
        this.colorStaged = GuiResource.getInstance().getColorBlue();
        this.colorUnstaged = GuiResource.getInstance().getColorRed();
        this.refreshChangedFiles();
    }

    @GuiCallback(callbackId="ExplorerPerspective-Toolbar-Created")
    public void addRootChangedListener() {
        this.git = null;
        ExplorerPerspective explorerPerspective = ExplorerPerspective.getInstance();
        explorerPerspective.getRootChangedListeners().add(this);
        explorerPerspective.getFilePaintListeners().add(this);
        explorerPerspective.getRefreshListeners().add(this);
        explorerPerspective.getSelectionListeners().add(this);
    }

    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-21000-Commit", toolTip="i18n::GitGuiPlugin.Toolbar.Commit.Tooltip", image="git-commit.svg")
    public void gitCommit() {
        try {
            ExplorerFile explorerFile = this.getSelectedFile();
            if (this.git == null || explorerFile == null) {
                return;
            }
            String relativePath = this.calculateRelativePath(this.git.getDirectory(), explorerFile);
            if (relativePath == null) {
                return;
            }
            List<String> changedFiles = this.git.getRevertPathFiles(relativePath);
            if (changedFiles.isEmpty()) {
                MessageBox box = new MessageBox(HopGui.getInstance().getShell(), 34);
                box.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.NoFilesToCommit.Header", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.NoFilesToCommit.Message", (String[])new String[0]));
                box.open();
            } else {
                EnterStringDialog enterStringDialog;
                String message;
                String[] files = changedFiles.toArray(new String[0]);
                int[] selectedIndexes = new int[files.length];
                for (int i = 0; i < files.length; ++i) {
                    selectedIndexes[i] = i;
                }
                EnterSelectionDialog selectionDialog = new EnterSelectionDialog(HopGui.getInstance().getShell(), files, "Select files to commit", "Please select the files to commit. They'll be staged (add) for the commit to git:");
                selectionDialog.setMulti(true);
                selectionDialog.setSelectedNrs(selectedIndexes);
                String selection = selectionDialog.open();
                if (selection != null && (message = (enterStringDialog = new EnterStringDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.SelectFilesToCommit.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.SelectFilesToCommit.Message", (String[])new String[0]), "")).open()) != null) {
                    int[] selectedNrs;
                    for (int selectedNr : selectedNrs = selectionDialog.getSelectionIndeces()) {
                        String file = files[selectedNr];
                        if (this.fileExists(file)) {
                            this.git.add(file);
                            continue;
                        }
                        this.git.rm(file);
                    }
                    String authorName = this.git.getAuthorName("WORKINGTREE");
                    this.git.commit(authorName, message);
                }
            }
            ExplorerPerspective.getInstance().refresh();
            this.enableButtons();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.CommitError.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.CommitError.Message", (String[])new String[0]), e);
        }
    }

    private boolean fileExists(String file) throws HopFileException, FileSystemException {
        String filename = this.git.getDirectory() + File.separator + file;
        return HopVfs.getFileObject((String)filename).exists();
    }

    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-21100-Push", toolTip="i18n::GitGuiPlugin.Toolbar.Push.Tooltip", image="push.svg")
    public void gitPush() {
        try {
            this.git.push();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.PushError.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.PushError.Message", (String[])new String[0]), e);
        }
    }

    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-21200-Pull", toolTip="i18n::GitGuiPlugin.Toolbar.Pull.Tooltip", image="pull.svg")
    public void gitPull() {
        try {
            this.git.pull();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.PullError.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.PullError.Message", (String[])new String[0]), e);
        }
    }

    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-20100-Add", toolTip="i18n::GitGuiPlugin.Toolbar.Add.Tooltip", image="git-add.svg")
    public void gitAdd() {
        try {
            ExplorerFile explorerFile = this.getSelectedFile();
            if (this.git == null || explorerFile == null) {
                return;
            }
            String relativePath = this.calculateRelativePath(this.git.getDirectory(), explorerFile);
            if (relativePath == null) {
                return;
            }
            this.git.add(relativePath);
            ExplorerPerspective.getInstance().refresh();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.AddError.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.AddError.Message", (String[])new String[0]), e);
        }
    }

    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-20200-Revert", toolTip="i18n::GitGuiPlugin.Toolbar.Revert.Tooltip", image="git-revert.svg")
    public void gitRevert() {
        try {
            ExplorerFile explorerFile = this.getSelectedFile();
            if (this.git == null || explorerFile == null) {
                return;
            }
            String relativePath = this.calculateRelativePath(this.git.getDirectory(), explorerFile);
            if (relativePath == null) {
                return;
            }
            List<String> revertPathFiles = this.git.getRevertPathFiles(relativePath);
            if (revertPathFiles.isEmpty()) {
                MessageBox box = new MessageBox(HopGui.getInstance().getShell(), 34);
                box.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.NoFilesToRevert.Header", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.NoFilesToRevert.Message", (String[])new String[0]));
                box.open();
            } else {
                String[] files = revertPathFiles.toArray(new String[0]);
                int[] selectedIndexes = new int[files.length];
                for (int i = 0; i < files.length; ++i) {
                    selectedIndexes[i] = i;
                }
                EnterSelectionDialog selectionDialog = new EnterSelectionDialog(HopGui.getInstance().getShell(), files, BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.RevertFiles.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.RevertFiles.Message", (String[])new String[0]));
                selectionDialog.setMulti(true);
                selectionDialog.setSelectedNrs(selectedIndexes);
                String selection = selectionDialog.open();
                if (selection != null) {
                    int[] selectedNrs;
                    for (int selectedNr : selectedNrs = selectionDialog.getSelectionIndeces()) {
                        String file = files[selectedNr];
                        this.git.revertPath(file);
                    }
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.RevertError.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.RevertError.Message", (String[])new String[0]), e);
        }
        ExplorerPerspective.getInstance().refresh();
        this.enableButtons();
    }

    private String calculateRelativePath(String directory, ExplorerFile explorerFile) {
        try {
            FileObject file = HopVfs.getFileObject((String)explorerFile.getFilename());
            FileObject root = HopVfs.getFileObject((String)directory);
            return root.getName().getRelativeName(file.getName());
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error calculating relative path for filename '" + explorerFile.getFilename() + "' against '" + directory + "'", (Throwable)e);
            return null;
        }
    }

    private ExplorerFile getSelectedFile() {
        ExplorerPerspective explorerPerspective = ExplorerPerspective.getInstance();
        return explorerPerspective.getSelectedFile();
    }

    public void rootChanged(String rootFolder, String rootName) {
        try {
            FileObject gitConfig = HopVfs.getFileObject((String)(rootFolder + "/.git/config"));
            if (gitConfig.exists()) {
                this.git = new UIGit();
                this.git.openRepo(rootFolder);
                LogChannel.UI.logBasic("Found git project for: " + rootFolder);
            }
        }
        catch (Exception e) {
            this.git = null;
            LogChannel.UI.logBasic("No git project found in " + rootFolder);
        }
        this.refreshChangedFiles();
        this.enableButtons();
    }

    private String getAbsoluteFilename(String root, String relativePath) {
        Object path = root + "/" + relativePath;
        try {
            path = HopVfs.getFileObject((String)path).getName().getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    private void refreshChangedFiles() {
        this.changedFiles = new HashMap<String, UIFile>();
        this.ignoredFiles = new HashMap<String, String>();
        if (this.git != null) {
            ArrayList<UIFile> files = new ArrayList<UIFile>(this.git.getStagedFiles());
            files.addAll(this.git.getUnstagedFiles());
            for (UIFile file : files) {
                String path = this.getAbsoluteFilename(this.git.getDirectory(), file.getName());
                this.changedFiles.put(path, file);
            }
            Set<String> ignored = this.git.getIgnored(null);
            for (String ignore : ignored) {
                String filename = this.getAbsoluteFilename(this.git.getDirectory(), ignore);
                this.ignoredFiles.put(filename, ignore);
            }
        }
    }

    public void beforeRefresh() {
        this.refreshChangedFiles();
    }

    public void fileSelected() {
        this.enableButtons();
    }

    private void enableButtons() {
        GuiToolbarWidgets widgets = ExplorerPerspective.getInstance().getToolBarWidgets();
        boolean isGit = this.git != null;
        boolean isSelected = isGit && this.getSelectedFile() != null;
        widgets.enableToolbarItem(TOOLBAR_ITEM_GIT_INFO, isGit);
        widgets.enableToolbarItem(TOOLBAR_ITEM_ADD, isSelected);
        widgets.enableToolbarItem(TOOLBAR_ITEM_REVERT, isSelected);
        widgets.enableToolbarItem(TOOLBAR_ITEM_COMMIT, isSelected);
        widgets.enableToolbarItem(TOOLBAR_ITEM_PUSH, isGit);
        widgets.enableToolbarItem(TOOLBAR_ITEM_PULL, isGit);
    }

    public void filePainted(Tree tree, TreeItem treeItem, String path, String name) {
        String ignored;
        GuiResource guiResource = GuiResource.getInstance();
        UIFile file = null;
        try {
            file = this.changedFiles.get(HopVfs.getFileObject((String)path).getName().getPath());
        }
        catch (HopFileException hopFileException) {
            // empty catch block
        }
        if (file != null) {
            switch (file.getChangeType()) {
                case DELETE: 
                case MODIFY: 
                case RENAME: 
                case COPY: {
                    treeItem.setForeground(this.colorStaged);
                    break;
                }
                case ADD: {
                    if (file.getIsStaged().booleanValue()) {
                        treeItem.setForeground(this.colorStaged);
                        break;
                    }
                    treeItem.setForeground(this.colorUnstaged);
                }
            }
        }
        if ((ignored = this.ignoredFiles.get(path)) != null) {
            treeItem.setForeground(this.colorIgnored);
        }
    }

    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-20000-GitInfo", toolTip="i18n::GitGuiPlugin.Toolbar.Info.Tooltip", image="git-info.svg", separator=true)
    public void showGitInfo() {
        if (this.git == null) {
            return;
        }
        ExplorerPerspective explorerPerspective = ExplorerPerspective.getInstance();
        if (explorerPerspective == null) {
            return;
        }
        ExplorerFile activeFile = explorerPerspective.getSelectedFile();
        if (activeFile == null) {
            activeFile = new ExplorerFile();
            activeFile.setName(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Project.Label", (String[])new String[0]));
            activeFile.setFilename(this.git.getDirectory());
        }
        activeFile.setName(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Info.Label", (String[])new String[]{activeFile.getName()}));
        GitInfoExplorerFileType fileType = new GitInfoExplorerFileType();
        activeFile.setFileType((IExplorerFileType)fileType);
        GitInfoExplorerFileTypeHandler fileTypeHandler = fileType.createFileTypeHandler(HopGui.getInstance(), explorerPerspective, activeFile);
        activeFile.setFileTypeHandler((IExplorerFileTypeHandler)fileTypeHandler);
        explorerPerspective.addFile(activeFile);
    }

    public UIGit getGit() {
        return this.git;
    }

    public Map<String, UIFile> getChangedFiles() {
        return this.changedFiles;
    }

    public Map<String, String> getIgnoredFiles() {
        return this.ignoredFiles;
    }
}

