/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.annotations;

import java.io.Serializable;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaProvider;
import org.apache.beam.sdk.schemas.SchemaProviderRegistrar;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Experimental(value=Experimental.Kind.SCHEMAS)
public @interface DefaultSchema {
    @CheckForNull
    public @UnknownKeyFor @Nullable @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized SchemaProvider> value();

    public static class DefaultSchemaProviderRegistrar
    implements SchemaProviderRegistrar {
        @Override
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SchemaProvider> getSchemaProviders() {
            return ImmutableList.of((Object)new DefaultSchemaProvider());
        }
    }

    public static class DefaultSchemaProvider
    implements SchemaProvider {
        final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TypeDescriptor, @UnknownKeyFor @NonNull @Initialized ProviderAndDescriptor> cachedProviders = Maps.newConcurrentMap();

        private @Nullable @UnknownKeyFor @Initialized ProviderAndDescriptor getSchemaProvider(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor) {
            return this.cachedProviders.computeIfAbsent(typeDescriptor, type -> {
                Class clazz = type.getRawType();
                do {
                    DefaultSchema annotation;
                    if ((annotation = clazz.getAnnotation(DefaultSchema.class)) == null) continue;
                    Class<? extends SchemaProvider> providerClass = annotation.value();
                    Preconditions.checkArgument((providerClass != null ? 1 : 0) != 0, (Object)("Type " + type + " has a @DefaultSchema annotation with a null argument."));
                    try {
                        return new ProviderAndDescriptor(providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), TypeDescriptor.of(clazz));
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new IllegalStateException("Failed to create SchemaProvider " + providerClass.getSimpleName() + " which was specified as the default SchemaProvider for type " + type + ". Make  sure that this class has a public default constructor.", e);
                    }
                } while ((clazz = clazz.getSuperclass()) != null && !clazz.equals(Object.class));
                return null;
            });
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized Schema schemaFor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
            ProviderAndDescriptor providerAndDescriptor = this.getSchemaProvider(typeDescriptor);
            return providerAndDescriptor != null ? providerAndDescriptor.schemaProvider.schemaFor(providerAndDescriptor.typeDescriptor) : null;
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRowFunction(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
            ProviderAndDescriptor providerAndDescriptor = this.getSchemaProvider(typeDescriptor);
            return providerAndDescriptor != null ? providerAndDescriptor.schemaProvider.toRowFunction(providerAndDescriptor.typeDescriptor) : null;
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRowFunction(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
            ProviderAndDescriptor providerAndDescriptor = this.getSchemaProvider(typeDescriptor);
            return providerAndDescriptor != null ? providerAndDescriptor.schemaProvider.fromRowFunction(providerAndDescriptor.typeDescriptor) : null;
        }

        private static final class ProviderAndDescriptor
        implements Serializable {
            final @UnknownKeyFor @NonNull @Initialized SchemaProvider schemaProvider;
            final /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor;

            public ProviderAndDescriptor(@UnknownKeyFor @NonNull @Initialized SchemaProvider schemaProvider, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor) {
                this.schemaProvider = schemaProvider;
                this.typeDescriptor = typeDescriptor;
            }
        }
    }
}

