/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BucketingFunction {
    private final @UnknownKeyFor @NonNull @Initialized long bucketWidthMs;
    private final @UnknownKeyFor @NonNull @Initialized int numSignificantBuckets;
    private final @UnknownKeyFor @NonNull @Initialized int numSignificantSamples;
    private final  @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineLongFn function;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Bucket> buckets;

    public BucketingFunction(@UnknownKeyFor @NonNull @Initialized long bucketWidthMs, @UnknownKeyFor @NonNull @Initialized int numSignificantBuckets, @UnknownKeyFor @NonNull @Initialized int numSignificantSamples,  @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineLongFn function) {
        this.bucketWidthMs = bucketWidthMs;
        this.numSignificantBuckets = numSignificantBuckets;
        this.numSignificantSamples = numSignificantSamples;
        this.function = function;
        this.buckets = new HashMap<Long, Bucket>();
    }

    private @UnknownKeyFor @NonNull @Initialized long key(@UnknownKeyFor @NonNull @Initialized long timeMsSinceEpoch) {
        return timeMsSinceEpoch - timeMsSinceEpoch % this.bucketWidthMs;
    }

    public void add(@UnknownKeyFor @NonNull @Initialized long timeMsSinceEpoch, @UnknownKeyFor @NonNull @Initialized long value) {
        long key = this.key(timeMsSinceEpoch);
        Bucket bucket = this.buckets.computeIfAbsent(key, k -> new Bucket(this));
        bucket.add(this, value);
    }

    public void remove(@UnknownKeyFor @NonNull @Initialized long timeMsSinceEpoch) {
        long key = this.key(timeMsSinceEpoch);
        Bucket bucket = this.buckets.get(key);
        if (bucket == null) {
            return;
        }
        if (bucket.remove()) {
            this.buckets.remove(key);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized long get() {
        long result = this.function.identity();
        for (Bucket bucket : this.buckets.values()) {
            result = this.function.apply(result, bucket.get());
        }
        return result;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isSignificant() {
        if (this.buckets.size() >= this.numSignificantBuckets) {
            return true;
        }
        int totalSamples = 0;
        for (Bucket bucket : this.buckets.values()) {
            totalSamples += bucket.numSamples;
        }
        return totalSamples >= this.numSignificantSamples;
    }

    private static class Bucket {
        private @UnknownKeyFor @NonNull @Initialized int numSamples = 0;
        private @UnknownKeyFor @NonNull @Initialized long combinedValue;

        public Bucket(@UnknownKeyFor @NonNull @Initialized BucketingFunction outer) {
            this.combinedValue = outer.function.identity();
        }

        public void add(@UnknownKeyFor @NonNull @Initialized BucketingFunction outer, @UnknownKeyFor @NonNull @Initialized long value) {
            this.combinedValue = outer.function.apply(this.combinedValue, value);
            ++this.numSamples;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean remove() {
            --this.numSamples;
            Preconditions.checkState((this.numSamples >= 0 ? 1 : 0) != 0, (Object)"Lost count of samples");
            return this.numSamples == 0;
        }

        public @UnknownKeyFor @NonNull @Initialized long get() {
            return this.combinedValue;
        }
    }
}

