/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.jar.Attributes;
import org.eclipse.swt.internal.Platform;

public class Library {
    static int MAJOR_VERSION = 4;
    static int MINOR_VERSION = 956;
    static int REVISION = 13;
    public static final int JAVA_VERSION;
    public static final int SWT_VERSION;
    public static final String USER_HOME;
    static final String SEPARATOR;
    static final String DELIMITER;
    static final String JAVA_LIB_PATH = "java.library.path";
    static final String SWT_LIB_PATH = "swt.library.path";
    static final String SUFFIX_64 = "-64";
    static final String SWT_LIB_DIR;

    static {
        DELIMITER = System.lineSeparator();
        SEPARATOR = File.separator;
        USER_HOME = System.getProperty("user.home");
        SWT_LIB_DIR = ".swt" + SEPARATOR + "lib" + SEPARATOR + Library.os() + SEPARATOR + Library.arch();
        JAVA_VERSION = Library.parseVersion(System.getProperty("java.version"));
        SWT_VERSION = Library.SWT_VERSION(MAJOR_VERSION, MINOR_VERSION);
    }

    static String arch() {
        String osArch = System.getProperty("os.arch");
        if (osArch.equals("amd64")) {
            return "x86_64";
        }
        return osArch;
    }

    static String os() {
        String osName = System.getProperty("os.name");
        if (osName.equals("Linux")) {
            return "linux";
        }
        if (osName.equals("Mac OS X")) {
            return "macosx";
        }
        if (osName.startsWith("Win")) {
            return "win32";
        }
        return osName;
    }

    static void chmod(String permision, String path) {
        if (Library.os().equals("win32")) {
            return;
        }
        try {
            Runtime.getRuntime().exec(new String[]{"chmod", permision, path}).waitFor();
        }
        catch (Throwable throwable) {
            try {
                new File(path).setExecutable(true);
            }
            catch (Throwable throwable2) {}
        }
    }

    static long longConst() {
        return 0x1FFFFFFFFL;
    }

    static int parseVersion(String version) {
        if (version == null) {
            return 0;
        }
        int major = 0;
        int minor = 0;
        int micro = 0;
        int length = version.length();
        int index = 0;
        int start = 0;
        while (index < length && Character.isDigit(version.charAt(index))) {
            ++index;
        }
        try {
            if (start < length) {
                major = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        start = ++index;
        while (index < length && Character.isDigit(version.charAt(index))) {
            ++index;
        }
        try {
            if (start < length) {
                minor = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        start = ++index;
        while (index < length && Character.isDigit(version.charAt(index))) {
            ++index;
        }
        try {
            if (start < length) {
                micro = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return Library.JAVA_VERSION(major, minor, micro);
    }

    public static int JAVA_VERSION(int major, int minor, int micro) {
        return (major << 16) + (minor << 8) + micro;
    }

    public static int SWT_VERSION(int major, int minor) {
        return major * 1000 + minor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean extractResource(String resourceName, File outFile) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream inputStream = Library.class.getResourceAsStream(resourceName);){
                if (inputStream == null) {
                    return false;
                }
                Files.copy(inputStream, outFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static boolean extract(String extractToFilePath, String mappedName) {
        File tempFile;
        File file = new File(extractToFilePath);
        if (file.exists()) {
            return true;
        }
        try {
            tempFile = File.createTempFile(file.getName(), ".tmp", file.getParentFile());
        }
        catch (Throwable throwable) {
            return false;
        }
        String resourceName = "/" + mappedName.replace('\\', '/');
        if (!Library.extractResource(resourceName, tempFile)) {
            tempFile.delete();
            return false;
        }
        Library.chmod("755", tempFile.getPath());
        try {
            Files.move(tempFile.toPath(), file.toPath(), new CopyOption[0]);
        }
        catch (Throwable throwable) {
            tempFile.delete();
        }
        return true;
    }

    static boolean isLoadable() {
        URLConnection connection;
        Attributes attributes;
        block4: {
            URL url = Platform.class.getClassLoader().getResource("org/eclipse/swt/internal/Library.class");
            if (!url.getProtocol().equals("jar")) {
                return true;
            }
            attributes = null;
            try {
                connection = url.openConnection();
                if (connection instanceof JarURLConnection) break block4;
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        JarURLConnection jc = (JarURLConnection)connection;
        attributes = jc.getMainAttributes();
        String os = Library.os();
        String arch = Library.arch();
        String manifestOS = attributes.getValue("SWT-OS");
        String manifestArch = attributes.getValue("SWT-Arch");
        return arch.equals(manifestArch) && os.equals(manifestOS);
    }

    static boolean load(String libName, StringBuilder message) {
        try {
            if (libName.contains(SEPARATOR)) {
                System.load(libName);
            } else {
                System.loadLibrary(libName);
            }
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            if (message.length() == 0) {
                message.append(DELIMITER);
            }
            message.append('\t');
            message.append(e.getMessage());
            message.append(DELIMITER);
            return false;
        }
    }

    public static void loadLibrary(String name) {
        Library.loadLibrary(name, true);
    }

    public static void loadLibrary(String name, boolean mapName) {
        int i;
        String prop = System.getProperty("sun.arch.data.model");
        if (prop == null) {
            prop = System.getProperty("com.ibm.vm.bitmode");
        }
        if (prop != null && "32".equals(prop)) {
            throw new UnsatisfiedLinkError("Cannot load 64-bit SWT libraries on 32-bit JVM");
        }
        String[] libNames = new String[3];
        String[] mappedNames = new String[3];
        if (mapName) {
            String version = Library.getVersionString();
            libNames[0] = String.valueOf(name) + "-" + "cocoa" + "-" + version;
            libNames[1] = String.valueOf(name) + "-" + "cocoa";
            libNames[2] = name;
            int i2 = 0;
            while (i2 < 3) {
                mappedNames[i2] = Library.mapLibraryName(libNames[i2]);
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < 3) {
                libNames[i3] = mappedNames[i3] = name;
                ++i3;
            }
        }
        StringBuilder message = new StringBuilder();
        String path = System.getProperty(SWT_LIB_PATH);
        if (path != null) {
            path = new File(path).getAbsolutePath();
            i = 0;
            while (i < 3) {
                if ((i == 0 || mapName) && Library.load(String.valueOf(path) + SEPARATOR + mappedNames[i], message)) {
                    return;
                }
                ++i;
            }
        }
        i = 0;
        while (i < 3) {
            if ((i == 0 || mapName) && Library.load(libNames[i], message)) {
                return;
            }
            ++i;
        }
        String[] fileNames = new String[3];
        int i4 = 0;
        while (i4 < 3) {
            fileNames[i4] = mappedNames[i4];
            ++i4;
        }
        if (path == null) {
            int i5;
            path = USER_HOME;
            File dir = new File(path, SWT_LIB_DIR);
            if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
                path = dir.getAbsolutePath();
            } else {
                i5 = 0;
                while (i5 < 3) {
                    fileNames[i5] = Library.mapLibraryName(String.valueOf(libNames[i5]) + SUFFIX_64);
                    ++i5;
                }
            }
            i5 = 0;
            while (i5 < 3) {
                if ((i5 == 0 || mapName) && Library.load(String.valueOf(path) + SEPARATOR + fileNames[i5], message)) {
                    return;
                }
                ++i5;
            }
        }
        if (path != null) {
            i = 0;
            while (i < 3) {
                if ((i == 0 || mapName) && Library.extract(String.valueOf(path) + SEPARATOR + fileNames[i], mappedNames[i]) && Library.load(String.valueOf(path) + SEPARATOR + fileNames[i], message)) {
                    return;
                }
                ++i;
            }
        }
        throw new UnsatisfiedLinkError("Could not load SWT library. Reasons: " + message.toString());
    }

    static String mapLibraryName(String libName) {
        return Library.mapLibraryName(libName, true);
    }

    static String mapLibraryName(String libName, boolean replaceDylib) {
        String ext;
        if ((libName = System.mapLibraryName(libName)).endsWith(ext = ".dylib") && replaceDylib) {
            libName = String.valueOf(libName.substring(0, libName.length() - ext.length())) + ".jnilib";
        }
        return libName;
    }

    public static String getVersionString() {
        String version = System.getProperty("swt.version");
        if (version == null) {
            version = "" + MAJOR_VERSION;
            if (MINOR_VERSION < 10) {
                version = String.valueOf(version) + "00";
            } else if (MINOR_VERSION < 100) {
                version = String.valueOf(version) + "0";
            }
            version = String.valueOf(version) + MINOR_VERSION;
            if (REVISION > 0) {
                version = String.valueOf(version) + "r" + REVISION;
            }
        }
        return version;
    }
}

