/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Terms;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MapSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;

public abstract class Maps {
    private Maps() {
    }

    public static ColumnSpecification keySpecOf(ColumnSpecification column) {
        return new ColumnSpecification(column.ksName, column.cfName, new ColumnIdentifier("key(" + column.name + ")", true), Maps.keysType(column.type));
    }

    public static ColumnSpecification valueSpecOf(ColumnSpecification column) {
        return new ColumnSpecification(column.ksName, column.cfName, new ColumnIdentifier("value(" + column.name + ")", true), Maps.valuesType(column.type));
    }

    private static AbstractType<?> unwrap(AbstractType<?> type) {
        return type.isReversed() ? Maps.unwrap(((ReversedType)type).baseType) : type;
    }

    private static AbstractType<?> keysType(AbstractType<?> type) {
        return ((MapType)Maps.unwrap(type)).getKeysType();
    }

    private static AbstractType<?> valuesType(AbstractType<?> type) {
        return ((MapType)Maps.unwrap(type)).getValuesType();
    }

    public static <T extends AssignmentTestable> AssignmentTestable.TestResult testMapAssignment(ColumnSpecification receiver, List<Pair<T, T>> entries) {
        ColumnSpecification keySpec = Maps.keySpecOf(receiver);
        ColumnSpecification valueSpec = Maps.valueSpecOf(receiver);
        AssignmentTestable.TestResult res = AssignmentTestable.TestResult.EXACT_MATCH;
        for (Pair<T, T> entry : entries) {
            AssignmentTestable.TestResult t1 = ((AssignmentTestable)entry.left).testAssignment(receiver.ksName, keySpec);
            AssignmentTestable.TestResult t2 = ((AssignmentTestable)entry.right).testAssignment(receiver.ksName, valueSpec);
            if (t1 == AssignmentTestable.TestResult.NOT_ASSIGNABLE || t2 == AssignmentTestable.TestResult.NOT_ASSIGNABLE) {
                return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
            }
            if (t1 == AssignmentTestable.TestResult.EXACT_MATCH && t2 == AssignmentTestable.TestResult.EXACT_MATCH) continue;
            res = AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
        }
        return res;
    }

    public static <T> String mapToString(List<Pair<T, T>> entries) {
        return Maps.mapToString(entries, Object::toString);
    }

    public static <T> String mapToString(List<Pair<T, T>> items, java.util.function.Function<T, String> mapper) {
        return items.stream().map(p -> String.format("%s: %s", mapper.apply(p.left), mapper.apply(p.right))).collect(Collectors.joining(", ", "{", "}"));
    }

    public static <T> AbstractType<?> getExactMapTypeIfKnown(List<Pair<T, T>> entries, java.util.function.Function<T, AbstractType<?>> mapper) {
        AbstractType<?> keyType = null;
        AbstractType<?> valueType = null;
        for (Pair<T, T> entry : entries) {
            if (keyType == null) {
                keyType = mapper.apply(entry.left);
            }
            if (valueType == null) {
                valueType = mapper.apply(entry.right);
            }
            if (keyType == null || valueType == null) continue;
            return MapType.getInstance(keyType, valueType, false);
        }
        return null;
    }

    public static class DiscarderByKey
    extends Operation {
        public DiscarderByKey(ColumnMetadata column, Term k) {
            super(column, k);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            assert (this.column.type.isMultiCell()) : "Attempted to delete a single key in a frozen map";
            Term.Terminal key = this.t.bind(params.options);
            if (key == null) {
                throw new InvalidRequestException("Invalid null map key");
            }
            if (key == Constants.UNSET_VALUE) {
                throw new InvalidRequestException("Invalid unset map key");
            }
            params.addTombstone(this.column, CellPath.create(key.get(params.options.getProtocolVersion())));
        }
    }

    public static class Putter
    extends Operation {
        public Putter(ColumnMetadata column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            assert (this.column.type.isMultiCell()) : "Attempted to add items to a frozen map";
            Term.Terminal value = this.t.bind(params.options);
            if (value != Constants.UNSET_VALUE) {
                Putter.doPut(value, this.column, params);
            }
        }

        static void doPut(Term.Terminal value, ColumnMetadata column, UpdateParameters params) throws InvalidRequestException {
            if (column.type.isMultiCell()) {
                if (value == null) {
                    return;
                }
                SortedMap<ByteBuffer, ByteBuffer> elements = ((Value)value).map;
                for (Map.Entry<ByteBuffer, ByteBuffer> entry : elements.entrySet()) {
                    params.addCell(column, CellPath.create(entry.getKey()), entry.getValue());
                }
            } else if (value == null) {
                params.addTombstone(column);
            } else {
                params.addCell(column, value.get(ProtocolVersion.CURRENT));
            }
        }
    }

    public static class SetterByKey
    extends Operation {
        private final Term k;

        public SetterByKey(ColumnMetadata column, Term k, Term t) {
            super(column, t);
            this.k = k;
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
            super.collectMarkerSpecification(boundNames);
            this.k.collectMarkerSpecification(boundNames);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            assert (this.column.type.isMultiCell()) : "Attempted to set a value for a single key on a frozen map";
            ByteBuffer key = this.k.bindAndGet(params.options);
            ByteBuffer value = this.t.bindAndGet(params.options);
            if (key == null) {
                throw new InvalidRequestException("Invalid null map key");
            }
            if (key == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                throw new InvalidRequestException("Invalid unset map key");
            }
            CellPath path = CellPath.create(key);
            if (value == null) {
                params.addTombstone(this.column, path);
            } else if (value != ByteBufferUtil.UNSET_BYTE_BUFFER) {
                params.addCell(this.column, path, value);
            }
        }
    }

    public static class Setter
    extends Operation {
        public Setter(ColumnMetadata column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            Term.Terminal value = this.t.bind(params.options);
            if (value == Constants.UNSET_VALUE) {
                return;
            }
            if (this.column.type.isMultiCell()) {
                params.setComplexDeletionTimeForOverwrite(this.column);
            }
            Putter.doPut(value, this.column, params);
        }
    }

    public static class Marker
    extends AbstractMarker {
        protected Marker(int bindIndex, ColumnSpecification receiver) {
            super(bindIndex, receiver);
            assert (receiver.type instanceof MapType);
        }

        @Override
        public Term.Terminal bind(QueryOptions options) throws InvalidRequestException {
            ByteBuffer value = options.getValues().get(this.bindIndex);
            if (value == null) {
                return null;
            }
            if (value == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                return Constants.UNSET_VALUE;
            }
            return Value.fromSerialized(value, (MapType)this.receiver.type, options.getProtocolVersion());
        }
    }

    public static class DelayedValue
    extends Term.NonTerminal {
        private final Comparator<ByteBuffer> comparator;
        private final Map<Term, Term> elements;

        public DelayedValue(Comparator<ByteBuffer> comparator, Map<Term, Term> elements) {
            this.comparator = comparator;
            this.elements = elements;
        }

        @Override
        public boolean containsBindMarker() {
            return false;
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
        }

        @Override
        public Term.Terminal bind(QueryOptions options) throws InvalidRequestException {
            TreeMap<ByteBuffer, ByteBuffer> buffers = new TreeMap<ByteBuffer, ByteBuffer>(this.comparator);
            for (Map.Entry<Term, Term> entry : this.elements.entrySet()) {
                ByteBuffer keyBytes = entry.getKey().bindAndGet(options);
                if (keyBytes == null) {
                    throw new InvalidRequestException("null is not supported inside collections");
                }
                if (keyBytes == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                    throw new InvalidRequestException("unset value is not supported for map keys");
                }
                ByteBuffer valueBytes = entry.getValue().bindAndGet(options);
                if (valueBytes == null) {
                    throw new InvalidRequestException("null is not supported inside collections");
                }
                if (valueBytes == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                    return Constants.UNSET_VALUE;
                }
                buffers.put(keyBytes, valueBytes);
            }
            return new Value(buffers);
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
            Terms.addFunctions(this.elements.keySet(), functions);
            Terms.addFunctions(this.elements.values(), functions);
        }
    }

    public static class Value
    extends Term.Terminal {
        public final SortedMap<ByteBuffer, ByteBuffer> map;

        public Value(SortedMap<ByteBuffer, ByteBuffer> map) {
            this.map = map;
        }

        public static Value fromSerialized(ByteBuffer value, MapType type, ProtocolVersion version) throws InvalidRequestException {
            try {
                Object m = ((MapSerializer)type.getSerializer()).deserializeForNativeProtocol(value, (ValueAccessor)ByteBufferAccessor.instance, version);
                TreeMap<ByteBuffer, ByteBuffer> map = new TreeMap<ByteBuffer, ByteBuffer>(type.getKeysType());
                for (Map.Entry entry : m.entrySet()) {
                    map.put(type.getKeysType().decompose(entry.getKey()), type.getValuesType().decompose(entry.getValue()));
                }
                return new Value(map);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }

        @Override
        public ByteBuffer get(ProtocolVersion protocolVersion) {
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(2 * this.map.size());
            for (Map.Entry<ByteBuffer, ByteBuffer> entry : this.map.entrySet()) {
                buffers.add(entry.getKey());
                buffers.add(entry.getValue());
            }
            return CollectionSerializer.pack(buffers, this.map.size(), protocolVersion);
        }

        public boolean equals(MapType mt, Value v) {
            if (this.map.size() != v.map.size()) {
                return false;
            }
            Iterator<Map.Entry<ByteBuffer, ByteBuffer>> thisIter = this.map.entrySet().iterator();
            Iterator<Map.Entry<ByteBuffer, ByteBuffer>> thatIter = v.map.entrySet().iterator();
            while (thisIter.hasNext()) {
                Map.Entry<ByteBuffer, ByteBuffer> thisEntry = thisIter.next();
                Map.Entry<ByteBuffer, ByteBuffer> thatEntry = thatIter.next();
                if (mt.getKeysType().compare(thisEntry.getKey(), thatEntry.getKey()) == 0 && mt.getValuesType().compare(thisEntry.getValue(), thatEntry.getValue()) == 0) continue;
                return false;
            }
            return true;
        }
    }

    public static class Literal
    extends Term.Raw {
        public final List<Pair<Term.Raw, Term.Raw>> entries;

        public Literal(List<Pair<Term.Raw, Term.Raw>> entries) {
            this.entries = entries;
        }

        @Override
        public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            this.validateAssignableTo(keyspace, receiver);
            ColumnSpecification keySpec = Maps.keySpecOf(receiver);
            ColumnSpecification valueSpec = Maps.valueSpecOf(receiver);
            HashMap<Term, Term> values = new HashMap<Term, Term>(this.entries.size());
            boolean allTerminal = true;
            for (Pair<Term.Raw, Term.Raw> entry : this.entries) {
                Term k = ((Term.Raw)entry.left).prepare(keyspace, keySpec);
                Term v = ((Term.Raw)entry.right).prepare(keyspace, valueSpec);
                if (k.containsBindMarker() || v.containsBindMarker()) {
                    throw new InvalidRequestException(String.format("Invalid map literal for %s: bind variables are not supported inside collection literals", receiver.name));
                }
                if (k instanceof Term.NonTerminal || v instanceof Term.NonTerminal) {
                    allTerminal = false;
                }
                values.put(k, v);
            }
            DelayedValue value = new DelayedValue(Maps.keysType(receiver.type), values);
            return allTerminal ? value.bind(QueryOptions.DEFAULT) : value;
        }

        private void validateAssignableTo(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            AbstractType type = Maps.unwrap(receiver.type);
            if (!(type instanceof MapType)) {
                throw new InvalidRequestException(String.format("Invalid map literal for %s of type %s", receiver.name, receiver.type.asCQL3Type()));
            }
            ColumnSpecification keySpec = Maps.keySpecOf(receiver);
            ColumnSpecification valueSpec = Maps.valueSpecOf(receiver);
            for (Pair<Term.Raw, Term.Raw> entry : this.entries) {
                if (!((Term.Raw)entry.left).testAssignment(keyspace, keySpec).isAssignable()) {
                    throw new InvalidRequestException(String.format("Invalid map literal for %s: key %s is not of type %s", receiver.name, entry.left, keySpec.type.asCQL3Type()));
                }
                if (((Term.Raw)entry.right).testAssignment(keyspace, valueSpec).isAssignable()) continue;
                throw new InvalidRequestException(String.format("Invalid map literal for %s: value %s is not of type %s", receiver.name, entry.right, valueSpec.type.asCQL3Type()));
            }
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            return Maps.testMapAssignment(receiver, this.entries);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return Maps.getExactMapTypeIfKnown(this.entries, p -> p.getExactTypeIfKnown(keyspace));
        }

        @Override
        public String getText() {
            return Maps.mapToString(this.entries, Term.Raw::getText);
        }
    }
}

