/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions.types;

import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.functions.types.ParseUtils;

public class Metadata {
    static String handleId(String id) {
        if (id == null) {
            return null;
        }
        boolean isAlphanumericLowCase = true;
        boolean isAlphanumeric = true;
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                isAlphanumericLowCase = false;
                continue;
            }
            if (c >= '0' && c <= '9' || c == '_' || c >= 'a' && c <= 'z') continue;
            isAlphanumeric = false;
            isAlphanumericLowCase = false;
            break;
        }
        if (isAlphanumericLowCase) {
            return id;
        }
        if (isAlphanumeric) {
            return id.toLowerCase();
        }
        return ParseUtils.unDoubleQuote(id);
    }

    static String quoteIfNecessary(String id) {
        return ColumnIdentifier.maybeQuote(id);
    }

    public static String quote(String id) {
        return ParseUtils.doubleQuote(id);
    }
}

