/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.selection.Selectable;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SimpleSelector;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;

final class SelectorFactories
implements Iterable<Selector.Factory> {
    private final List<Selector.Factory> factories;
    private boolean containsWritetimeFactory;
    private boolean containsTTLFactory;
    private int numberOfAggregateFactories;

    public static SelectorFactories createFactoriesAndCollectColumnDefinitions(List<Selectable> selectables, List<AbstractType<?>> expectedTypes, TableMetadata table, List<ColumnMetadata> defs, VariableSpecifications boundNames) throws InvalidRequestException {
        return new SelectorFactories(selectables, expectedTypes, table, defs, boundNames);
    }

    private SelectorFactories(List<Selectable> selectables, List<AbstractType<?>> expectedTypes, TableMetadata table, List<ColumnMetadata> defs, VariableSpecifications boundNames) throws InvalidRequestException {
        this.factories = new ArrayList<Selector.Factory>(selectables.size());
        for (int i = 0; i < selectables.size(); ++i) {
            Selectable selectable = selectables.get(i);
            AbstractType<?> expectedType = expectedTypes == null ? null : expectedTypes.get(i);
            Selector.Factory factory = selectable.newSelectorFactory(table, expectedType, defs, boundNames);
            this.containsWritetimeFactory |= factory.isWritetimeSelectorFactory();
            this.containsTTLFactory |= factory.isTTLSelectorFactory();
            if (factory.isAggregateSelectorFactory()) {
                ++this.numberOfAggregateFactories;
            }
            this.factories.add(factory);
        }
    }

    public void addFunctionsTo(List<org.apache.cassandra.cql3.functions.Function> functions) {
        this.factories.forEach(p -> p.addFunctionsTo(functions));
    }

    public Selector.Factory get(int i) {
        return this.factories.get(i);
    }

    public int indexOfSimpleSelectorFactory(int columnIndex) {
        int m = this.factories.size();
        for (int i = 0; i < m; ++i) {
            if (!this.factories.get(i).isSimpleSelectorFactoryFor(columnIndex)) continue;
            return i;
        }
        return -1;
    }

    public void addSelectorForOrdering(ColumnMetadata def, int index) {
        this.factories.add(SimpleSelector.newFactory(def, index));
    }

    public boolean doesAggregation() {
        return this.numberOfAggregateFactories > 0;
    }

    public boolean containsWritetimeSelectorFactory() {
        return this.containsWritetimeFactory;
    }

    public boolean containsTTLSelectorFactory() {
        return this.containsTTLFactory;
    }

    public List<Selector> newInstances(QueryOptions options) throws InvalidRequestException {
        ArrayList<Selector> selectors = new ArrayList<Selector>(this.factories.size());
        for (Selector.Factory factory : this.factories) {
            selectors.add(factory.newInstance(options));
        }
        return selectors;
    }

    @Override
    public Iterator<Selector.Factory> iterator() {
        return this.factories.iterator();
    }

    public List<String> getColumnNames() {
        return Lists.transform(this.factories, (Function)new Function<Selector.Factory, String>(){

            public String apply(Selector.Factory factory) {
                return factory.getColumnName();
            }
        });
    }

    public List<AbstractType<?>> getReturnTypes() {
        return Lists.transform(this.factories, (Function)new Function<Selector.Factory, AbstractType<?>>(){

            public AbstractType<?> apply(Selector.Factory factory) {
                return factory.getReturnType();
            }
        });
    }

    boolean areAllFetchedColumnsKnown() {
        for (Selector.Factory factory : this.factories) {
            if (factory.areAllFetchedColumnsKnown()) continue;
            return false;
        }
        return true;
    }

    void addFetchedColumns(ColumnFilter.Builder builder) {
        for (Selector.Factory factory : this.factories) {
            factory.addFetchedColumns(builder);
        }
    }

    public int size() {
        return this.factories.size();
    }
}

