/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import java.net.InetSocketAddress;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.metrics.ClientMetrics;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.transport.ConnectedClient;

final class ClientsTable
extends AbstractVirtualTable {
    private static final String ADDRESS = "address";
    private static final String PORT = "port";
    private static final String HOSTNAME = "hostname";
    private static final String USERNAME = "username";
    private static final String CONNECTION_STAGE = "connection_stage";
    private static final String PROTOCOL_VERSION = "protocol_version";
    private static final String DRIVER_NAME = "driver_name";
    private static final String DRIVER_VERSION = "driver_version";
    private static final String REQUEST_COUNT = "request_count";
    private static final String SSL_ENABLED = "ssl_enabled";
    private static final String SSL_PROTOCOL = "ssl_protocol";
    private static final String SSL_CIPHER_SUITE = "ssl_cipher_suite";

    ClientsTable(String keyspace) {
        super(TableMetadata.builder(keyspace, "clients").comment("currently connected clients").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(InetAddressType.instance)).addPartitionKeyColumn(ADDRESS, (AbstractType)InetAddressType.instance).addClusteringColumn(PORT, (AbstractType)Int32Type.instance).addRegularColumn(HOSTNAME, (AbstractType)UTF8Type.instance).addRegularColumn(USERNAME, (AbstractType)UTF8Type.instance).addRegularColumn(CONNECTION_STAGE, (AbstractType)UTF8Type.instance).addRegularColumn(PROTOCOL_VERSION, (AbstractType)Int32Type.instance).addRegularColumn(DRIVER_NAME, (AbstractType)UTF8Type.instance).addRegularColumn(DRIVER_VERSION, (AbstractType)UTF8Type.instance).addRegularColumn(REQUEST_COUNT, (AbstractType)LongType.instance).addRegularColumn(SSL_ENABLED, (AbstractType)BooleanType.instance).addRegularColumn(SSL_PROTOCOL, (AbstractType)UTF8Type.instance).addRegularColumn(SSL_CIPHER_SUITE, (AbstractType)UTF8Type.instance).build());
    }

    @Override
    public AbstractVirtualTable.DataSet data() {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        for (ConnectedClient client : ClientMetrics.instance.allConnectedClients()) {
            InetSocketAddress remoteAddress = client.remoteAddress();
            result.row(remoteAddress.getAddress(), remoteAddress.getPort()).column(HOSTNAME, remoteAddress.getHostName()).column(USERNAME, client.username().orElse(null)).column(CONNECTION_STAGE, client.stage().toString().toLowerCase()).column(PROTOCOL_VERSION, client.protocolVersion()).column(DRIVER_NAME, client.driverName().orElse(null)).column(DRIVER_VERSION, client.driverVersion().orElse(null)).column(REQUEST_COUNT, client.requestCount()).column(SSL_ENABLED, client.sslEnabled()).column(SSL_PROTOCOL, client.sslProtocol().orElse(null)).column(SSL_CIPHER_SUITE, client.sslCipherSuite().orElse(null));
        }
        return result;
    }
}

