/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht.tokenallocator;

import java.util.NavigableMap;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.dht.tokenallocator.NoReplicationTokenAllocator;
import org.apache.cassandra.dht.tokenallocator.ReplicationAwareTokenAllocator;
import org.apache.cassandra.dht.tokenallocator.ReplicationStrategy;
import org.apache.cassandra.dht.tokenallocator.TokenAllocator;
import org.apache.cassandra.dht.tokenallocator.TokenAllocatorDiagnostics;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAllocatorFactory {
    private static final Logger logger = LoggerFactory.getLogger(TokenAllocatorFactory.class);

    public static TokenAllocator<InetAddressAndPort> createTokenAllocator(NavigableMap<Token, InetAddressAndPort> sortedTokens, ReplicationStrategy<InetAddressAndPort> strategy, IPartitioner partitioner) {
        if (strategy.replicas() == 1) {
            logger.info("Using NoReplicationTokenAllocator.");
            NoReplicationTokenAllocator<InetAddressAndPort> allocator = new NoReplicationTokenAllocator<InetAddressAndPort>(sortedTokens, strategy, partitioner);
            TokenAllocatorDiagnostics.noReplicationTokenAllocatorInstanciated(allocator);
            return allocator;
        }
        logger.info("Using ReplicationAwareTokenAllocator.");
        ReplicationAwareTokenAllocator<InetAddressAndPort> allocator = new ReplicationAwareTokenAllocator<InetAddressAndPort>(sortedTokens, strategy, partitioner);
        TokenAllocatorDiagnostics.replicationTokenAllocatorInstanciated(allocator);
        return allocator;
    }
}

