/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.cassandra.locator.AbstractReplicaCollection;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaCollection;
import org.apache.cassandra.utils.FBUtilities;

public abstract class Endpoints<E extends Endpoints<E>>
extends AbstractReplicaCollection<E> {
    static final AbstractReplicaCollection.ReplicaMap<InetAddressAndPort> EMPTY_MAP = Endpoints.endpointMap(EMPTY_LIST);
    AbstractReplicaCollection.ReplicaMap<InetAddressAndPort> byEndpoint;

    static AbstractReplicaCollection.ReplicaMap<InetAddressAndPort> endpointMap(AbstractReplicaCollection.ReplicaList list) {
        return new AbstractReplicaCollection.ReplicaMap<InetAddressAndPort>(list, Replica::endpoint);
    }

    Endpoints(AbstractReplicaCollection.ReplicaList list, AbstractReplicaCollection.ReplicaMap<InetAddressAndPort> byEndpoint) {
        super(list);
        this.byEndpoint = byEndpoint;
    }

    @Override
    public Set<InetAddressAndPort> endpoints() {
        return this.byEndpoint().keySet();
    }

    public List<InetAddressAndPort> endpointList() {
        return new AbstractList<InetAddressAndPort>(){

            @Override
            public InetAddressAndPort get(int index) {
                return Endpoints.this.list.get(index).endpoint();
            }

            @Override
            public int size() {
                return Endpoints.this.list.size;
            }
        };
    }

    public Map<InetAddressAndPort, Replica> byEndpoint() {
        AbstractReplicaCollection.ReplicaMap<InetAddressAndPort> map = this.byEndpoint;
        if (map == null) {
            this.byEndpoint = map = Endpoints.endpointMap(this.list);
        }
        return map;
    }

    @Override
    public boolean contains(Replica replica) {
        return replica != null && Objects.equals(this.byEndpoint().get(replica.endpoint()), replica);
    }

    public E withoutSelf() {
        InetAddressAndPort self = FBUtilities.getBroadcastAddressAndPort();
        return (E)((Endpoints)this.filter(r -> !self.equals(r.endpoint())));
    }

    public Replica selfIfPresent() {
        InetAddressAndPort self = FBUtilities.getBroadcastAddressAndPort();
        return this.byEndpoint().get(self);
    }

    public E without(Set<InetAddressAndPort> remove) {
        return (E)((Endpoints)this.filter(r -> !remove.contains(r.endpoint())));
    }

    public E keep(Set<InetAddressAndPort> keep) {
        return (E)((Endpoints)this.filter(r -> keep.contains(r.endpoint())));
    }

    public E select(Iterable<InetAddressAndPort> endpoints, boolean ignoreMissing) {
        ReplicaCollection.Builder copy = this.newBuilder(endpoints instanceof Collection ? ((Collection)endpoints).size() : this.size());
        Map<InetAddressAndPort, Replica> byEndpoint = this.byEndpoint();
        for (InetAddressAndPort endpoint : endpoints) {
            Replica select = byEndpoint.get(endpoint);
            if (select == null) {
                if (ignoreMissing) continue;
                throw new IllegalArgumentException(endpoint + " is not present in " + this);
            }
            copy.add(select, ReplicaCollection.Builder.Conflict.DUPLICATE);
        }
        return (E)((Endpoints)copy.build());
    }

    public static <E extends Endpoints<E>> E concat(E natural, E pending) {
        return AbstractReplicaCollection.concat(natural, pending, ReplicaCollection.Builder.Conflict.NONE);
    }

    public static <E extends Endpoints<E>> E append(E replicas, Replica extraReplica) {
        ReplicaCollection.Builder builder = replicas.newBuilder(replicas.size() + 1);
        builder.addAll(replicas);
        builder.add(extraReplica, ReplicaCollection.Builder.Conflict.NONE);
        return (E)((Endpoints)builder.build());
    }
}

