/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ErrnoException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IFSFileDescriptorImplRemote;
import com.ibm.as400.access.IFSIoctlRep;
import com.ibm.as400.access.IFSIoctlReq;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Trace;
import java.io.IOException;

public class UDFS {
    private AS400 system_;
    private String path_;
    private String storageUnit_;
    private IFSFileDescriptorImplRemote fd_ = new IFSFileDescriptorImplRemote();

    public UDFS(AS400 aS400, String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing UDFS object, system: " + aS400 + " path: " + string);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        this.system_ = aS400;
        this.path_ = string;
    }

    public void create() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Creating UDFS.");
        }
        StringBuffer stringBuffer = new StringBuffer("CRTUDFS UDFS('" + this.path_ + "')");
        if (this.storageUnit_ != null && !this.storageUnit_.equalsIgnoreCase("*ANY")) {
            if (this.system_.getVRM() >= 459008) {
                stringBuffer.append(" UNIT(" + this.storageUnit_ + ")");
            } else if (Trace.traceOn_) {
                Trace.log(4, "setPreferredStorageUnit(*SSD) is not supported prior to IBM i 7.1.");
            }
        }
        this.runCommand(stringBuffer.toString());
    }

    public void create(String string, String[] stringArray, String string2, String string3, boolean bl, String string4, String string5, String string6, String string7, String string8) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Creating UDFS.");
        }
        int n = this.system_.getVRM();
        StringBuffer stringBuffer = new StringBuffer("CRTUDFS UDFS('" + this.path_ + "')");
        stringBuffer.append(" DTAAUT(" + string + ")");
        stringBuffer.append(" OBJAUT(" + UDFS.setArrayToString(stringArray) + ")");
        stringBuffer.append(" CRTOBJAUD(" + string2 + ")");
        if (n >= 328448) {
            stringBuffer.append(" CRTOBJSCAN(" + string3 + ")");
            stringBuffer.append(" RSTDRNMUNL(" + (bl ? "*YES" : "*NO") + ")");
        }
        if (n >= 393472) {
            stringBuffer.append(" DFTDISKSTG(" + string4 + ")");
            stringBuffer.append(" DFTMAINSTG(" + string5 + ")");
        }
        stringBuffer.append(" CASE(" + string6 + ")");
        stringBuffer.append(" DFTFILEFMT(" + string7 + ")");
        stringBuffer.append(" TEXT('" + string8 + "')");
        if (this.storageUnit_ != null && !this.storageUnit_.equalsIgnoreCase("*ANY")) {
            if (n >= 459008) {
                stringBuffer.append(" UNIT(" + this.storageUnit_ + ")");
            } else if (Trace.traceOn_) {
                Trace.log(4, "setPreferredStorageUnit(*SSD) is not supported prior to IBM i 7.1.");
            }
        }
        this.runCommand(stringBuffer.toString());
    }

    public void delete() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Deleting UDFS.");
        }
        this.runCommand("DLTUDFS UDFS('" + this.path_ + "')");
    }

    public void mount(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Mounting UDFS.");
        }
        this.runCommand("ADDMFS TYPE(*UDFS) MFS('" + this.path_ + "') MNTOVRDIR('" + string + "')");
    }

    public void mount(String string, boolean bl, boolean bl2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Mounting UDFS.");
        }
        this.runCommand("ADDMFS TYPE(*UDFS) MFS('" + this.path_ + "') MNTOVRDIR('" + string + "') OPTIONS('" + (bl ? "rw," : "ro,") + (bl2 ? "suid" : "nosuid") + "')");
    }

    public void unmount() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Unmounting UDFS.");
        }
        this.runCommand("RMVMFS TYPE(*UDFS) MFS('" + this.path_ + "')");
    }

    private static String setArrayToString(String[] stringArray) {
        int n = stringArray.length;
        if (n == 0) {
            return "*INDIR";
        }
        if (n == 1) {
            return stringArray[0];
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private void runCommand(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        CommandCall commandCall = new CommandCall(this.system_, string);
        commandCall.suggestThreadsafe(false);
        if (!commandCall.run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
    }

    private static byte[] createPathName(AS400 aS400, String string) throws IOException {
        string = string.replace('/', '\\');
        Converter converter = new Converter(1200, aS400);
        byte[] byArray = new byte[4 + string.length() * 2];
        BinaryConverter.intToByteArray(string.length() * 2, byArray, 0);
        converter.stringToByteArray(string, byArray, 4);
        return byArray;
    }

    public UdfsInformationStructure getUdfsInformationStructure() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.fd_.system_ = (AS400ImplRemote)this.system_.getImpl();
        this.fd_.connect();
        DataStream dataStream = this.fd_.server_.sendAndReceive(new IFSIoctlReq(1, UDFS.createPathName(this.system_, this.path_)));
        if (!(dataStream instanceof IFSIoctlRep)) {
            Trace.log(2, "Unknown reply datastream:", dataStream.data_);
            throw new InternalErrorException(2);
        }
        IFSIoctlRep iFSIoctlRep = (IFSIoctlRep)dataStream;
        return new UdfsInformationStructure(iFSIoctlRep.getReplyData());
    }

    public MountedFsInformationStructure getMountedFsInformationStructure() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.fd_.system_ = (AS400ImplRemote)this.system_.getImpl();
        this.fd_.connect();
        DataStream dataStream = this.fd_.server_.sendAndReceive(new IFSIoctlReq(4, UDFS.createPathName(this.system_, this.path_)));
        if (!(dataStream instanceof IFSIoctlRep)) {
            Trace.log(2, "Unknown reply datastream:", dataStream.data_);
            throw new InternalErrorException(2);
        }
        IFSIoctlRep iFSIoctlRep = (IFSIoctlRep)dataStream;
        return new MountedFsInformationStructure(iFSIoctlRep.getReplyData());
    }

    public void setPreferredStorageUnit(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting storage unit to " + string);
        }
        if (string == null || string.equalsIgnoreCase("*ANY")) {
            this.storageUnit_ = null;
        } else if (string.equalsIgnoreCase("*SSD")) {
            this.storageUnit_ = "*SSD";
        } else {
            throw new ExtendedIllegalArgumentException("storageUnit (" + string + ")", 2);
        }
    }

    static {
        AS400Server.addReplyStream((DataStream)new IFSIoctlRep(), 0);
    }

    public class MountedFsInformationStructure {
        private boolean idUdfs_;
        private boolean isMounted_;

        public boolean isUdfs() {
            return this.idUdfs_;
        }

        public boolean isMounted() {
            return this.isMounted_;
        }

        private MountedFsInformationStructure(byte[] byArray) throws ErrorCompletingRequestException {
            int n = BinaryConverter.byteArrayToInt(byArray, 0);
            if (n != 0) {
                Trace.log(2, "Get mounted FS information structure was not successful, errno:", n);
                throw new ErrnoException(UDFS.this.system_, n);
            }
            this.idUdfs_ = byArray[4] != 0;
            this.isMounted_ = byArray[5] != 0;
        }
    }

    public class UdfsInformationStructure {
        private String owner_;
        private int ccsid_;
        private String caseSensitivity_;
        private String description_;
        private String pathWhereMounted_;

        public String getOwner() {
            return this.owner_;
        }

        public int getCcsid() {
            return this.ccsid_;
        }

        public String getCaseSensitivity() {
            return this.caseSensitivity_;
        }

        public String getDescription() {
            return this.description_;
        }

        public String getPathWhereMounted() {
            return this.pathWhereMounted_;
        }

        private UdfsInformationStructure(byte[] byArray) throws ErrorCompletingRequestException, IOException {
            Converter converter = new Converter(1200, UDFS.this.system_);
            Converter converter2 = new Converter(37, UDFS.this.system_);
            int n = BinaryConverter.byteArrayToInt(byArray, 0);
            if (n != 0) {
                Trace.log(2, "Get UDFS information structure was not successful, errno:", n);
                throw new ErrnoException(UDFS.this.system_, n);
            }
            this.owner_ = converter2.byteArrayToString(byArray, 4, 10).trim();
            this.ccsid_ = BinaryConverter.byteArrayToUnsignedShort(byArray, 14);
            this.caseSensitivity_ = byArray[16] == 0 ? "*MONO" : "*MIXED";
            byte by = byArray[19];
            this.description_ = converter2.byteArrayToString(byArray, 21, by).trim();
            this.pathWhereMounted_ = converter.byteArrayToString(byArray, 121, byArray.length - 121);
        }
    }
}

