/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.submodule;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;

public class SubmoduleValidator {
    public static void assertValidSubmoduleName(String name) throws SubmoduleValidationException {
        if (name.contains("/../") || name.contains("\\..\\") || name.startsWith("../") || name.startsWith("..\\") || name.endsWith("/..") || name.endsWith("\\..")) {
            throw new SubmoduleValidationException(MessageFormat.format(JGitText.get().invalidNameContainsDotDot, name));
        }
        if (name.startsWith("-")) {
            throw new SubmoduleValidationException(MessageFormat.format(JGitText.get().submoduleNameInvalid, name));
        }
    }

    public static void assertValidSubmoduleUri(String uri) throws SubmoduleValidationException {
        if (uri.startsWith("-")) {
            throw new SubmoduleValidationException(MessageFormat.format(JGitText.get().submoduleUrlInvalid, uri));
        }
    }

    public static void assertValidSubmodulePath(String path) throws SubmoduleValidationException {
        if (path.startsWith("-")) {
            throw new SubmoduleValidationException(MessageFormat.format(JGitText.get().submodulePathInvalid, path));
        }
    }

    public static void assertValidGitModulesFile(String gitModulesContents) throws IOException {
        Config c = new Config();
        try {
            c.fromText(gitModulesContents);
            for (String subsection : c.getSubsections("submodule")) {
                String path;
                SubmoduleValidator.assertValidSubmoduleName(subsection);
                String url = c.getString("submodule", subsection, "url");
                if (url != null) {
                    SubmoduleValidator.assertValidSubmoduleUri(url);
                }
                if ((path = c.getString("submodule", subsection, "path")) == null) continue;
                SubmoduleValidator.assertValidSubmodulePath(path);
            }
        }
        catch (ConfigInvalidException e) {
            throw new IOException(MessageFormat.format(JGitText.get().invalidGitModules, e));
        }
        catch (SubmoduleValidationException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static class SubmoduleValidationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public SubmoduleValidationException(String message) {
            super(message);
        }
    }
}

