/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.FetchV2Request;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.TransferConfig;

final class ProtocolV2Parser {
    private final TransferConfig transferConfig;

    ProtocolV2Parser(TransferConfig transferConfig) {
        this.transferConfig = transferConfig;
    }

    FetchV2Request parseFetchRequest(PacketLineIn pckIn) throws PackProtocolException, IOException {
        FetchV2Request.Builder reqBuilder = FetchV2Request.builder();
        reqBuilder.addOption("side-band-64k");
        String line = pckIn.readString();
        if (line != PacketLineIn.DELIM) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line));
        }
        boolean filterReceived = false;
        while ((line = pckIn.readString()) != PacketLineIn.END) {
            if (line.startsWith("want ")) {
                reqBuilder.addWantsId(ObjectId.fromString(line.substring(5)));
                continue;
            }
            if (this.transferConfig.isAllowRefInWant() && line.startsWith("want-ref ")) {
                reqBuilder.addWantedRef(line.substring("want-ref".length() + 1));
                continue;
            }
            if (line.startsWith("have ")) {
                reqBuilder.addPeerHas(ObjectId.fromString(line.substring(5)));
                continue;
            }
            if (line.equals("done")) {
                reqBuilder.setDoneReceived();
                continue;
            }
            if (line.equals("thin-pack")) {
                reqBuilder.addOption("thin-pack");
                continue;
            }
            if (line.equals("no-progress")) {
                reqBuilder.addOption("no-progress");
                continue;
            }
            if (line.equals("include-tag")) {
                reqBuilder.addOption("include-tag");
                continue;
            }
            if (line.equals("ofs-delta")) {
                reqBuilder.addOption("ofs-delta");
                continue;
            }
            if (line.startsWith("shallow ")) {
                reqBuilder.addClientShallowCommit(ObjectId.fromString(line.substring(8)));
                continue;
            }
            if (line.startsWith("deepen ")) {
                int parsedDepth = Integer.parseInt(line.substring(7));
                if (parsedDepth <= 0) {
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidDepth, parsedDepth));
                }
                if (reqBuilder.getDeepenSince() != 0) {
                    throw new PackProtocolException(JGitText.get().deepenSinceWithDeepen);
                }
                if (reqBuilder.hasDeepenNotRefs()) {
                    throw new PackProtocolException(JGitText.get().deepenNotWithDeepen);
                }
                reqBuilder.setDepth(parsedDepth);
                continue;
            }
            if (line.startsWith("deepen-not ")) {
                reqBuilder.addDeepenNotRef(line.substring(11));
                if (reqBuilder.getDepth() == 0) continue;
                throw new PackProtocolException(JGitText.get().deepenNotWithDeepen);
            }
            if (line.equals("deepen-relative")) {
                reqBuilder.addOption("deepen-relative");
                continue;
            }
            if (line.startsWith("deepen-since ")) {
                int ts = Integer.parseInt(line.substring(13));
                if (ts <= 0) {
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidTimestamp, line));
                }
                if (reqBuilder.getDepth() != 0) {
                    throw new PackProtocolException(JGitText.get().deepenSinceWithDeepen);
                }
                reqBuilder.setDeepenSince(ts);
                continue;
            }
            if (this.transferConfig.isAllowFilter() && line.startsWith("filter ")) {
                if (filterReceived) {
                    throw new PackProtocolException(JGitText.get().tooManyFilters);
                }
                filterReceived = true;
                reqBuilder.setFilterBlobLimit(ProtocolV2Parser.filterLine(line.substring("filter".length() + 1)));
                continue;
            }
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line));
        }
        return reqBuilder.build();
    }

    static long filterLine(String blobLine) throws PackProtocolException {
        long blobLimit = -1L;
        if (blobLine.equals("blob:none")) {
            blobLimit = 0L;
        } else if (blobLine.startsWith("blob:limit=")) {
            try {
                blobLimit = Long.parseLong(blobLine.substring("blob:limit=".length()));
            }
            catch (NumberFormatException e) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidFilter, blobLine));
            }
        }
        if (blobLimit < 0L) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidFilter, blobLine));
        }
        return blobLimit;
    }
}

