/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.IOException;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.asyncqueue.PushBackHandler;
import org.glassfish.grizzly.asyncqueue.WritableMessage;

public interface Writer<L> {
    public GrizzlyFuture<WriteResult<WritableMessage, L>> write(Connection<L> var1, WritableMessage var2) throws IOException;

    public void write(Connection<L> var1, WritableMessage var2, CompletionHandler<WriteResult<WritableMessage, L>> var3);

    public GrizzlyFuture<WriteResult<WritableMessage, L>> write(Connection<L> var1, L var2, WritableMessage var3);

    public void write(Connection<L> var1, L var2, WritableMessage var3, CompletionHandler<WriteResult<WritableMessage, L>> var4);

    public void write(Connection<L> var1, L var2, WritableMessage var3, CompletionHandler<WriteResult<WritableMessage, L>> var4, PushBackHandler var5);

    public void write(Connection<L> var1, L var2, WritableMessage var3, CompletionHandler<WriteResult<WritableMessage, L>> var4, MessageCloner<WritableMessage> var5);

    public boolean canWrite(Connection<L> var1);

    public void notifyWritePossible(Connection<L> var1, WriteHandler var2);

    public static final class Reentrant {
        private static final ThreadLocal<Reentrant> REENTRANTS_COUNTER = new ThreadLocal<Reentrant>(){

            @Override
            protected Reentrant initialValue() {
                return new Reentrant();
            }
        };
        private static final int maxWriteReentrants = Integer.getInteger("org.glassfish.grizzly.Writer.max-write-reentrants", 10);
        private int counter;

        public static int getMaxReentrants() {
            return maxWriteReentrants;
        }

        public static Reentrant getWriteReentrant() {
            return REENTRANTS_COUNTER.get();
        }

        public int get() {
            return this.counter;
        }

        public boolean inc() {
            return ++this.counter <= maxWriteReentrants;
        }

        public boolean dec() {
            return --this.counter <= maxWriteReentrants;
        }

        public boolean isMaxReentrantsReached() {
            return this.get() >= Reentrant.getMaxReentrants();
        }
    }
}

