/*
 * Decompiled with CFR 0.152.
 */
package com.pff;

import com.pff.PSTException;
import com.pff.PSTFile;
import com.pff.PSTNodeInputStream;
import com.pff.PSTObject;
import java.io.IOException;

public class DescriptorIndexNode {
    public int descriptorIdentifier;
    public long dataOffsetIndexIdentifier;
    public long localDescriptorsOffsetIndexIdentifier;
    public int parentDescriptorIndexIdentifier;
    public int itemType;

    DescriptorIndexNode(byte[] data, int pstFileType) {
        if (pstFileType == 14) {
            this.descriptorIdentifier = (int)PSTObject.convertLittleEndianBytesToLong(data, 0, 4);
            this.dataOffsetIndexIdentifier = (int)PSTObject.convertLittleEndianBytesToLong(data, 4, 8);
            this.localDescriptorsOffsetIndexIdentifier = (int)PSTObject.convertLittleEndianBytesToLong(data, 8, 12);
            this.parentDescriptorIndexIdentifier = (int)PSTObject.convertLittleEndianBytesToLong(data, 12, 16);
        } else {
            this.descriptorIdentifier = (int)PSTObject.convertLittleEndianBytesToLong(data, 0, 4);
            this.dataOffsetIndexIdentifier = (int)PSTObject.convertLittleEndianBytesToLong(data, 8, 16);
            this.localDescriptorsOffsetIndexIdentifier = (int)PSTObject.convertLittleEndianBytesToLong(data, 16, 24);
            this.parentDescriptorIndexIdentifier = (int)PSTObject.convertLittleEndianBytesToLong(data, 24, 28);
            this.itemType = (int)PSTObject.convertLittleEndianBytesToLong(data, 28, 32);
        }
    }

    PSTNodeInputStream getNodeInputStream(PSTFile pstFile) throws IOException, PSTException {
        return new PSTNodeInputStream(pstFile, pstFile.getOffsetIndexNode(this.dataOffsetIndexIdentifier));
    }

    public String toString() {
        return "DescriptorIndexNode\nDescriptor Identifier: " + this.descriptorIdentifier + " (0x" + Long.toHexString(this.descriptorIdentifier) + ")\n" + "Data offset identifier: " + this.dataOffsetIndexIdentifier + " (0x" + Long.toHexString(this.dataOffsetIndexIdentifier) + ")\n" + "Local descriptors offset index identifier: " + this.localDescriptorsOffsetIndexIdentifier + " (0x" + Long.toHexString(this.localDescriptorsOffsetIndexIdentifier) + ")\n" + "Parent Descriptor Index Identifier: " + this.parentDescriptorIndexIdentifier + " (0x" + Long.toHexString(this.parentDescriptorIndexIdentifier) + ")\n" + "Item Type: " + this.itemType + " (0x" + Long.toHexString(this.itemType) + ")";
    }
}

