/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.util;

import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.TableBuilder;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.util.ImportFilter;
import com.healthmarketscience.jackcess.util.SimpleImportFilter;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImportUtil {
    private static final int COPY_TABLE_BATCH_SIZE = 200;
    static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private ImportUtil() {
    }

    public static List<ColumnBuilder> toColumns(ResultSetMetaData md) throws SQLException, IOException {
        ArrayList<ColumnBuilder> columns = new ArrayList<ColumnBuilder>();
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            ColumnBuilder column = new ColumnBuilder(md.getColumnLabel(i)).escapeName();
            int lengthInUnits = md.getColumnDisplaySize(i);
            column.setSQLType(md.getColumnType(i), lengthInUnits);
            DataType type = column.getType();
            if (type.isTrueVariableLength() && !type.isLongValue()) {
                column.setLengthInUnits((short)lengthInUnits);
            }
            if (type.getHasScalePrecision()) {
                int scale = md.getScale(i);
                int precision = md.getPrecision(i);
                if (type.isValidScale(scale)) {
                    column.setScale((byte)scale);
                }
                if (type.isValidPrecision(precision)) {
                    column.setPrecision((byte)precision);
                }
            }
            columns.add(column);
        }
        return columns;
    }

    public static String importResultSet(ResultSet source, Database db, String name) throws SQLException, IOException {
        return ImportUtil.importResultSet(source, db, name, SimpleImportFilter.INSTANCE);
    }

    public static String importResultSet(ResultSet source, Database db, String name, ImportFilter filter) throws SQLException, IOException {
        return ImportUtil.importResultSet(source, db, name, filter, false);
    }

    public static String importResultSet(ResultSet source, Database db, String name, ImportFilter filter, boolean useExistingTable) throws SQLException, IOException {
        ResultSetMetaData md = source.getMetaData();
        name = TableBuilder.escapeIdentifier(name);
        Table table = null;
        if (!useExistingTable || (table = db.getTable(name)) == null) {
            List<ColumnBuilder> columns = ImportUtil.toColumns(md);
            table = ImportUtil.createUniqueTable(db, name, columns, md, filter);
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>(200);
        int numColumns = md.getColumnCount();
        while (source.next()) {
            Object[] row = new Object[numColumns];
            for (int i = 0; i < row.length; ++i) {
                row[i] = source.getObject(i + 1);
            }
            if ((row = filter.filterRow(row)) == null) continue;
            rows.add(row);
            if (rows.size() != 200) continue;
            table.addRows(rows);
            rows.clear();
        }
        if (rows.size() > 0) {
            table.addRows(rows);
        }
        return table.getName();
    }

    public static String importFile(File f, Database db, String name, String delim) throws IOException {
        return ImportUtil.importFile(f, db, name, delim, SimpleImportFilter.INSTANCE);
    }

    public static String importFile(File f, Database db, String name, String delim, ImportFilter filter) throws IOException {
        return ImportUtil.importFile(f, db, name, delim, '\"', filter, false);
    }

    public static String importFile(File f, Database db, String name, String delim, char quote, ImportFilter filter, boolean useExistingTable) throws IOException {
        return ImportUtil.importFile(f, db, name, delim, quote, filter, useExistingTable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String importFile(File f, Database db, String name, String delim, char quote, ImportFilter filter, boolean useExistingTable, boolean header) throws IOException {
        String string;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(f));
            string = ImportUtil.importReader(in, db, name, delim, quote, filter, useExistingTable, header);
        }
        catch (Throwable throwable) {
            ByteUtil.closeQuietly(in);
            throw throwable;
        }
        ByteUtil.closeQuietly(in);
        return string;
    }

    public static String importReader(BufferedReader in, Database db, String name, String delim) throws IOException {
        return ImportUtil.importReader(in, db, name, delim, SimpleImportFilter.INSTANCE);
    }

    public static String importReader(BufferedReader in, Database db, String name, String delim, ImportFilter filter) throws IOException {
        return ImportUtil.importReader(in, db, name, delim, filter, false);
    }

    public static String importReader(BufferedReader in, Database db, String name, String delim, ImportFilter filter, boolean useExistingTable) throws IOException {
        return ImportUtil.importReader(in, db, name, delim, '\"', filter, useExistingTable);
    }

    public static String importReader(BufferedReader in, Database db, String name, String delim, char quote, ImportFilter filter, boolean useExistingTable) throws IOException {
        return ImportUtil.importReader(in, db, name, delim, quote, filter, useExistingTable, true);
    }

    public static String importReader(BufferedReader in, Database db, String name, String delim, char quote, ImportFilter filter, boolean useExistingTable, boolean header) throws IOException {
        String line = in.readLine();
        if (DatabaseImpl.isBlank(line)) {
            return null;
        }
        Pattern delimPat = Pattern.compile(delim);
        try {
            name = TableBuilder.escapeIdentifier(name);
            Table table = null;
            if (!useExistingTable || (table = db.getTable(name)) == null) {
                ArrayList<ColumnBuilder> columns = new ArrayList<ColumnBuilder>();
                Object[] columnNames = ImportUtil.splitLine(line, delimPat, quote, in, 0);
                for (int i = 0; i < columnNames.length; ++i) {
                    columns.add(new ColumnBuilder((String)columnNames[i], DataType.TEXT).escapeName().setLength((short)DataType.TEXT.getMaxSize()).toColumn());
                }
                table = ImportUtil.createUniqueTable(db, name, columns, null, filter);
                header = true;
            }
            ArrayList<Object[]> rows = new ArrayList<Object[]>(200);
            int numColumns = table.getColumnCount();
            if (!header) {
                Object[] data = ImportUtil.splitLine(line, delimPat, quote, in, numColumns);
                if ((data = filter.filterRow(data)) != null) {
                    rows.add(data);
                }
            }
            while ((line = in.readLine()) != null) {
                Object[] data = ImportUtil.splitLine(line, delimPat, quote, in, numColumns);
                if ((data = filter.filterRow(data)) == null) continue;
                rows.add(data);
                if (rows.size() != 200) continue;
                table.addRows(rows);
                rows.clear();
            }
            if (rows.size() > 0) {
                table.addRows(rows);
            }
            return table.getName();
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private static Object[] splitLine(String line, Pattern delim, char quote, BufferedReader in, int numColumns) throws IOException {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        Matcher m = delim.matcher(line);
        int idx = 0;
        while (idx < line.length()) {
            if (line.charAt(idx) == quote) {
                int endIdx;
                block6: {
                    sb.setLength(0);
                    ++idx;
                    while (true) {
                        if ((endIdx = line.indexOf(quote, idx)) >= 0) {
                            sb.append(line, idx, endIdx);
                            if (++endIdx < line.length() && line.charAt(endIdx) == quote) {
                                sb.append(quote);
                                idx = endIdx + 1;
                                continue;
                            }
                            break block6;
                        }
                        sb.append(line, idx, line.length());
                        sb.append(LINE_SEPARATOR);
                        idx = 0;
                        line = in.readLine();
                        if (line == null) break;
                    }
                    throw new EOFException("Missing end of quoted value " + sb);
                }
                idx = endIdx;
                tokens.add(sb.toString());
                idx = m.find(idx) ? m.end() : line.length();
                continue;
            }
            if (m.find(idx)) {
                tokens.add(line.substring(idx, m.start()));
                idx = m.end();
                continue;
            }
            tokens.add(line.substring(idx));
            idx = line.length();
        }
        return tokens.toArray(new Object[Math.max(tokens.size(), numColumns)]);
    }

    private static Table createUniqueTable(Database db, String name, List<ColumnBuilder> columns, ResultSetMetaData md, ImportFilter filter) throws IOException, SQLException {
        String baseName = name;
        int counter = 2;
        while (db.getTable(name) != null) {
            name = baseName + counter++;
        }
        return new TableBuilder(name).addColumns(filter.filterColumns(columns, md)).toTable(db);
    }

    public static class Builder {
        private Database _db;
        private String _tableName;
        private String _delim = ",";
        private char _quote = (char)34;
        private ImportFilter _filter = SimpleImportFilter.INSTANCE;
        private boolean _useExistingTable;
        private boolean _header = true;

        public Builder(Database db) {
            this(db, null);
        }

        public Builder(Database db, String tableName) {
            this._db = db;
            this._tableName = tableName;
        }

        public Builder setDatabase(Database db) {
            this._db = db;
            return this;
        }

        public Builder setTableName(String tableName) {
            this._tableName = tableName;
            return this;
        }

        public Builder setDelimiter(String delim) {
            this._delim = delim;
            return this;
        }

        public Builder setQuote(char quote) {
            this._quote = quote;
            return this;
        }

        public Builder setFilter(ImportFilter filter) {
            this._filter = filter;
            return this;
        }

        public Builder setUseExistingTable(boolean useExistingTable) {
            this._useExistingTable = useExistingTable;
            return this;
        }

        public Builder setHeader(boolean header) {
            this._header = header;
            return this;
        }

        public String importResultSet(ResultSet source) throws SQLException, IOException {
            return ImportUtil.importResultSet(source, this._db, this._tableName, this._filter, this._useExistingTable);
        }

        public String importFile(File f) throws IOException {
            return ImportUtil.importFile(f, this._db, this._tableName, this._delim, this._quote, this._filter, this._useExistingTable, this._header);
        }

        public String importReader(BufferedReader reader) throws IOException {
            return ImportUtil.importReader(reader, this._db, this._tableName, this._delim, this._quote, this._filter, this._useExistingTable, this._header);
        }
    }
}

