/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blocklist;

import java.time.Duration;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.SlowTaskDetectorOptions;
import org.apache.flink.runtime.blocklist.BlocklistHandler;
import org.apache.flink.runtime.blocklist.DefaultBlocklistHandler;
import org.apache.flink.runtime.blocklist.NoOpBlocklistHandler;

public class BlocklistUtils {
    public static BlocklistHandler.Factory loadBlocklistHandlerFactory(Configuration configuration) {
        if (BlocklistUtils.isBlocklistEnabled(configuration)) {
            return new DefaultBlocklistHandler.Factory((Duration)configuration.get(SlowTaskDetectorOptions.CHECK_INTERVAL));
        }
        return new NoOpBlocklistHandler.Factory();
    }

    public static boolean isBlocklistEnabled(Configuration configuration) {
        return configuration.getBoolean(JobManagerOptions.SPECULATIVE_ENABLED);
    }

    private BlocklistUtils() {
    }
}

