/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.webmonitor;

import javax.annotation.Nullable;
import org.apache.flink.runtime.messages.webmonitor.JobsOverview;
import org.apache.flink.runtime.resourcemanager.ResourceOverview;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public class ClusterOverview
extends JobsOverview {
    private static final long serialVersionUID = -729861859715105265L;
    public static final String FIELD_NAME_TASKMANAGERS = "taskmanagers";
    public static final String FIELD_NAME_SLOTS_TOTAL = "slots-total";
    public static final String FIELD_NAME_SLOTS_AVAILABLE = "slots-available";
    public static final String FIELD_NAME_TASKMANAGERS_BLOCKED = "taskmanagers-blocked";
    public static final String FIELD_NAME_SLOTS_FREE_AND_BLOCKED = "slots-free-and-blocked";
    @JsonProperty(value="taskmanagers")
    private final int numTaskManagersConnected;
    @JsonProperty(value="slots-total")
    private final int numSlotsTotal;
    @JsonProperty(value="slots-available")
    private final int numSlotsAvailable;
    @JsonProperty(value="taskmanagers-blocked")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final int numTaskManagersBlocked;
    @JsonProperty(value="slots-free-and-blocked")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final int numSlotsFreeAndBlocked;

    @JsonCreator
    public ClusterOverview(@JsonProperty(value="taskmanagers") int numTaskManagersConnected, @JsonProperty(value="slots-total") int numSlotsTotal, @JsonProperty(value="slots-available") int numSlotsAvailable, @JsonProperty(value="taskmanagers-blocked") @Nullable Integer numTaskManagersBlocked, @JsonProperty(value="slots-free-and-blocked") @Nullable Integer numSlotsFreeAndBlocked, @JsonProperty(value="jobs-running") int numJobsRunningOrPending, @JsonProperty(value="jobs-finished") int numJobsFinished, @JsonProperty(value="jobs-cancelled") int numJobsCancelled, @JsonProperty(value="jobs-failed") int numJobsFailed) {
        super(numJobsRunningOrPending, numJobsFinished, numJobsCancelled, numJobsFailed);
        this.numTaskManagersConnected = numTaskManagersConnected;
        this.numSlotsTotal = numSlotsTotal;
        this.numSlotsAvailable = numSlotsAvailable;
        this.numTaskManagersBlocked = numTaskManagersBlocked == null ? 0 : numTaskManagersBlocked;
        this.numSlotsFreeAndBlocked = numSlotsFreeAndBlocked == null ? 0 : numSlotsFreeAndBlocked;
    }

    public ClusterOverview(ResourceOverview resourceOverview, JobsOverview jobsOverview) {
        this(resourceOverview.getNumberTaskManagers(), resourceOverview.getNumberRegisteredSlots(), resourceOverview.getNumberFreeSlots(), resourceOverview.getNumberBlockedTaskManagers(), resourceOverview.getNumberBlockedFreeSlots(), jobsOverview.getNumJobsRunningOrPending(), jobsOverview.getNumJobsFinished(), jobsOverview.getNumJobsCancelled(), jobsOverview.getNumJobsFailed());
    }

    public int getNumTaskManagersConnected() {
        return this.numTaskManagersConnected;
    }

    public int getNumSlotsTotal() {
        return this.numSlotsTotal;
    }

    public int getNumSlotsAvailable() {
        return this.numSlotsAvailable;
    }

    public int getNumTaskManagersBlocked() {
        return this.numTaskManagersBlocked;
    }

    public int getNumSlotsFreeAndBlocked() {
        return this.numSlotsFreeAndBlocked;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClusterOverview) {
            ClusterOverview that = (ClusterOverview)obj;
            return this.numTaskManagersConnected == that.numTaskManagersConnected && this.numSlotsTotal == that.numSlotsTotal && this.numSlotsAvailable == that.numSlotsAvailable && this.numTaskManagersBlocked == that.numTaskManagersBlocked && this.numSlotsFreeAndBlocked == that.numSlotsFreeAndBlocked && this.getNumJobsRunningOrPending() == that.getNumJobsRunningOrPending() && this.getNumJobsFinished() == that.getNumJobsFinished() && this.getNumJobsCancelled() == that.getNumJobsCancelled() && this.getNumJobsFailed() == that.getNumJobsFailed();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.numTaskManagersConnected;
        result = 31 * result + this.numSlotsTotal;
        result = 31 * result + this.numSlotsAvailable;
        result = 31 * result + this.numTaskManagersBlocked;
        result = 31 * result + this.numSlotsFreeAndBlocked;
        return result;
    }

    @Override
    public String toString() {
        return "StatusOverview {numTaskManagersConnected=" + this.numTaskManagersConnected + (this.numTaskManagersBlocked == 0 ? "" : ", numTaskManagersBlocked=" + this.numTaskManagersBlocked) + ", numSlotsTotal=" + this.numSlotsTotal + ", numSlotsAvailable=" + this.numSlotsAvailable + (this.numSlotsFreeAndBlocked == 0 ? "" : ", numSlotsFreeAndBlocked=" + this.numSlotsFreeAndBlocked) + ", numJobsRunningOrPending=" + this.getNumJobsRunningOrPending() + ", numJobsFinished=" + this.getNumJobsFinished() + ", numJobsCancelled=" + this.getNumJobsCancelled() + ", numJobsFailed=" + this.getNumJobsFailed() + '}';
    }
}

