/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptorFactory;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraph;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraphBuilder;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionStateUpdateListener;
import org.apache.flink.runtime.executiongraph.VertexAttemptNumberStore;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentTracker;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentTrackerDeploymentListenerAdapter;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.scheduler.ExecutionGraphFactory;
import org.apache.flink.runtime.scheduler.VertexParallelismStore;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.CachingSupplier;
import org.slf4j.Logger;

public class DefaultExecutionGraphFactory
implements ExecutionGraphFactory {
    private final Configuration configuration;
    private final ClassLoader userCodeClassLoader;
    private final ExecutionDeploymentTracker executionDeploymentTracker;
    private final ScheduledExecutorService futureExecutor;
    private final Executor ioExecutor;
    private final Time rpcTimeout;
    private final JobManagerJobMetricGroup jobManagerJobMetricGroup;
    private final BlobWriter blobWriter;
    private final ShuffleMaster<?> shuffleMaster;
    private final JobMasterPartitionTracker jobMasterPartitionTracker;
    private final Supplier<CheckpointStatsTracker> checkpointStatsTrackerFactory;
    private final boolean isDynamicGraph;
    private final ExecutionJobVertex.Factory executionJobVertexFactory;

    public DefaultExecutionGraphFactory(Configuration configuration, ClassLoader userCodeClassLoader, ExecutionDeploymentTracker executionDeploymentTracker, ScheduledExecutorService futureExecutor, Executor ioExecutor, Time rpcTimeout, JobManagerJobMetricGroup jobManagerJobMetricGroup, BlobWriter blobWriter, ShuffleMaster<?> shuffleMaster, JobMasterPartitionTracker jobMasterPartitionTracker) {
        this(configuration, userCodeClassLoader, executionDeploymentTracker, futureExecutor, ioExecutor, rpcTimeout, jobManagerJobMetricGroup, blobWriter, shuffleMaster, jobMasterPartitionTracker, false, new ExecutionJobVertex.Factory());
    }

    public DefaultExecutionGraphFactory(Configuration configuration, ClassLoader userCodeClassLoader, ExecutionDeploymentTracker executionDeploymentTracker, ScheduledExecutorService futureExecutor, Executor ioExecutor, Time rpcTimeout, JobManagerJobMetricGroup jobManagerJobMetricGroup, BlobWriter blobWriter, ShuffleMaster<?> shuffleMaster, JobMasterPartitionTracker jobMasterPartitionTracker, boolean isDynamicGraph, ExecutionJobVertex.Factory executionJobVertexFactory) {
        this.configuration = configuration;
        this.userCodeClassLoader = userCodeClassLoader;
        this.executionDeploymentTracker = executionDeploymentTracker;
        this.futureExecutor = futureExecutor;
        this.ioExecutor = ioExecutor;
        this.rpcTimeout = rpcTimeout;
        this.jobManagerJobMetricGroup = jobManagerJobMetricGroup;
        this.blobWriter = blobWriter;
        this.shuffleMaster = shuffleMaster;
        this.jobMasterPartitionTracker = jobMasterPartitionTracker;
        this.checkpointStatsTrackerFactory = new CachingSupplier(() -> new CheckpointStatsTracker(configuration.getInteger(WebOptions.CHECKPOINTS_HISTORY_SIZE), jobManagerJobMetricGroup));
        this.isDynamicGraph = isDynamicGraph;
        this.executionJobVertexFactory = (ExecutionJobVertex.Factory)Preconditions.checkNotNull((Object)executionJobVertexFactory);
    }

    @Override
    public ExecutionGraph createAndRestoreExecutionGraph(JobGraph jobGraph, CompletedCheckpointStore completedCheckpointStore, CheckpointsCleaner checkpointsCleaner, CheckpointIDCounter checkpointIdCounter, TaskDeploymentDescriptorFactory.PartitionLocationConstraint partitionLocationConstraint, long initializationTimestamp, VertexAttemptNumberStore vertexAttemptNumberStore, VertexParallelismStore vertexParallelismStore, ExecutionStateUpdateListener executionStateUpdateListener, Logger log) throws Exception {
        ExecutionDeploymentTrackerDeploymentListenerAdapter executionDeploymentListener = new ExecutionDeploymentTrackerDeploymentListenerAdapter(this.executionDeploymentTracker);
        ExecutionStateUpdateListener combinedExecutionStateUpdateListener = (execution, previousState, newState) -> {
            executionStateUpdateListener.onStateUpdate(execution, previousState, newState);
            if (newState.isTerminal()) {
                this.executionDeploymentTracker.stopTrackingDeploymentOf(execution);
            }
        };
        DefaultExecutionGraph newExecutionGraph = DefaultExecutionGraphBuilder.buildGraph(jobGraph, this.configuration, this.futureExecutor, this.ioExecutor, this.userCodeClassLoader, completedCheckpointStore, checkpointsCleaner, checkpointIdCounter, this.rpcTimeout, this.blobWriter, log, this.shuffleMaster, this.jobMasterPartitionTracker, partitionLocationConstraint, executionDeploymentListener, combinedExecutionStateUpdateListener, initializationTimestamp, vertexAttemptNumberStore, vertexParallelismStore, this.checkpointStatsTrackerFactory, this.isDynamicGraph, this.executionJobVertexFactory);
        CheckpointCoordinator checkpointCoordinator = newExecutionGraph.getCheckpointCoordinator();
        if (checkpointCoordinator != null && !checkpointCoordinator.restoreInitialCheckpointIfPresent(new HashSet<ExecutionJobVertex>(newExecutionGraph.getAllVertices().values()))) {
            this.tryRestoreExecutionGraphFromSavepoint(newExecutionGraph, jobGraph.getSavepointRestoreSettings());
        }
        return newExecutionGraph;
    }

    private void tryRestoreExecutionGraphFromSavepoint(ExecutionGraph executionGraphToRestore, SavepointRestoreSettings savepointRestoreSettings) throws Exception {
        CheckpointCoordinator checkpointCoordinator;
        if (savepointRestoreSettings.restoreSavepoint() && (checkpointCoordinator = executionGraphToRestore.getCheckpointCoordinator()) != null) {
            checkpointCoordinator.restoreSavepoint(savepointRestoreSettings, executionGraphToRestore.getAllVertices(), this.userCodeClassLoader);
        }
    }
}

