/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.s3;

import java.io.ObjectStreamException;
import java.util.Date;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

class S3ResourceId
implements ResourceId {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -8218379666994031337L;
    static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_SCHEME = "s3";
    private static final @UnknownKeyFor @NonNull @Initialized Pattern S3_URI = Pattern.compile("(?<SCHEME>[^:]+)://(?<BUCKET>[^/]+)(/(?<KEY>.*))?");
    private static final @UnknownKeyFor @NonNull @Initialized Pattern GLOB_PREFIX = Pattern.compile("(?<PREFIX>[^\\[*?]*)[\\[*?].*");
    private final @UnknownKeyFor @NonNull @Initialized String bucket;
    private final @UnknownKeyFor @NonNull @Initialized String key;
    private final @UnknownKeyFor @NonNull @Initialized Long size;
    private final @UnknownKeyFor @NonNull @Initialized Date lastModified;
    private final @UnknownKeyFor @NonNull @Initialized String scheme;

    private S3ResourceId(@UnknownKeyFor @NonNull @Initialized String scheme, @UnknownKeyFor @NonNull @Initialized String bucket, @UnknownKeyFor @NonNull @Initialized String key, @Nullable @UnknownKeyFor @Initialized Long size, @Nullable @UnknownKeyFor @Initialized Date lastModified) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)scheme) ? 1 : 0) != 0, (Object)"scheme");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucket) ? 1 : 0) != 0, (Object)"bucket");
        Preconditions.checkArgument((!bucket.contains("/") ? 1 : 0) != 0, (String)"bucket must not contain '/': [%s]", (Object)bucket);
        this.scheme = scheme;
        this.bucket = bucket;
        this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key");
        this.size = size;
        this.lastModified = lastModified;
    }

    private @UnknownKeyFor @NonNull @Initialized Object readResolve() throws @UnknownKeyFor @NonNull @Initialized ObjectStreamException {
        if (this.scheme == null) {
            return new S3ResourceId(DEFAULT_SCHEME, this.bucket, this.key, this.size, this.lastModified);
        }
        return this;
    }

    static @UnknownKeyFor @NonNull @Initialized S3ResourceId fromComponents(@UnknownKeyFor @NonNull @Initialized String scheme, @UnknownKeyFor @NonNull @Initialized String bucket, @UnknownKeyFor @NonNull @Initialized String key) {
        if (!key.startsWith("/")) {
            key = "/" + key;
        }
        return new S3ResourceId(scheme, bucket, key, null, null);
    }

    static @UnknownKeyFor @NonNull @Initialized S3ResourceId fromUri(@UnknownKeyFor @NonNull @Initialized String uri) {
        Matcher m = S3_URI.matcher(uri);
        Preconditions.checkArgument((boolean)m.matches(), (String)"Invalid S3 URI: [%s]", (Object)uri);
        String scheme = m.group("SCHEME");
        String bucket = m.group("BUCKET");
        String key = Strings.nullToEmpty((String)m.group("KEY"));
        if (!key.startsWith("/")) {
            key = "/" + key;
        }
        return S3ResourceId.fromComponents(scheme, bucket, key);
    }

    @UnknownKeyFor @NonNull @Initialized String getBucket() {
        return this.bucket;
    }

    @UnknownKeyFor @NonNull @Initialized String getKey() {
        return this.key.substring(1);
    }

    @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Long> getSize() {
        return Optional.fromNullable((Object)this.size);
    }

    @UnknownKeyFor @NonNull @Initialized S3ResourceId withSize(@UnknownKeyFor @NonNull @Initialized long size) {
        return new S3ResourceId(this.scheme, this.bucket, this.key, size, this.lastModified);
    }

    @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Date> getLastModified() {
        return Optional.fromNullable((Object)this.lastModified);
    }

    @UnknownKeyFor @NonNull @Initialized S3ResourceId withLastModified(@UnknownKeyFor @NonNull @Initialized Date lastModified) {
        return new S3ResourceId(this.scheme, this.bucket, this.key, this.size, lastModified);
    }

    public @UnknownKeyFor @NonNull @Initialized ResourceId resolve(@UnknownKeyFor @NonNull @Initialized String other, @UnknownKeyFor @NonNull @Initialized ResolveOptions resolveOptions) {
        Preconditions.checkState((boolean)this.isDirectory(), (String)"Expected this resource to be a directory, but was [%s]", (Object)this.toString());
        if (resolveOptions == ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY) {
            if ("..".equals(other)) {
                if ("/".equals(this.key)) {
                    return this;
                }
                int parentStopsAt = this.key.substring(0, this.key.length() - 1).lastIndexOf(47);
                return S3ResourceId.fromComponents(this.scheme, this.bucket, this.key.substring(0, parentStopsAt + 1));
            }
            if ("".equals(other)) {
                return this;
            }
            if (!other.endsWith("/")) {
                other = other + "/";
            }
            if (S3_URI.matcher(other).matches()) {
                return this.resolveFromUri(other);
            }
            return S3ResourceId.fromComponents(this.scheme, this.bucket, this.key + other);
        }
        if (resolveOptions == ResolveOptions.StandardResolveOptions.RESOLVE_FILE) {
            Preconditions.checkArgument((!other.endsWith("/") ? 1 : 0) != 0, (String)"Cannot resolve a file with a directory path: [%s]", (Object)other);
            Preconditions.checkArgument((!"..".equals(other) ? 1 : 0) != 0, (String)"Cannot resolve parent as file: [%s]", (Object)other);
            if (S3_URI.matcher(other).matches()) {
                return this.resolveFromUri(other);
            }
            return S3ResourceId.fromComponents(this.scheme, this.bucket, this.key + other);
        }
        throw new UnsupportedOperationException(String.format("Unexpected StandardResolveOptions [%s]", resolveOptions));
    }

    private @UnknownKeyFor @NonNull @Initialized S3ResourceId resolveFromUri(@UnknownKeyFor @NonNull @Initialized String uri) {
        S3ResourceId id = S3ResourceId.fromUri(uri);
        Preconditions.checkArgument((boolean)id.getScheme().equals(this.scheme), (String)"Cannot resolve a URI as a child resource unless its scheme is [%s]; instead it was [%s]", (Object)this.scheme, (Object)id.getScheme());
        return id;
    }

    public @UnknownKeyFor @NonNull @Initialized ResourceId getCurrentDirectory() {
        if (this.isDirectory()) {
            return this;
        }
        return S3ResourceId.fromComponents(this.scheme, this.getBucket(), this.key.substring(0, this.key.lastIndexOf(47) + 1));
    }

    public @UnknownKeyFor @NonNull @Initialized String getScheme() {
        return this.scheme;
    }

    public @Nullable @UnknownKeyFor @Initialized String getFilename() {
        if (!this.isDirectory()) {
            return this.key.substring(this.key.lastIndexOf(47) + 1);
        }
        if ("/".equals(this.key)) {
            return null;
        }
        String keyWithoutTrailingSlash = this.key.substring(0, this.key.length() - 1);
        return keyWithoutTrailingSlash.substring(keyWithoutTrailingSlash.lastIndexOf(47) + 1);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isDirectory() {
        return this.key.endsWith("/");
    }

    @UnknownKeyFor @NonNull @Initialized boolean isWildcard() {
        return GLOB_PREFIX.matcher(this.getKey()).matches();
    }

    @UnknownKeyFor @NonNull @Initialized String getKeyNonWildcardPrefix() {
        Matcher m = GLOB_PREFIX.matcher(this.getKey());
        Preconditions.checkArgument((boolean)m.matches(), (Object)String.format("Glob expression: [%s] is not expandable.", this.getKey()));
        return m.group("PREFIX");
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("%s://%s%s", this.scheme, this.bucket, this.key);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (!(obj instanceof S3ResourceId)) {
            return false;
        }
        S3ResourceId o = (S3ResourceId)obj;
        return this.scheme.equals(o.scheme) && this.bucket.equals(o.bucket) && this.key.equals(o.key);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.scheme, this.bucket, this.key);
    }
}

