/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.jsoninput;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.file.BaseFileInputAdditionalField;
import org.apache.hop.pipeline.transforms.file.BaseFileInputFiles;
import org.apache.hop.pipeline.transforms.file.BaseFileInputMeta;
import org.apache.hop.pipeline.transforms.jsoninput.JsonInput;
import org.apache.hop.pipeline.transforms.jsoninput.JsonInputData;
import org.apache.hop.pipeline.transforms.jsoninput.JsonInputField;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.w3c.dom.Node;

@Transform(id="JsonInput", image="JSI.svg", documentationUrl="/pipeline/transforms/jsoninput.html", name="i18n::JsonInput.name", description="i18n::JsonInput.description", keywords={"i18n::JsonInputMeta.keyword"}, categoryDescription="i18n::JsonInput.category")
@InjectionSupported(localizationPrefix="JsonInput.Injection.", groups={"FILENAME_LINES", "FIELDS"}, hide={"ACCEPT_FILE_NAMES", "ACCEPT_FILE_TRANSFORM", "PASS_THROUGH_FIELDS", "ACCEPT_FILE_FIELD", "ADD_FILES_TO_RESULT", "IGNORE_ERRORS", "FILE_ERROR_FIELD", "FILE_ERROR_MESSAGE_FIELD", "SKIP_BAD_FILES", "WARNING_FILES_TARGET_DIR", "WARNING_FILES_EXTENTION", "ERROR_FILES_TARGET_DIR", "ERROR_FILES_EXTENTION", "LINE_NR_FILES_TARGET_DIR", "LINE_NR_FILES_EXTENTION", "FIELD_NULL_STRING", "FIELD_POSITION", "FIELD_IGNORE", "FIELD_IF_NULL"})
public class JsonInputMeta
extends BaseFileInputMeta<JsonInput, JsonInputData, AdditionalFileOutputFields, InputFiles, JsonInputField> {
    private static final Class<?> PKG = JsonInputMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    @Injection(name="FILE_NAME_OUTPUT")
    private boolean includeFilename;
    @Injection(name="FILE_NAME_FIELDNAME")
    private String filenameField;
    @Injection(name="ROW_NUMBER_OUTPUT")
    private boolean includeRowNumber;
    @Injection(name="ROW_NUMBER_FIELDNAME")
    private String rowNumberField;
    @Injection(name="ROW_LIMIT")
    private long rowLimit;
    @Injection(name="SOURCE_FIELD_NAME")
    private String valueField;
    @Injection(name="SOURCE_IN_FIELD")
    private boolean inFields;
    @Injection(name="SOURCE_FIELD_IS_FILENAME")
    private boolean isAFile;
    @Injection(name="ADD_RESULT_FILE")
    private boolean addResultFile;
    @Injection(name="IGNORE_EMPTY_FILE")
    private boolean isIgnoreEmptyFile;
    @Injection(name="DO_NOT_FAIL_IF_NO_FILE")
    private boolean doNotFailIfNoFile;
    @Injection(name="IGNORE_MISSING_PATH")
    private boolean ignoreMissingPath;
    @Injection(name="READ_SOURCE_AS_URL")
    private boolean readurl;
    @Injection(name="REMOVE_SOURCE_FIELDS")
    private boolean removeSourceField;
    private boolean defaultPathLeafToNull;

    protected void setInputFiles(InputFiles inputFiles) {
        this.inputFiles = inputFiles;
    }

    protected InputFiles getInputFiles() {
        return (InputFiles)this.inputFiles;
    }

    public JsonInputMeta() {
        this.additionalOutputFields = new AdditionalFileOutputFields();
        this.inputFiles = new InputFiles();
        this.inputFields = new JsonInputField[0];
    }

    public boolean isDefaultPathLeafToNull() {
        return this.defaultPathLeafToNull;
    }

    public void setDefaultPathLeafToNull(boolean defaultPathLeafToNull) {
        this.defaultPathLeafToNull = defaultPathLeafToNull;
    }

    public String getShortFileNameField() {
        return ((AdditionalFileOutputFields)this.additionalOutputFields).shortFilenameField;
    }

    public void setShortFileNameField(String field) {
        ((AdditionalFileOutputFields)this.additionalOutputFields).shortFilenameField = field;
    }

    public String getPathField() {
        return ((AdditionalFileOutputFields)this.additionalOutputFields).pathField;
    }

    public void setPathField(String field) {
        ((AdditionalFileOutputFields)this.additionalOutputFields).pathField = field;
    }

    public String isHiddenField() {
        return ((AdditionalFileOutputFields)this.additionalOutputFields).hiddenField;
    }

    public void setIsHiddenField(String field) {
        ((AdditionalFileOutputFields)this.additionalOutputFields).hiddenField = field;
    }

    public String getLastModificationDateField() {
        return ((AdditionalFileOutputFields)this.additionalOutputFields).lastModificationField;
    }

    public void setLastModificationDateField(String field) {
        ((AdditionalFileOutputFields)this.additionalOutputFields).lastModificationField = field;
    }

    public String getUriField() {
        return ((AdditionalFileOutputFields)this.additionalOutputFields).uriField;
    }

    public void setUriField(String field) {
        ((AdditionalFileOutputFields)this.additionalOutputFields).uriField = field;
    }

    public String getRootUriField() {
        return ((AdditionalFileOutputFields)this.additionalOutputFields).rootUriField;
    }

    public void setRootUriField(String field) {
        ((AdditionalFileOutputFields)this.additionalOutputFields).rootUriField = field;
    }

    public String getExtensionField() {
        return ((AdditionalFileOutputFields)this.additionalOutputFields).extensionField;
    }

    public void setExtensionField(String field) {
        ((AdditionalFileOutputFields)this.additionalOutputFields).extensionField = field;
    }

    public String getSizeField() {
        return ((AdditionalFileOutputFields)this.additionalOutputFields).sizeField;
    }

    public void setSizeField(String field) {
        ((AdditionalFileOutputFields)this.additionalOutputFields).sizeField = field;
    }

    public boolean addResultFile() {
        return this.addResultFile;
    }

    public boolean isReadUrl() {
        return this.readurl;
    }

    public void setReadUrl(boolean readurl) {
        this.readurl = readurl;
    }

    public boolean isRemoveSourceField() {
        return this.removeSourceField;
    }

    public void setRemoveSourceField(boolean removeSourceField) {
        this.removeSourceField = removeSourceField;
    }

    public void setAddResultFile(boolean addResultFile) {
        this.addResultFile = addResultFile;
    }

    public JsonInputField[] getInputFields() {
        return (JsonInputField[])super.getInputFields();
    }

    public void setInputFields(JsonInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String[] getExcludeFileMask() {
        return ((InputFiles)this.inputFiles).excludeFileMask;
    }

    public void setExcludeFileMask(String[] excludeFileMask) {
        ((InputFiles)this.inputFiles).excludeFileMask = excludeFileMask;
    }

    public String getFieldValue() {
        return this.valueField;
    }

    public void setFieldValue(String value) {
        this.valueField = value;
        ((InputFiles)this.inputFiles).acceptingField = value;
    }

    public boolean isInFields() {
        return this.inFields;
    }

    public void setInFields(boolean inFields) {
        this.inFields = inFields;
        ((InputFiles)this.inputFiles).acceptingFilenames = inFields;
    }

    public String[] getFileMask() {
        return ((InputFiles)this.inputFiles).fileMask;
    }

    public void setFileMask(String[] fileMask) {
        ((InputFiles)this.inputFiles).fileMask = fileMask;
    }

    public String[] getFileRequired() {
        return ((InputFiles)this.inputFiles).fileRequired;
    }

    public void setFileRequired(String[] fileRequiredin) {
        for (int i = 0; i < fileRequiredin.length; ++i) {
            ((InputFiles)this.inputFiles).fileRequired[i] = JsonInputMeta.getRequiredFilesCode((String)fileRequiredin[i]);
        }
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            ((InputFiles)this.inputFiles).includeSubFolders[i] = JsonInputMeta.getRequiredFilesCode((String)includeSubFoldersin[i]);
        }
    }

    public String[] getFileName() {
        return ((InputFiles)this.inputFiles).fileName;
    }

    public void setFileName(String[] fileName) {
        ((InputFiles)this.inputFiles).fileName = fileName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean includeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public boolean isIgnoreEmptyFile() {
        return this.isIgnoreEmptyFile;
    }

    public void setIgnoreEmptyFile(boolean isIgnoreEmptyFile) {
        this.isIgnoreEmptyFile = isIgnoreEmptyFile;
    }

    public boolean isDoNotFailIfNoFile() {
        return this.doNotFailIfNoFile;
    }

    public void setDoNotFailIfNoFile(boolean doNotFailIfNoFile) {
        this.doNotFailIfNoFile = doNotFailIfNoFile;
    }

    public boolean isIgnoreMissingPath() {
        return this.ignoreMissingPath;
    }

    public void setIgnoreMissingPath(boolean ignoreMissingPath) {
        this.ignoreMissingPath = ignoreMissingPath;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public boolean getIsAFile() {
        return this.isAFile;
    }

    public void setIsAFile(boolean isAFile) {
        this.isAFile = isAFile;
    }

    public String[] getIncludeSubFolders() {
        return ((InputFiles)this.inputFiles).includeSubFolders;
    }

    public void loadXml(Node transformnode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformnode, metadataProvider);
    }

    public JsonInputMeta clone() {
        JsonInputMeta clone = (JsonInputMeta)((Object)super.clone());
        clone.setFileName(this.getFileName());
        clone.setFileMask(this.getFileMask());
        clone.setExcludeFileMask(this.getExcludeFileMask());
        for (int i = 0; i < ((JsonInputField[])this.inputFields).length; ++i) {
            ((JsonInputField[])clone.inputFields)[i] = ((JsonInputField[])this.inputFields)[i].clone();
        }
        return clone;
    }

    public String getXml() {
        int i;
        StringBuilder retval = new StringBuilder(400);
        retval.append("    ").append(XmlHandler.addTagValue((String)"include", (boolean)this.includeFilename));
        retval.append("    ").append(XmlHandler.addTagValue((String)"include_field", (String)this.filenameField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    ").append(XmlHandler.addTagValue((String)"addresultfile", (boolean)this.addResultFile));
        retval.append("    ").append(XmlHandler.addTagValue((String)"readurl", (boolean)this.readurl));
        retval.append("    ").append(XmlHandler.addTagValue((String)"removeSourceField", (boolean)this.removeSourceField));
        retval.append("    " + XmlHandler.addTagValue((String)"IsIgnoreEmptyFile", (boolean)this.isIgnoreEmptyFile));
        retval.append("    " + XmlHandler.addTagValue((String)"doNotFailIfNoFile", (boolean)this.doNotFailIfNoFile));
        retval.append("    " + XmlHandler.addTagValue((String)"ignoreMissingPath", (boolean)this.ignoreMissingPath));
        retval.append("    " + XmlHandler.addTagValue((String)"defaultPathLeafToNull", (boolean)this.defaultPathLeafToNull));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    <file>").append(Const.CR);
        for (i = 0; i < this.getFileName().length; ++i) {
            retval.append("      ").append(XmlHandler.addTagValue((String)"name", (String)this.getFileName()[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"filemask", (String)this.getFileMask()[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"exclude_filemask", (String)this.getExcludeFileMask()[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"file_required", (String)this.getFileRequired()[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"include_subfolders", (String)this.getIncludeSubFolders()[i]));
        }
        retval.append("    </file>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (i = 0; i < this.getInputFields().length; ++i) {
            JsonInputField field = this.getInputFields()[i];
            retval.append(field.getXml());
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XmlHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    ").append(XmlHandler.addTagValue((String)"IsInFields", (boolean)this.inFields));
        retval.append("    ").append(XmlHandler.addTagValue((String)"IsAFile", (boolean)this.isAFile));
        retval.append("    ").append(XmlHandler.addTagValue((String)"valueField", (String)this.valueField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"shortFileFieldName", (String)this.getShortFileNameField()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"pathFieldName", (String)this.getPathField()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"hiddenFieldName", (String)this.isHiddenField()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"lastModificationTimeFieldName", (String)this.getLastModificationDateField()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"uriNameFieldName", (String)this.getUriField()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rootUriNameFieldName", (String)this.getUriField()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"extensionFieldName", (String)this.getExtensionField()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"sizeFieldName", (String)this.getSizeField()));
        return retval.toString();
    }

    public String getRequiredFilesDesc(String tt) {
        if (Utils.isEmpty((CharSequence)tt)) {
            return RequiredFilesDesc[0];
        }
        if (tt.equalsIgnoreCase(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            int i;
            this.includeFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"include"));
            this.filenameField = XmlHandler.getTagValue((Node)transformNode, (String)"include_field");
            this.addResultFile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"addresultfile"));
            this.readurl = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"readurl"));
            this.removeSourceField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"removeSourceField"));
            this.isIgnoreEmptyFile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"IsIgnoreEmptyFile"));
            this.ignoreMissingPath = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"ignoreMissingPath"));
            this.defaultPathLeafToNull = JsonInputMeta.getDefaultPathLeafToNull(transformNode);
            this.doNotFailIfNoFile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"doNotFailIfNoFile"));
            this.includeRowNumber = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"rownum"));
            this.rowNumberField = XmlHandler.getTagValue((Node)transformNode, (String)"rownum_field");
            Node filenode = XmlHandler.getSubNode((Node)transformNode, (String)"file");
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFiles = XmlHandler.countNodes((Node)filenode, (String)"name");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.initArrayFields(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                Node filenamenode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node excludefilemasknode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
                Node fileRequirednode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                Node includeSubFoldersnode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.getFileName()[i] = XmlHandler.getNodeValue((Node)filenamenode);
                this.getFileMask()[i] = XmlHandler.getNodeValue((Node)filemasknode);
                this.getExcludeFileMask()[i] = XmlHandler.getNodeValue((Node)excludefilemasknode);
                this.getFileRequired()[i] = XmlHandler.getNodeValue((Node)fileRequirednode);
                this.getIncludeSubFolders()[i] = XmlHandler.getNodeValue((Node)includeSubFoldersnode);
            }
            for (i = 0; i < nrFields; ++i) {
                JsonInputField field;
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.getInputFields()[i] = field = new JsonInputField(fnode);
            }
            this.rowLimit = Const.toLong((String)XmlHandler.getTagValue((Node)transformNode, (String)"limit"), (long)0L);
            this.setInFields("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"IsInFields")));
            this.isAFile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"IsAFile"));
            this.setFieldValue(XmlHandler.getTagValue((Node)transformNode, (String)"valueField"));
            this.setShortFileNameField(XmlHandler.getTagValue((Node)transformNode, (String)"shortFileFieldName"));
            this.setPathField(XmlHandler.getTagValue((Node)transformNode, (String)"pathFieldName"));
            this.setIsHiddenField(XmlHandler.getTagValue((Node)transformNode, (String)"hiddenFieldName"));
            this.setLastModificationDateField(XmlHandler.getTagValue((Node)transformNode, (String)"lastModificationTimeFieldName"));
            this.setUriField(XmlHandler.getTagValue((Node)transformNode, (String)"uriNameFieldName"));
            this.setRootUriField(XmlHandler.getTagValue((Node)transformNode, (String)"rootUriNameFieldName"));
            this.setExtensionField(XmlHandler.getTagValue((Node)transformNode, (String)"extensionFieldName"));
            this.setSizeField(XmlHandler.getTagValue((Node)transformNode, (String)"sizeFieldName"));
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"JsonInputMeta.Exception.ErrorLoadingXml", (String[])new String[]{e.toString()}));
        }
    }

    private static boolean getDefaultPathLeafToNull(Node transformnode) {
        boolean result = true;
        List nodes = XmlHandler.getNodes((Node)transformnode, (String)"defaultPathLeafToNull");
        if (nodes != null && nodes.size() > 0) {
            result = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"defaultPathLeafToNull"));
        }
        return result;
    }

    @Deprecated(since="2.0")
    public void allocate(int nrFiles, int nrFields) {
        this.initArrayFields(nrFiles, nrFields);
    }

    private void initArrayFields(int nrfiles, int nrFields) {
        this.setInputFields(new JsonInputField[nrFields]);
        ((InputFiles)this.inputFiles).allocate(nrfiles);
        this.inputFields = new JsonInputField[nrFields];
    }

    public void setDefault() {
        this.additionalOutputFields = new AdditionalFileOutputFields();
        this.isIgnoreEmptyFile = false;
        this.ignoreMissingPath = true;
        this.defaultPathLeafToNull = true;
        this.doNotFailIfNoFile = true;
        this.includeFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.isAFile = false;
        this.addResultFile = false;
        this.readurl = false;
        this.removeSourceField = false;
        int nrFiles = 0;
        int nrFields = 0;
        this.initArrayFields(nrFiles, nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.getInputFields()[i] = new JsonInputField("field" + (i + 1));
        }
        this.rowLimit = 0L;
        this.inFields = false;
        this.valueField = "";
    }

    public void getFields(IRowMeta rowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString v;
        int index;
        if (this.inFields && this.removeSourceField && !Utils.isEmpty((CharSequence)this.valueField) && (index = rowMeta.indexOfValue(this.valueField)) != -1) {
            rowMeta.removeValueMeta(index);
        }
        for (JsonInputField field : this.getInputFields()) {
            try {
                rowMeta.addValueMeta(field.toValueMeta(name, variables));
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        if (this.includeFilename) {
            v = new ValueMetaString(variables.resolve(this.filenameField));
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            rowMeta.addValueMeta((IValueMeta)v);
        }
        if (this.includeRowNumber) {
            v = new ValueMetaInteger(variables.resolve(this.rowNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            rowMeta.addValueMeta((IValueMeta)v);
        }
        ((AdditionalFileOutputFields)this.additionalOutputFields).normalize();
        ((AdditionalFileOutputFields)this.additionalOutputFields).getFields(rowMeta, name, info, variables, metadataProvider);
    }

    public FileInputList getFiles(IVariables variables) {
        return FileInputList.createFileList((IVariables)variables, (String[])this.getFileName(), (String[])this.getFileMask(), (String[])this.getExcludeFileMask(), (String[])this.getFileRequired(), (boolean[])((InputFiles)this.inputFiles).includeSubFolderBoolean());
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (!this.isInFields()) {
            if (input.length <= 0) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.NoInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (this.getInputFields().length <= 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.NoInputField", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.isInFields()) {
            if (Utils.isEmpty((CharSequence)this.getFieldValue())) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.NoField", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.FieldOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            FileInputList fileInputList = this.getFiles(variables);
            if (fileInputList == null || fileInputList.getFiles().size() == 0) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.NoFiles", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.FilesOk", (String[])new String[]{"" + fileInputList.getFiles().size()}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming resourceNamingInterface, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            FileInputList fileList;
            ArrayList<String> newFilenames = new ArrayList<String>();
            if (!this.isInFields() && (fileList = this.getFiles(variables)).getFiles().size() > 0) {
                for (FileObject fileObject : fileList.getFiles()) {
                    if (!fileObject.exists()) continue;
                    newFilenames.add(fileObject.getName().getPath());
                }
                this.setFileName(newFilenames.toArray(new String[newFilenames.size()]));
                this.setFileMask(new String[newFilenames.size()]);
                this.setFileRequired(new String[newFilenames.size()]);
                Arrays.fill(this.getFileRequired(), "Y");
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public String getEncoding() {
        return "UTF-8";
    }

    public static class AdditionalFileOutputFields
    extends BaseFileInputAdditionalField {
        public void getFields(IRowMeta r, String name, IRowMeta[] info, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
            ValueMetaString v;
            if (this.shortFilenameField != null) {
                v = new ValueMetaString(variables.resolve(this.shortFilenameField));
                v.setLength(100, -1);
                v.setOrigin(name);
                r.addValueMeta((IValueMeta)v);
            }
            if (this.extensionField != null) {
                v = new ValueMetaString(variables.resolve(this.extensionField));
                v.setLength(100, -1);
                v.setOrigin(name);
                r.addValueMeta((IValueMeta)v);
            }
            if (this.pathField != null) {
                v = new ValueMetaString(variables.resolve(this.pathField));
                v.setLength(100, -1);
                v.setOrigin(name);
                r.addValueMeta((IValueMeta)v);
            }
            if (this.sizeField != null) {
                v = new ValueMetaInteger(variables.resolve(this.sizeField));
                v.setOrigin(name);
                v.setLength(9);
                r.addValueMeta((IValueMeta)v);
            }
            if (this.hiddenField != null) {
                v = new ValueMetaBoolean(variables.resolve(this.hiddenField));
                v.setOrigin(name);
                r.addValueMeta((IValueMeta)v);
            }
            if (this.lastModificationField != null) {
                v = new ValueMetaDate(variables.resolve(this.lastModificationField));
                v.setOrigin(name);
                r.addValueMeta((IValueMeta)v);
            }
            if (this.uriField != null) {
                v = new ValueMetaString(variables.resolve(this.uriField));
                v.setLength(100, -1);
                v.setOrigin(name);
                r.addValueMeta((IValueMeta)v);
            }
            if (this.rootUriField != null) {
                v = new ValueMetaString(variables.resolve(this.rootUriField));
                v.setLength(100, -1);
                v.setOrigin(name);
                r.addValueMeta((IValueMeta)v);
            }
        }
    }

    public static class InputFiles
    extends BaseFileInputFiles {
        public void allocate(int nrFiles) {
            this.fileName = new String[nrFiles];
            this.fileMask = new String[nrFiles];
            this.excludeFileMask = new String[nrFiles];
            this.fileRequired = new String[nrFiles];
            this.includeSubFolders = new String[nrFiles];
            Arrays.fill(this.fileName, "");
            Arrays.fill(this.fileMask, "");
            Arrays.fill(this.excludeFileMask, "");
            Arrays.fill(this.fileRequired, "N");
            Arrays.fill(this.includeSubFolders, "N");
        }

        public InputFiles clone() {
            InputFiles clone = (InputFiles)((Object)super.clone());
            clone.allocate(this.fileName.length);
            return clone;
        }
    }
}

