/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.dictionary;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.dictionary.Dictionary;

public interface DictionaryProvider {
    public Dictionary lookup(long var1);

    public Set<Long> getDictionaryIds();

    public static class MapDictionaryProvider
    implements DictionaryProvider {
        private final Map<Long, Dictionary> map = new HashMap<Long, Dictionary>();

        public MapDictionaryProvider(Dictionary ... dictionaries) {
            for (Dictionary dictionary : dictionaries) {
                this.put(dictionary);
            }
        }

        public void put(Dictionary dictionary) {
            this.map.put(dictionary.getEncoding().getId(), dictionary);
        }

        @Override
        public final Set<Long> getDictionaryIds() {
            return this.map.keySet();
        }

        @Override
        public Dictionary lookup(long id) {
            return this.map.get(id);
        }
    }
}

