/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.auto.value.AutoValue;
import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.Row;
import com.google.bigtable.v2.RowFilter;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamMutation;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.gcp.bigtable.AutoValue_BigtableIO_Read;
import org.apache.beam.sdk.io.gcp.bigtable.AutoValue_BigtableIO_ReadChangeStream;
import org.apache.beam.sdk.io.gcp.bigtable.AutoValue_BigtableIO_Write;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableConfig;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableReadOptions;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableServiceFactory;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableWriteOptions;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableWriteResult;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.UniqueIdGenerator;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.action.ActionFactory;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.DaoFactory;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dofn.DetectNewPartitionsDoFn;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dofn.InitializeDoFn;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dofn.ReadChangeStreamPartitionDoFn;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.estimator.BytesThroughputEstimator;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.estimator.SizeEstimator;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.io.range.ByteKeyRangeTracker;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigtableIO {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigtableIO.class);

    public static @UnknownKeyFor @NonNull @Initialized Read read() {
        return Read.create();
    }

    public static @UnknownKeyFor @NonNull @Initialized Write write() {
        return Write.create();
    }

    public static @UnknownKeyFor @NonNull @Initialized ReadChangeStream readChangeStream() {
        return ReadChangeStream.create();
    }

    private BigtableIO() {
    }

    private static @UnknownKeyFor @NonNull @Initialized ByteKey makeByteKey(@UnknownKeyFor @NonNull @Initialized ByteString key) {
        return ByteKey.copyFrom((ByteBuffer)key.asReadOnlyByteBuffer());
    }

    @AutoValue
    public static abstract class ReadChangeStream
    extends PTransform<PBegin, PCollection<KV<ByteString, ChangeStreamMutation>>> {
        static @UnknownKeyFor @NonNull @Initialized ReadChangeStream create() {
            BigtableConfig config = BigtableConfig.builder().setValidate(true).build();
            BigtableConfig metadataTableconfig = BigtableConfig.builder().setValidate(true).build();
            return new AutoValue_BigtableIO_ReadChangeStream.Builder().setBigtableConfig(config).setMetadataTableBigtableConfig(metadataTableconfig).build();
        }

        abstract @UnknownKeyFor @NonNull @Initialized BigtableConfig getBigtableConfig();

        abstract @Nullable @UnknownKeyFor @Initialized String getTableId();

        abstract @Nullable @UnknownKeyFor @Initialized Instant getStartTime();

        abstract @Nullable @UnknownKeyFor @Initialized Instant getEndTime();

        abstract @Nullable @UnknownKeyFor @Initialized Duration getHeartbeatDuration();

        abstract @Nullable @UnknownKeyFor @Initialized String getChangeStreamName();

        abstract @Nullable @UnknownKeyFor @Initialized ExistingPipelineOptions getExistingPipelineOptions();

        abstract @UnknownKeyFor @NonNull @Initialized BigtableConfig getMetadataTableBigtableConfig();

        abstract @Nullable @UnknownKeyFor @Initialized String getMetadataTableId();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId))).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withInstanceId(@UnknownKeyFor @NonNull @Initialized String instanceId) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId))).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withTableId(@UnknownKeyFor @NonNull @Initialized String tableId) {
            return this.toBuilder().setTableId(tableId).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withAppProfileId(@UnknownKeyFor @NonNull @Initialized String appProfileId) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withAppProfileId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)appProfileId))).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withStartTime(@UnknownKeyFor @NonNull @Initialized Instant startTime) {
            return this.toBuilder().setStartTime(startTime).build();
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized ReadChangeStream withEndTime(@UnknownKeyFor @NonNull @Initialized Instant endTime) {
            return this.toBuilder().setEndTime(endTime).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withHeartbeatDuration(@UnknownKeyFor @NonNull @Initialized Duration interval) {
            return this.toBuilder().setHeartbeatDuration(interval).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withChangeStreamName(@UnknownKeyFor @NonNull @Initialized String changeStreamName) {
            return this.toBuilder().setChangeStreamName(changeStreamName).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withExistingPipelineOptions(@UnknownKeyFor @NonNull @Initialized ExistingPipelineOptions existingPipelineOptions) {
            return this.toBuilder().setExistingPipelineOptions(existingPipelineOptions).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withMetadataTableProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
            BigtableConfig config = this.getMetadataTableBigtableConfig();
            return this.toBuilder().setMetadataTableBigtableConfig(config.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId))).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withMetadataTableInstanceId(@UnknownKeyFor @NonNull @Initialized String instanceId) {
            BigtableConfig config = this.getMetadataTableBigtableConfig();
            return this.toBuilder().setMetadataTableBigtableConfig(config.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId))).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withMetadataTableTableId(@UnknownKeyFor @NonNull @Initialized String tableId) {
            return this.toBuilder().setMetadataTableId(tableId).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withMetadataTableAppProfileId(@UnknownKeyFor @NonNull @Initialized String appProfileId) {
            BigtableConfig config = this.getMetadataTableBigtableConfig();
            return this.toBuilder().setMetadataTableBigtableConfig(config.withAppProfileId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)appProfileId))).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ChangeStreamMutation>> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            ExistingPipelineOptions existingPipelineOptions;
            String changeStreamName;
            Duration heartbeatDuration;
            Instant startTime;
            Preconditions.checkArgument((this.getBigtableConfig() != null ? 1 : 0) != 0, (Object)"BigtableIO ReadChangeStream is missing required configurations fields.");
            Preconditions.checkArgument((this.getBigtableConfig().getProjectId() != null ? 1 : 0) != 0, (Object)"Missing required projectId field.");
            Preconditions.checkArgument((this.getBigtableConfig().getInstanceId() != null ? 1 : 0) != 0, (Object)"Missing required instanceId field.");
            Preconditions.checkArgument((this.getTableId() != null ? 1 : 0) != 0, (Object)"Missing required tableId field.");
            BigtableConfig bigtableConfig = this.getBigtableConfig();
            if (this.getBigtableConfig().getAppProfileId() == null || ((String)this.getBigtableConfig().getAppProfileId().get()).isEmpty()) {
                bigtableConfig = bigtableConfig.withAppProfileId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)"default"));
            }
            BigtableConfig metadataTableConfig = this.getMetadataTableBigtableConfig();
            String metadataTableId = this.getMetadataTableId();
            if (metadataTableConfig.getProjectId() == null || ((String)metadataTableConfig.getProjectId().get()).isEmpty()) {
                metadataTableConfig = metadataTableConfig.withProjectId(bigtableConfig.getProjectId());
            }
            if (metadataTableConfig.getInstanceId() == null || ((String)metadataTableConfig.getInstanceId().get()).isEmpty()) {
                metadataTableConfig = metadataTableConfig.withInstanceId(bigtableConfig.getInstanceId());
            }
            if (metadataTableId == null || metadataTableId.isEmpty()) {
                metadataTableId = "__change_stream_md_table";
            }
            if (metadataTableConfig.getAppProfileId() == null || ((String)metadataTableConfig.getAppProfileId().get()).isEmpty()) {
                metadataTableConfig = metadataTableConfig.withAppProfileId(bigtableConfig.getAppProfileId());
            }
            if ((startTime = this.getStartTime()) == null) {
                startTime = Instant.now();
            }
            if ((heartbeatDuration = this.getHeartbeatDuration()) == null) {
                heartbeatDuration = Duration.standardSeconds((long)1L);
            }
            if ((changeStreamName = this.getChangeStreamName()) == null || changeStreamName.isEmpty()) {
                changeStreamName = UniqueIdGenerator.generateRowKeyPrefix();
            }
            if ((existingPipelineOptions = this.getExistingPipelineOptions()) == null) {
                existingPipelineOptions = ExistingPipelineOptions.FAIL_IF_EXISTS;
            }
            ActionFactory actionFactory = new ActionFactory();
            DaoFactory daoFactory = new DaoFactory(bigtableConfig, metadataTableConfig, this.getTableId(), metadataTableId, changeStreamName);
            ChangeStreamMetrics metrics = new ChangeStreamMetrics();
            InitializeDoFn initializeDoFn = new InitializeDoFn(daoFactory, (String)metadataTableConfig.getAppProfileId().get(), startTime, existingPipelineOptions);
            DetectNewPartitionsDoFn detectNewPartitionsDoFn = new DetectNewPartitionsDoFn(this.getEndTime(), actionFactory, daoFactory, metrics);
            ReadChangeStreamPartitionDoFn readChangeStreamPartitionDoFn = new ReadChangeStreamPartitionDoFn(heartbeatDuration, daoFactory, actionFactory, metrics);
            PCollection output = (PCollection)((PCollection)((PCollection)((PCollection)input.apply((PTransform)Impulse.create())).apply("Initialize", (PTransform)ParDo.of((DoFn)initializeDoFn))).apply("DetectNewPartition", (PTransform)ParDo.of((DoFn)detectNewPartitionsDoFn))).apply("ReadChangeStreamPartition", (PTransform)ParDo.of((DoFn)readChangeStreamPartitionDoFn));
            Coder outputCoder = output.getCoder();
            SizeEstimator sizeEstimator = new SizeEstimator(outputCoder);
            BytesThroughputEstimator<KV<ByteString, ChangeStreamMutation>> throughputEstimator = new BytesThroughputEstimator<KV<ByteString, ChangeStreamMutation>>(10, sizeEstimator);
            readChangeStreamPartitionDoFn.setThroughputEstimator(throughputEstimator);
            return output;
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBigtableConfig(@UnknownKeyFor @NonNull @Initialized BigtableConfig var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTableId(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMetadataTableBigtableConfig(@UnknownKeyFor @NonNull @Initialized BigtableConfig var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMetadataTableId(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setStartTime(@UnknownKeyFor @NonNull @Initialized Instant var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setEndTime(@UnknownKeyFor @NonNull @Initialized Instant var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setHeartbeatDuration(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setChangeStreamName(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setExistingPipelineOptions(@UnknownKeyFor @NonNull @Initialized ExistingPipelineOptions var1);

            abstract @UnknownKeyFor @NonNull @Initialized ReadChangeStream build();
        }
    }

    public static enum ExistingPipelineOptions {
        FAIL_IF_EXISTS,
        RESUME_OR_NEW,
        RESUME_OR_FAIL,
        NEW,
        SKIP_CLEANUP;

    }

    static class BigtableWriteException
    extends IOException {
        public BigtableWriteException(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Mutation>> record, @UnknownKeyFor @NonNull @Initialized Throwable cause) {
            super(String.format("Error mutating row %s with mutations %s", ((ByteString)record.getKey()).toStringUtf8(), record.getValue()), cause);
        }
    }

    private static class BigtableReader
    extends BoundedSource.BoundedReader<Row> {
        private @UnknownKeyFor @NonNull @Initialized BigtableSource source;
        private @Nullable @UnknownKeyFor @Initialized BigtableServiceFactory.BigtableServiceEntry serviceEntry;
        private  @UnknownKeyFor @NonNull @Initialized BigtableService.Reader reader;
        private final @UnknownKeyFor @NonNull @Initialized ByteKeyRangeTracker rangeTracker;
        private @UnknownKeyFor @NonNull @Initialized long recordsReturned;

        public BigtableReader(@UnknownKeyFor @NonNull @Initialized BigtableSource source, @UnknownKeyFor @NonNull @Initialized BigtableServiceFactory.BigtableServiceEntry service) {
            Preconditions.checkArgument((source.getRanges().size() == 1 ? 1 : 0) != 0, (Object)"source must have exactly one key range");
            this.source = source;
            this.serviceEntry = service;
            this.rangeTracker = ByteKeyRangeTracker.of((ByteKeyRange)source.getRanges().get(0));
        }

        public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
            boolean hasRecord;
            this.reader = this.serviceEntry.getService().createReader(this.getCurrentSource());
            boolean bl = hasRecord = this.reader.start() && this.rangeTracker.tryReturnRecordAt(true, BigtableIO.makeByteKey(this.reader.getCurrentRow().getKey())) || this.rangeTracker.markDone();
            if (hasRecord) {
                ++this.recordsReturned;
            }
            return hasRecord;
        }

        public synchronized @UnknownKeyFor @NonNull @Initialized BigtableSource getCurrentSource() {
            return this.source;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
            boolean hasRecord;
            boolean bl = hasRecord = this.reader.advance() && this.rangeTracker.tryReturnRecordAt(true, BigtableIO.makeByteKey(this.reader.getCurrentRow().getKey())) || this.rangeTracker.markDone();
            if (hasRecord) {
                ++this.recordsReturned;
            }
            return hasRecord;
        }

        public @UnknownKeyFor @NonNull @Initialized Row getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            return this.reader.getCurrentRow();
        }

        public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
            LOG.info("Closing reader after reading {} records.", (Object)this.recordsReturned);
            if (this.reader != null) {
                this.reader = null;
            }
            if (this.serviceEntry != null) {
                this.serviceEntry.close();
                this.serviceEntry = null;
            }
        }

        public final @UnknownKeyFor @NonNull @Initialized Double getFractionConsumed() {
            return this.rangeTracker.getFractionConsumed();
        }

        public final @UnknownKeyFor @NonNull @Initialized long getSplitPointsConsumed() {
            return this.rangeTracker.getSplitPointsConsumed();
        }

        public final synchronized @Nullable @UnknownKeyFor @Initialized BigtableSource splitAtFraction(@UnknownKeyFor @NonNull @Initialized double fraction) {
            BigtableSource residual;
            BigtableSource primary;
            ByteKey splitKey;
            ByteKeyRange range = this.rangeTracker.getRange();
            try {
                splitKey = range.interpolateKey(fraction);
            }
            catch (RuntimeException e) {
                LOG.info("{}: Failed to interpolate key for fraction {}.", new Object[]{range, fraction, e});
                return null;
            }
            LOG.info("Proposing to split {} at fraction {} (key {})", new Object[]{this.rangeTracker, fraction, splitKey});
            try {
                primary = this.source.withSingleRange(ByteKeyRange.of((ByteKey)range.getStartKey(), (ByteKey)splitKey));
                residual = this.source.withSingleRange(ByteKeyRange.of((ByteKey)splitKey, (ByteKey)range.getEndKey()));
            }
            catch (RuntimeException e) {
                LOG.info("{}: Interpolating for fraction {} yielded invalid split key {}.", new Object[]{this.rangeTracker.getRange(), fraction, splitKey, e});
                return null;
            }
            if (!this.rangeTracker.trySplitAtPosition(splitKey)) {
                return null;
            }
            this.source = primary;
            return residual;
        }
    }

    static class BigtableSource
    extends BoundedSource<Row> {
        private final @UnknownKeyFor @NonNull @Initialized BigtableConfig config;
        private final @UnknownKeyFor @NonNull @Initialized BigtableReadOptions readOptions;
        private @Nullable @UnknownKeyFor @Initialized Long estimatedSizeBytes;
        private final @UnknownKeyFor @NonNull @Initialized BigtableServiceFactory.ConfigId configId;
        private final @UnknownKeyFor @NonNull @Initialized BigtableServiceFactory factory;
        private static final @UnknownKeyFor @NonNull @Initialized long MAX_SPLIT_COUNT = 15360L;

        public BigtableSource(@UnknownKeyFor @NonNull @Initialized BigtableServiceFactory factory, @UnknownKeyFor @NonNull @Initialized BigtableServiceFactory.ConfigId configId, @UnknownKeyFor @NonNull @Initialized BigtableConfig config, @UnknownKeyFor @NonNull @Initialized BigtableReadOptions readOptions, @Nullable @UnknownKeyFor @Initialized Long estimatedSizeBytes) {
            this.factory = factory;
            this.configId = configId;
            this.config = config;
            this.readOptions = readOptions;
            this.estimatedSizeBytes = estimatedSizeBytes;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(BigtableSource.class).add("config", (Object)this.config).add("readOptions", (Object)this.readOptions).add("estimatedSizeBytes", (Object)this.estimatedSizeBytes).toString();
        }

        protected @UnknownKeyFor @NonNull @Initialized BigtableSource withSingleRange(@UnknownKeyFor @NonNull @Initialized ByteKeyRange range) {
            Preconditions.checkArgument((range != null ? 1 : 0) != 0, (Object)"range can not be null");
            return new BigtableSource(this.factory, this.configId, this.config, this.readOptions.withKeyRange(range), this.estimatedSizeBytes);
        }

        protected @UnknownKeyFor @NonNull @Initialized BigtableSource withEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized Long estimatedSizeBytes) {
            Preconditions.checkArgument((estimatedSizeBytes != null ? 1 : 0) != 0, (Object)"estimatedSizeBytes can not be null");
            return new BigtableSource(this.factory, this.configId, this.config, this.readOptions, estimatedSizeBytes);
        }

        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KeyOffset> getSampleRowKeys(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
            try (BigtableServiceFactory.BigtableServiceEntry serviceEntry = this.factory.getServiceForReading(this.configId, this.config, this.readOptions, pipelineOptions);){
                List<KeyOffset> list = serviceEntry.getService().getSampleRowKeys(this);
                return list;
            }
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BigtableSource> split(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
            long maximumNumberOfSplits = 4000L;
            long sizeEstimate = this.getEstimatedSizeBytes(options);
            desiredBundleSizeBytes = Math.max(sizeEstimate / maximumNumberOfSplits, desiredBundleSizeBytes);
            List<BigtableSource> splits = this.splitBasedOnSamples(desiredBundleSizeBytes, this.getSampleRowKeys(options));
            List<BigtableSource> reduced = this.reduceSplits(splits, options, 15360L);
            Collections.shuffle(reduced);
            return ImmutableList.copyOf(reduced);
        }

        @VisibleForTesting
        protected @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BigtableSource> reduceSplits(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BigtableSource> splits, @UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized long maxSplitCounts) throws @UnknownKeyFor @NonNull @Initialized IOException {
            int numberToCombine = (int)(((long)splits.size() + maxSplitCounts - 1L) / maxSplitCounts);
            if ((long)splits.size() < maxSplitCounts || numberToCombine < 2) {
                return new ArrayList<BigtableSource>(splits);
            }
            ArrayList<BigtableSource> reducedSplits = new ArrayList<BigtableSource>();
            List<Object> previousSourceRanges = new ArrayList<ByteKeyRange>();
            int counter = 0;
            long size = 0L;
            for (BigtableSource source : splits) {
                if (counter == numberToCombine || !BigtableSource.checkRangeAdjacency(previousSourceRanges, source.getRanges())) {
                    reducedSplits.add(new BigtableSource(this.factory, this.configId, this.config, this.readOptions.withKeyRanges(previousSourceRanges), size));
                    counter = 0;
                    size = 0L;
                    previousSourceRanges = new ArrayList();
                }
                previousSourceRanges.addAll(source.getRanges());
                previousSourceRanges = BigtableSource.mergeRanges(previousSourceRanges);
                size += source.getEstimatedSizeBytes(options);
                ++counter;
            }
            if (size > 0L) {
                reducedSplits.add(new BigtableSource(this.factory, this.configId, this.config, this.readOptions.withKeyRanges(previousSourceRanges), size));
            }
            return reducedSplits;
        }

        private static @UnknownKeyFor @NonNull @Initialized boolean checkRangeAdjacency(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteKeyRange> ranges, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteKeyRange> otherRanges) {
            Preconditions.checkArgument((ranges != null || otherRanges != null ? 1 : 0) != 0, (Object)"Both ranges cannot be null.");
            ImmutableList.Builder mergedRanges = ImmutableList.builder();
            if (ranges != null) {
                mergedRanges.addAll(ranges);
            }
            if (otherRanges != null) {
                mergedRanges.addAll(otherRanges);
            }
            return BigtableSource.checkRangeAdjacency((List<ByteKeyRange>)mergedRanges.build());
        }

        private static @UnknownKeyFor @NonNull @Initialized boolean checkRangeAdjacency(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteKeyRange> ranges) {
            int index = 0;
            if (ranges.size() < 2) {
                return true;
            }
            ByteKey lastEndKey = ranges.get(index++).getEndKey();
            while (index < ranges.size()) {
                ByteKeyRange currentKeyRange;
                if (!lastEndKey.equals((Object)(currentKeyRange = ranges.get(index++)).getStartKey())) {
                    return false;
                }
                lastEndKey = currentKeyRange.getEndKey();
            }
            return true;
        }

        private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteKeyRange> mergeRanges(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteKeyRange> ranges) {
            ArrayList<ByteKeyRange> response = new ArrayList<ByteKeyRange>();
            if (ranges.size() < 2) {
                response.add(ranges.get(0));
            } else {
                response.add(ByteKeyRange.of((ByteKey)ranges.get(0).getStartKey(), (ByteKey)ranges.get(ranges.size() - 1).getEndKey()));
            }
            return response;
        }

        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BigtableSource> splitBasedOnSamples(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KeyOffset> sampleRowKeys) {
            if (sampleRowKeys.isEmpty()) {
                LOG.info("Not splitting source {} because no sample row keys are available.", (Object)this);
                return Collections.singletonList(this);
            }
            LOG.info("About to split into bundles of size {} with sampleRowKeys length {} first element {}", new Object[]{desiredBundleSizeBytes, sampleRowKeys.size(), sampleRowKeys.get(0)});
            ImmutableList.Builder splits = ImmutableList.builder();
            for (ByteKeyRange range : this.getRanges()) {
                splits.addAll(this.splitRangeBasedOnSamples(desiredBundleSizeBytes, sampleRowKeys, range));
            }
            return splits.build();
        }

        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BigtableSource> splitRangeBasedOnSamples(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KeyOffset> sampleRowKeys, @UnknownKeyFor @NonNull @Initialized ByteKeyRange range) {
            ByteKey lastEndKey = ByteKey.EMPTY;
            long lastOffset = 0L;
            ImmutableList.Builder splits = ImmutableList.builder();
            for (KeyOffset keyOffset : sampleRowKeys) {
                ByteKey splitEndKey;
                ByteKey responseEndKey = BigtableIO.makeByteKey(keyOffset.getKey());
                long responseOffset = keyOffset.getOffsetBytes();
                Preconditions.checkState((responseOffset >= lastOffset ? 1 : 0) != 0, (String)"Expected response byte offset %s to come after the last offset %s", (long)responseOffset, (long)lastOffset);
                if (!range.overlaps(ByteKeyRange.of((ByteKey)lastEndKey, (ByteKey)responseEndKey)).booleanValue()) {
                    lastOffset = responseOffset;
                    lastEndKey = responseEndKey;
                    continue;
                }
                ByteKey splitStartKey = lastEndKey;
                if (splitStartKey.compareTo(range.getStartKey()) < 0) {
                    splitStartKey = range.getStartKey();
                }
                if (!range.containsKey(splitEndKey = responseEndKey).booleanValue()) {
                    splitEndKey = range.getEndKey();
                }
                long sampleSizeBytes = responseOffset - lastOffset;
                List<BigtableSource> subSplits = this.splitKeyRangeIntoBundleSizedSubranges(sampleSizeBytes, desiredBundleSizeBytes, ByteKeyRange.of((ByteKey)splitStartKey, (ByteKey)splitEndKey));
                splits.addAll(subSplits);
                lastEndKey = responseEndKey;
                lastOffset = responseOffset;
            }
            if (!lastEndKey.isEmpty() && (range.getEndKey().isEmpty() || lastEndKey.compareTo(range.getEndKey()) < 0)) {
                splits.add((Object)this.withSingleRange(ByteKeyRange.of((ByteKey)lastEndKey, (ByteKey)range.getEndKey())));
            }
            ImmutableList ret = splits.build();
            LOG.info("Generated {} splits. First split: {}", (Object)ret.size(), ret.get(0));
            return ret;
        }

        public @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.estimatedSizeBytes == null) {
                this.estimatedSizeBytes = this.getEstimatedSizeBytesBasedOnSamples(this.getSampleRowKeys(options));
            }
            return this.estimatedSizeBytes;
        }

        private @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytesBasedOnSamples(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KeyOffset> samples) {
            long estimatedSizeBytes = 0L;
            long lastOffset = 0L;
            ByteKey currentStartKey = ByteKey.EMPTY;
            for (KeyOffset keyOffset : samples) {
                ByteKey currentEndKey = BigtableIO.makeByteKey(keyOffset.getKey());
                long currentOffset = keyOffset.getOffsetBytes();
                if (!currentStartKey.isEmpty() && currentStartKey.equals((Object)currentEndKey)) {
                    lastOffset = currentOffset;
                    continue;
                }
                for (ByteKeyRange range : this.getRanges()) {
                    if (!range.overlaps(ByteKeyRange.of((ByteKey)currentStartKey, (ByteKey)currentEndKey)).booleanValue()) continue;
                    estimatedSizeBytes += currentOffset - lastOffset;
                    break;
                }
                currentStartKey = currentEndKey;
                lastOffset = currentOffset;
            }
            return estimatedSizeBytes;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<@UnknownKeyFor @NonNull @Initialized Row> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return new BigtableReader(this, this.factory.getServiceForReading(this.configId, this.config, this.readOptions, options));
        }

        public void validate() {
            if (!this.config.getValidate()) {
                LOG.debug("Validation is disabled");
                return;
            }
            ValueProvider<String> tableId = this.readOptions.getTableId();
            Preconditions.checkArgument((tableId != null && tableId.isAccessible() && !((String)tableId.get()).isEmpty() ? 1 : 0) != 0, (Object)"tableId was not supplied");
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"tableId", this.readOptions.getTableId()).withLabel("Table ID"));
            if (this.getRowFilter() != null) {
                builder.add(DisplayData.item((String)"rowFilter", (String)this.getRowFilter().toString()).withLabel("Table Row Filter"));
            }
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Row> getOutputCoder() {
            return ProtoCoder.of(Row.class);
        }

        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BigtableSource> splitKeyRangeIntoBundleSizedSubranges(@UnknownKeyFor @NonNull @Initialized long sampleSizeBytes, @UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized ByteKeyRange range) {
            LOG.debug("Subsplit for sampleSizeBytes {} and desiredBundleSizeBytes {}", (Object)sampleSizeBytes, (Object)desiredBundleSizeBytes);
            if (sampleSizeBytes <= desiredBundleSizeBytes) {
                return Collections.singletonList(this.withSingleRange(ByteKeyRange.of((ByteKey)range.getStartKey(), (ByteKey)range.getEndKey())));
            }
            Preconditions.checkArgument((sampleSizeBytes > 0L ? 1 : 0) != 0, (String)"Sample size %s bytes must be greater than 0.", (long)sampleSizeBytes);
            Preconditions.checkArgument((desiredBundleSizeBytes > 0L ? 1 : 0) != 0, (String)"Desired bundle size %s bytes must be greater than 0.", (long)desiredBundleSizeBytes);
            int splitCount = (int)Math.ceil((double)sampleSizeBytes / (double)desiredBundleSizeBytes);
            List splitKeys = range.split(splitCount);
            ImmutableList.Builder splits = ImmutableList.builder();
            Iterator keys = splitKeys.iterator();
            ByteKey prev = (ByteKey)keys.next();
            while (keys.hasNext()) {
                ByteKey next = (ByteKey)keys.next();
                splits.add((Object)this.withSingleRange(ByteKeyRange.of((ByteKey)prev, (ByteKey)next)).withEstimatedSizeBytes(sampleSizeBytes / (long)splitCount));
                prev = next;
            }
            return splits.build();
        }

        public @UnknownKeyFor @NonNull @Initialized BigtableReadOptions getReadOptions() {
            return this.readOptions;
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteKeyRange> getRanges() {
            return (List)this.readOptions.getKeyRanges().get();
        }

        public @Nullable @UnknownKeyFor @Initialized RowFilter getRowFilter() {
            ValueProvider<RowFilter> rowFilter = this.readOptions.getRowFilter();
            return rowFilter != null && rowFilter.isAccessible() ? (RowFilter)rowFilter.get() : null;
        }

        public @Nullable @UnknownKeyFor @Initialized Integer getMaxBufferElementCount() {
            return this.readOptions.getMaxBufferElementCount();
        }

        public @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getTableId() {
            return this.readOptions.getTableId();
        }
    }

    private static class BigtableWriterFn
    extends DoFn<KV<ByteString, Iterable<Mutation>>, BigtableWriteResult> {
        private final @UnknownKeyFor @NonNull @Initialized BigtableServiceFactory factory;
        private final @UnknownKeyFor @NonNull @Initialized BigtableServiceFactory.ConfigId id;
        private @Nullable @UnknownKeyFor @Initialized BigtableServiceFactory.BigtableServiceEntry serviceEntry;
        private final @UnknownKeyFor @NonNull @Initialized BigtableConfig config;
        private final @UnknownKeyFor @NonNull @Initialized BigtableWriteOptions writeOptions;
        private  @UnknownKeyFor @NonNull @Initialized BigtableService.Writer bigtableWriter;
        private @UnknownKeyFor @NonNull @Initialized long recordsWritten;
        private final @UnknownKeyFor @NonNull @Initialized ConcurrentLinkedQueue<@UnknownKeyFor @NonNull @Initialized BigtableWriteException> failures;
        private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized Long> seenWindows;

        BigtableWriterFn(@UnknownKeyFor @NonNull @Initialized BigtableServiceFactory factory, @UnknownKeyFor @NonNull @Initialized BigtableConfig bigtableConfig, @UnknownKeyFor @NonNull @Initialized BigtableWriteOptions writeOptions) {
            this.factory = factory;
            this.config = bigtableConfig;
            this.writeOptions = writeOptions;
            this.failures = new ConcurrentLinkedQueue();
            this.id = factory.newId();
        }

        @DoFn.StartBundle
        public void startBundle(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext c) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.recordsWritten = 0L;
            this.seenWindows = Maps.newHashMapWithExpectedSize((int)1);
            if (this.bigtableWriter == null) {
                this.serviceEntry = this.factory.getServiceForWriting(this.id, this.config, this.writeOptions, c.getPipelineOptions());
                this.bigtableWriter = this.serviceEntry.getService().openForWriting((String)this.writeOptions.getTableId().get());
            }
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.checkForFailures();
            KV record = (KV)c.element();
            this.bigtableWriter.writeRecord((KV<ByteString, Iterable<Mutation>>)record).whenComplete((mutationResult, exception) -> {
                if (exception != null) {
                    this.failures.add(new BigtableWriteException((KV<ByteString, Iterable<Mutation>>)record, (Throwable)exception));
                }
            });
            ++this.recordsWritten;
            this.seenWindows.compute(window, (key, count) -> (count != null ? count : 0L) + 1L);
        }

        @DoFn.FinishBundle
        public void finishBundle(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.bigtableWriter.flush();
            this.checkForFailures();
            LOG.debug("Wrote {} records", (Object)this.recordsWritten);
            for (Map.Entry<BoundedWindow, Long> entry : this.seenWindows.entrySet()) {
                c.output((Object)BigtableWriteResult.create(entry.getValue()), entry.getKey().maxTimestamp(), entry.getKey());
            }
        }

        @DoFn.Teardown
        public void tearDown() throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (this.bigtableWriter != null) {
                this.bigtableWriter.close();
                this.bigtableWriter = null;
            }
            if (this.serviceEntry != null) {
                this.serviceEntry.close();
                this.serviceEntry = null;
            }
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            this.config.populateDisplayData(builder);
        }

        private void checkForFailures() throws @UnknownKeyFor @NonNull @Initialized IOException {
            int i;
            if (this.failures.isEmpty()) {
                return;
            }
            StringBuilder logEntry = new StringBuilder();
            ArrayList suppressed = Lists.newArrayList();
            for (i = 0; i < 10 && !this.failures.isEmpty(); ++i) {
                BigtableWriteException exc = (BigtableWriteException)this.failures.remove();
                logEntry.append("\n").append(exc.getMessage());
                if (exc.getCause() != null) {
                    logEntry.append(": ").append(exc.getCause().getMessage());
                }
                suppressed.add(exc);
            }
            String message = String.format("At least %d errors occurred writing to Bigtable. First %d errors: %s", i + this.failures.size(), i, logEntry.toString());
            LOG.error(message);
            IOException exception = new IOException(message);
            for (BigtableWriteException e : suppressed) {
                exception.addSuppressed(e);
            }
            throw exception;
        }
    }

    public static class WriteWithResults
    extends PTransform<PCollection<KV<ByteString, Iterable<Mutation>>>, PCollection<BigtableWriteResult>> {
        private final @UnknownKeyFor @NonNull @Initialized BigtableConfig bigtableConfig;
        private final @UnknownKeyFor @NonNull @Initialized BigtableWriteOptions bigtableWriteOptions;
        private final @UnknownKeyFor @NonNull @Initialized BigtableServiceFactory factory;

        WriteWithResults(@UnknownKeyFor @NonNull @Initialized BigtableConfig bigtableConfig, @UnknownKeyFor @NonNull @Initialized BigtableWriteOptions bigtableWriteOptions, @UnknownKeyFor @NonNull @Initialized BigtableServiceFactory factory) {
            this.bigtableConfig = bigtableConfig;
            this.bigtableWriteOptions = bigtableWriteOptions;
            this.factory = factory;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized BigtableWriteResult> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Mutation>>> input) {
            this.bigtableConfig.validate();
            this.bigtableWriteOptions.validate();
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new BigtableWriterFn(this.factory, this.bigtableConfig, this.bigtableWriteOptions)));
        }

        public void validate(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            this.validateTableExists(this.bigtableConfig, this.bigtableWriteOptions, options);
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.bigtableConfig.populateDisplayData(builder);
            this.bigtableWriteOptions.populateDisplayData(builder);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(WriteWithResults.class).add("config", (Object)this.bigtableConfig).add("writeOptions", (Object)this.bigtableWriteOptions).toString();
        }

        private void validateTableExists(@UnknownKeyFor @NonNull @Initialized BigtableConfig config, @UnknownKeyFor @NonNull @Initialized BigtableWriteOptions writeOptions, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            if (config.getValidate() && config.isDataAccessible() && writeOptions.isDataAccessible()) {
                String tableId = (String)Preconditions.checkNotNull((Object)((String)writeOptions.getTableId().get()));
                try {
                    Preconditions.checkArgument((boolean)this.factory.checkTableExists(config, options, (String)writeOptions.getTableId().get()), (String)"Table %s does not exist", (Object)tableId);
                }
                catch (IOException e) {
                    LOG.warn("Error checking whether table {} exists; proceeding.", (Object)tableId, (Object)e);
                }
            }
        }
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<KV<ByteString, Iterable<Mutation>>>, PDone> {
        static @UnknownKeyFor @NonNull @Initialized SerializableFunction<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder> enableBulkApiConfigurator(@Nullable @UnknownKeyFor @Initialized SerializableFunction<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder> userConfigurator) {
            return (SerializableFunction & Serializable)optionsBuilder -> {
                if (userConfigurator != null) {
                    optionsBuilder = (BigtableOptions.Builder)userConfigurator.apply(optionsBuilder);
                }
                return optionsBuilder.setBulkOptions(optionsBuilder.build().getBulkOptions().toBuilder().setUseBulkApi(true).build());
            };
        }

        abstract @UnknownKeyFor @NonNull @Initialized BigtableConfig getBigtableConfig();

        abstract @UnknownKeyFor @NonNull @Initialized BigtableWriteOptions getBigtableWriteOptions();

        @VisibleForTesting
        abstract @UnknownKeyFor @NonNull @Initialized BigtableServiceFactory getServiceFactory();

        @Deprecated
        public @Nullable @UnknownKeyFor @Initialized BigtableOptions getBigtableOptions() {
            return this.getBigtableConfig().getBigtableOptions();
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        static @UnknownKeyFor @NonNull @Initialized Write create() {
            BigtableConfig config = BigtableConfig.builder().setValidate(true).build();
            BigtableWriteOptions writeOptions = BigtableWriteOptions.builder().setTableId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)"")).build();
            return new AutoValue_BigtableIO_Write.Builder().setBigtableConfig(config).setBigtableWriteOptions(writeOptions).setServiceFactory(new BigtableServiceFactory()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withProjectId(projectId)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withInstanceId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> instanceId) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withInstanceId(instanceId)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withInstanceId(@UnknownKeyFor @NonNull @Initialized String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withTableId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tableId) {
            BigtableWriteOptions writeOptions = this.getBigtableWriteOptions();
            return this.toBuilder().setBigtableWriteOptions(writeOptions.toBuilder().setTableId(tableId).build()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withTableId(@UnknownKeyFor @NonNull @Initialized String tableId) {
            return this.withTableId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)tableId));
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized Write withBigtableOptions(@UnknownKeyFor @NonNull @Initialized BigtableOptions options) {
            Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"options can not be null");
            return this.withBigtableOptions(options.toBuilder());
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized Write withBigtableOptions(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder optionsBuilder) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withBigtableOptions(optionsBuilder.build())).build();
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized Write withBigtableOptionsConfigurator(@UnknownKeyFor @NonNull @Initialized SerializableFunction<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder> configurator) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withBigtableOptionsConfigurator(Write.enableBulkApiConfigurator(configurator))).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withoutValidation() {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withValidate(false)).build();
        }

        @VisibleForTesting
        public @UnknownKeyFor @NonNull @Initialized Write withEmulator(@UnknownKeyFor @NonNull @Initialized String emulatorHost) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withEmulator(emulatorHost)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withAttemptTimeout(@UnknownKeyFor @NonNull @Initialized Duration timeout) {
            Preconditions.checkArgument((boolean)timeout.isLongerThan((ReadableDuration)Duration.ZERO), (Object)"attempt timeout must be positive");
            BigtableWriteOptions options = this.getBigtableWriteOptions();
            return this.toBuilder().setBigtableWriteOptions(options.toBuilder().setAttemptTimeout(timeout).build()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withOperationTimeout(@UnknownKeyFor @NonNull @Initialized Duration timeout) {
            Preconditions.checkArgument((boolean)timeout.isLongerThan((ReadableDuration)Duration.ZERO), (Object)"operation timeout must be positive");
            BigtableWriteOptions options = this.getBigtableWriteOptions();
            return this.toBuilder().setBigtableWriteOptions(options.toBuilder().setOperationTimeout(timeout).build()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withMaxElementsPerBatch(@UnknownKeyFor @NonNull @Initialized long size) {
            Preconditions.checkArgument((size > 0L ? 1 : 0) != 0, (Object)"max elements per batch size must be positive");
            BigtableWriteOptions options = this.getBigtableWriteOptions();
            return this.toBuilder().setBigtableWriteOptions(options.toBuilder().setMaxElementsPerBatch(size).build()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withMaxBytesPerBatch(@UnknownKeyFor @NonNull @Initialized long size) {
            Preconditions.checkArgument((size > 0L ? 1 : 0) != 0, (Object)"max bytes per batch size must be positive");
            BigtableWriteOptions options = this.getBigtableWriteOptions();
            return this.toBuilder().setBigtableWriteOptions(options.toBuilder().setMaxBytesPerBatch(size).build()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withMaxOutstandingElements(@UnknownKeyFor @NonNull @Initialized long count) {
            Preconditions.checkArgument((count > 0L ? 1 : 0) != 0, (Object)"max outstanding elements must be positive");
            BigtableWriteOptions options = this.getBigtableWriteOptions();
            return this.toBuilder().setBigtableWriteOptions(options.toBuilder().setMaxOutstandingElements(count).build()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withMaxOutstandingBytes(@UnknownKeyFor @NonNull @Initialized long bytes) {
            Preconditions.checkArgument((bytes > 0L ? 1 : 0) != 0, (Object)"max outstanding bytes must be positive");
            BigtableWriteOptions options = this.getBigtableWriteOptions();
            return this.toBuilder().setBigtableWriteOptions(options.toBuilder().setMaxOutstandingBytes(bytes).build()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withFlowControl(@UnknownKeyFor @NonNull @Initialized boolean enableFlowControl) {
            BigtableWriteOptions options = this.getBigtableWriteOptions();
            return this.toBuilder().setBigtableWriteOptions(options.toBuilder().setFlowControl(enableFlowControl).build()).build();
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized Write withServiceFactory(@UnknownKeyFor @NonNull @Initialized BigtableServiceFactory factory) {
            return this.toBuilder().setServiceFactory(factory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized WriteWithResults withWriteResults() {
            return new WriteWithResults(this.getBigtableConfig(), this.getBigtableWriteOptions(), this.getServiceFactory());
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Mutation>>> input) {
            input.apply((PTransform)this.withWriteResults());
            return PDone.in((Pipeline)input.getPipeline());
        }

        public void validate(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            this.withWriteResults().validate(options);
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            this.withWriteResults().populateDisplayData(builder);
        }

        @SideEffectFree
        public final @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(Write.class).add("config", (Object)this.getBigtableConfig()).toString();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBigtableConfig(@UnknownKeyFor @NonNull @Initialized BigtableConfig var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBigtableWriteOptions(@UnknownKeyFor @NonNull @Initialized BigtableWriteOptions var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setServiceFactory(@UnknownKeyFor @NonNull @Initialized BigtableServiceFactory var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write build();
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<Row>> {
        abstract @UnknownKeyFor @NonNull @Initialized BigtableConfig getBigtableConfig();

        abstract @UnknownKeyFor @NonNull @Initialized BigtableReadOptions getBigtableReadOptions();

        @VisibleForTesting
        abstract @UnknownKeyFor @NonNull @Initialized BigtableServiceFactory getServiceFactory();

        public @Nullable @UnknownKeyFor @Initialized String getTableId() {
            ValueProvider<String> tableId = this.getBigtableReadOptions().getTableId();
            return tableId != null && tableId.isAccessible() ? (String)tableId.get() : null;
        }

        @Deprecated
        public @Nullable @UnknownKeyFor @Initialized BigtableOptions getBigtableOptions() {
            return this.getBigtableConfig().getBigtableOptions();
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        static @UnknownKeyFor @NonNull @Initialized Read create() {
            BigtableConfig config = BigtableConfig.builder().setValidate(true).build();
            return new AutoValue_BigtableIO_Read.Builder().setBigtableConfig(config).setBigtableReadOptions(BigtableReadOptions.builder().setTableId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)"")).setKeyRanges((ValueProvider<List<ByteKeyRange>>)ValueProvider.StaticValueProvider.of(Collections.singletonList(ByteKeyRange.ALL_KEYS))).build()).setServiceFactory(new BigtableServiceFactory()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withProjectId(projectId)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withInstanceId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> instanceId) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withInstanceId(instanceId)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withInstanceId(@UnknownKeyFor @NonNull @Initialized String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withTableId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tableId) {
            BigtableReadOptions bigtableReadOptions = this.getBigtableReadOptions();
            return this.toBuilder().setBigtableReadOptions(bigtableReadOptions.toBuilder().setTableId(tableId).build()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withTableId(@UnknownKeyFor @NonNull @Initialized String tableId) {
            return this.withTableId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)tableId));
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized Read withBigtableOptions(@UnknownKeyFor @NonNull @Initialized BigtableOptions options) {
            Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"options can not be null");
            return this.withBigtableOptions(options.toBuilder());
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized Read withBigtableOptions(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder optionsBuilder) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withBigtableOptions(optionsBuilder.build().toBuilder().build())).build();
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized Read withBigtableOptionsConfigurator(@UnknownKeyFor @NonNull @Initialized SerializableFunction<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder> configurator) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withBigtableOptionsConfigurator(configurator)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withRowFilter(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized RowFilter> filter) {
            Preconditions.checkArgument((filter != null ? 1 : 0) != 0, (Object)"filter can not be null");
            BigtableReadOptions bigtableReadOptions = this.getBigtableReadOptions();
            return this.toBuilder().setBigtableReadOptions(bigtableReadOptions.toBuilder().setRowFilter(filter).build()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withRowFilter(@UnknownKeyFor @NonNull @Initialized RowFilter filter) {
            return this.withRowFilter((ValueProvider<RowFilter>)ValueProvider.StaticValueProvider.of((Object)filter));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withMaxBufferElementCount(@Nullable @UnknownKeyFor @Initialized Integer maxBufferElementCount) {
            BigtableReadOptions bigtableReadOptions = this.getBigtableReadOptions();
            return this.toBuilder().setBigtableReadOptions(bigtableReadOptions.toBuilder().setMaxBufferElementCount(maxBufferElementCount).build()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withKeyRange(@UnknownKeyFor @NonNull @Initialized ByteKeyRange keyRange) {
            return this.withKeyRanges(Collections.singletonList(keyRange));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withKeyRanges(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteKeyRange>> keyRanges) {
            Preconditions.checkArgument((keyRanges != null ? 1 : 0) != 0, (Object)"keyRanges can not be null");
            BigtableReadOptions bigtableReadOptions = this.getBigtableReadOptions();
            return this.toBuilder().setBigtableReadOptions(bigtableReadOptions.toBuilder().setKeyRanges(keyRanges).build()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withKeyRanges(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteKeyRange> keyRanges) {
            return this.withKeyRanges((ValueProvider<List<ByteKeyRange>>)ValueProvider.StaticValueProvider.of(keyRanges));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withoutValidation() {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withValidate(false)).build();
        }

        @VisibleForTesting
        public @UnknownKeyFor @NonNull @Initialized Read withEmulator(@UnknownKeyFor @NonNull @Initialized String emulatorHost) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withEmulator(emulatorHost)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withAttemptTimeout(@UnknownKeyFor @NonNull @Initialized Duration timeout) {
            Preconditions.checkArgument((boolean)timeout.isLongerThan((ReadableDuration)Duration.ZERO), (Object)"attempt timeout must be positive");
            BigtableReadOptions readOptions = this.getBigtableReadOptions();
            return this.toBuilder().setBigtableReadOptions(readOptions.toBuilder().setAttemptTimeout(timeout).build()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withOperationTimeout(@UnknownKeyFor @NonNull @Initialized Duration timeout) {
            Preconditions.checkArgument((boolean)timeout.isLongerThan((ReadableDuration)Duration.ZERO), (Object)"operation timeout must be positive");
            BigtableReadOptions readOptions = this.getBigtableReadOptions();
            return this.toBuilder().setBigtableReadOptions(readOptions.toBuilder().setOperationTimeout(timeout).build()).build();
        }

        @UnknownKeyFor @NonNull @Initialized Read withServiceFactory(@UnknownKeyFor @NonNull @Initialized BigtableServiceFactory factory) {
            return this.toBuilder().setServiceFactory(factory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            this.getBigtableConfig().validate();
            this.getBigtableReadOptions().validate();
            BigtableSource source = new BigtableSource(this.getServiceFactory(), this.getServiceFactory().newId(), this.getBigtableConfig(), this.getBigtableReadOptions(), null);
            return (PCollection)input.getPipeline().apply((PTransform)org.apache.beam.sdk.io.Read.from((BoundedSource)source));
        }

        public void validate(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            this.validateTableExists(this.getBigtableConfig(), this.getBigtableReadOptions(), options);
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.getBigtableConfig().populateDisplayData(builder);
            this.getBigtableReadOptions().populateDisplayData(builder);
        }

        @SideEffectFree
        public final @UnknownKeyFor @NonNull @Initialized String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Read.class).add("config", (Object)this.getBigtableConfig());
            return helper.add("readOptions", (Object)this.getBigtableReadOptions()).toString();
        }

        private void validateTableExists(@UnknownKeyFor @NonNull @Initialized BigtableConfig config, @UnknownKeyFor @NonNull @Initialized BigtableReadOptions readOptions, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            if (config.getValidate() && config.isDataAccessible() && readOptions.isDataAccessible()) {
                String tableId = (String)Preconditions.checkNotNull((Object)((String)readOptions.getTableId().get()));
                try {
                    Preconditions.checkArgument((boolean)this.getServiceFactory().checkTableExists(config, options, tableId), (String)"Table %s does not exist", (Object)tableId);
                }
                catch (IOException e) {
                    LOG.warn("Error checking whether table {} exists; proceeding.", (Object)tableId, (Object)e);
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBigtableConfig(@UnknownKeyFor @NonNull @Initialized BigtableConfig var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBigtableReadOptions(@UnknownKeyFor @NonNull @Initialized BigtableReadOptions var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setServiceFactory(@UnknownKeyFor @NonNull @Initialized BigtableServiceFactory var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read build();
        }
    }
}

