/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.restriction;

import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.restriction.StreamProgress;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

@Internal
public class ReadChangeStreamPartitionProgressTracker
extends RestrictionTracker<StreamProgress, StreamProgress> {
    @UnknownKeyFor @NonNull @Initialized StreamProgress streamProgress;
    @UnknownKeyFor @NonNull @Initialized boolean shouldStop = false;

    public ReadChangeStreamPartitionProgressTracker(@UnknownKeyFor @NonNull @Initialized StreamProgress streamProgress) {
        this.streamProgress = streamProgress;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized RestrictionTracker.IsBounded isBounded() {
        return RestrictionTracker.IsBounded.UNBOUNDED;
    }

    public void checkDone() throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
        boolean done = this.shouldStop || this.streamProgress.getCloseStream() != null || this.streamProgress.isFailToLock();
        Preconditions.checkState((boolean)done, (Object)"There's more work to be done");
    }

    public @UnknownKeyFor @NonNull @Initialized boolean tryClaim(@UnknownKeyFor @NonNull @Initialized StreamProgress streamProgress) {
        if (this.shouldStop) {
            return false;
        }
        this.streamProgress = streamProgress;
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized StreamProgress currentRestriction() {
        return this.streamProgress;
    }

    public @Nullable @UnknownKeyFor @Initialized SplitResult<@UnknownKeyFor @NonNull @Initialized StreamProgress> trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
        if (fractionOfRemainder == 0.0) {
            if (this.shouldStop) {
                return null;
            }
            this.shouldStop = true;
            return SplitResult.of(null, (Object)this.streamProgress);
        }
        return null;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "CustomRestrictionTracker{streamProgress=" + this.streamProgress + ", shouldStop=" + this.shouldStop + '}';
    }
}

