/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class ProcCpu
implements Serializable {
    private static final long serialVersionUID = 6748L;
    double percent = 0.0;
    long lastTime = 0L;
    long startTime = 0L;
    long user = 0L;
    long sys = 0L;
    long total = 0L;

    public native void gather(Sigar var1, long var2) throws SigarException;

    static ProcCpu fetch(Sigar sigar, long pid) throws SigarException {
        ProcCpu procCpu = new ProcCpu();
        procCpu.gather(sigar, pid);
        return procCpu;
    }

    public double getPercent() {
        return this.percent;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getUser() {
        return this.user;
    }

    public long getSys() {
        return this.sys;
    }

    public long getTotal() {
        return this.total;
    }

    void copyTo(ProcCpu copy) {
        copy.percent = this.percent;
        copy.lastTime = this.lastTime;
        copy.startTime = this.startTime;
        copy.user = this.user;
        copy.sys = this.sys;
        copy.total = this.total;
    }

    public Map toMap() {
        String strtotal;
        String strsys;
        String struser;
        String strstartTime;
        String strlastTime;
        HashMap<String, String> map = new HashMap<String, String>();
        String strpercent = String.valueOf(this.percent);
        if (!"-1".equals(strpercent)) {
            map.put("Percent", strpercent);
        }
        if (!"-1".equals(strlastTime = String.valueOf(this.lastTime))) {
            map.put("LastTime", strlastTime);
        }
        if (!"-1".equals(strstartTime = String.valueOf(this.startTime))) {
            map.put("StartTime", strstartTime);
        }
        if (!"-1".equals(struser = String.valueOf(this.user))) {
            map.put("User", struser);
        }
        if (!"-1".equals(strsys = String.valueOf(this.sys))) {
            map.put("Sys", strsys);
        }
        if (!"-1".equals(strtotal = String.valueOf(this.total))) {
            map.put("Total", strtotal);
        }
        return map;
    }

    public String toString() {
        return this.toMap().toString();
    }
}

