/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.StreamResumptionStrategy;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.bigquery.storage.v1.BaseBigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamRequest;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamResponse;
import com.google.cloud.bigquery.storage.v1.stub.BigQueryReadStubSettings;
import com.google.cloud.bigquery.storage.v1.stub.readrows.ReadRowsResumptionStrategy;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class EnhancedBigQueryReadStubSettings
extends StubSettings<EnhancedBigQueryReadStubSettings> {
    private final UnaryCallSettings<CreateReadSessionRequest, ReadSession> createReadSessionSettings;
    private final ServerStreamingCallSettings<ReadRowsRequest, ReadRowsResponse> readRowsSettings;
    private final UnaryCallSettings<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamSettings;

    public UnaryCallSettings<CreateReadSessionRequest, ReadSession> createReadSessionSettings() {
        return this.createReadSessionSettings;
    }

    public ServerStreamingCallSettings<ReadRowsRequest, ReadRowsResponse> readRowsSettings() {
        return this.readRowsSettings;
    }

    public UnaryCallSettings<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamSettings() {
        return this.splitReadStreamSettings;
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return BigQueryReadStubSettings.defaultExecutorProviderBuilder();
    }

    public static String getDefaultEndpoint() {
        return BigQueryReadStubSettings.getDefaultEndpoint();
    }

    public static List<String> getDefaultServiceScopes() {
        return BigQueryReadStubSettings.getDefaultServiceScopes();
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return BaseBigQueryReadSettings.defaultCredentialsProviderBuilder();
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return BigQueryReadStubSettings.defaultGrpcTransportProviderBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EnhancedBigQueryReadStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return BigQueryReadStubSettings.defaultApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EnhancedBigQueryReadStubSettings(Builder settingsBuilder) {
        super((StubSettings.Builder)settingsBuilder);
        this.createReadSessionSettings = settingsBuilder.createReadSessionSettings().build();
        this.readRowsSettings = settingsBuilder.readRowsSettings().build();
        this.splitReadStreamSettings = settingsBuilder.splitReadStreamSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EnhancedBigQueryReadStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateReadSessionRequest, ReadSession> createReadSessionSettings;
        private final ServerStreamingCallSettings.Builder<ReadRowsRequest, ReadRowsResponse> readRowsSettings;
        private final UnaryCallSettings.Builder<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamSettings;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            BigQueryReadStubSettings.Builder baseDefaults = BigQueryReadStubSettings.newBuilder();
            this.setEndpoint(baseDefaults.getEndpoint());
            this.setTransportChannelProvider(EnhancedBigQueryReadStubSettings.defaultTransportChannelProvider());
            this.setCredentialsProvider(baseDefaults.getCredentialsProvider());
            this.setStreamWatchdogCheckInterval(baseDefaults.getStreamWatchdogCheckInterval());
            this.setStreamWatchdogProvider(baseDefaults.getStreamWatchdogProvider());
            this.createReadSessionSettings = baseDefaults.createReadSessionSettings();
            this.splitReadStreamSettings = baseDefaults.splitReadStreamSettings();
            this.readRowsSettings = baseDefaults.readRowsSettings().setResumptionStrategy((StreamResumptionStrategy)new ReadRowsResumptionStrategy());
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createReadSessionSettings, this.splitReadStreamSettings);
        }

        protected Builder(EnhancedBigQueryReadStubSettings settings) {
            super((StubSettings)settings);
            this.createReadSessionSettings = settings.createReadSessionSettings.toBuilder();
            this.readRowsSettings = settings.readRowsSettings.toBuilder();
            this.splitReadStreamSettings = settings.splitReadStreamSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createReadSessionSettings, this.splitReadStreamSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateReadSessionRequest, ReadSession> createReadSessionSettings() {
            return this.createReadSessionSettings;
        }

        public ServerStreamingCallSettings.Builder<ReadRowsRequest, ReadRowsResponse> readRowsSettings() {
            return this.readRowsSettings;
        }

        public UnaryCallSettings.Builder<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamSettings() {
            return this.splitReadStreamSettings;
        }

        public EnhancedBigQueryReadStubSettings build() {
            return new EnhancedBigQueryReadStubSettings(this);
        }
    }
}

