/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.CommitStats;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ClientSideStatementExplainExecutor;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionStatementExecutor;
import com.google.cloud.spanner.connection.DialectNamespaceMapper;
import com.google.cloud.spanner.connection.PgTransactionMode;
import com.google.cloud.spanner.connection.ReadOnlyStalenessUtil;
import com.google.cloud.spanner.connection.SavepointSupport;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.cloud.spanner.connection.StatementResultImpl;
import com.google.cloud.spanner.connection.TransactionMode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Duration;
import com.google.protobuf.Value;
import com.google.spanner.v1.PlanNode;
import com.google.spanner.v1.QueryPlan;
import com.google.spanner.v1.RequestOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

class ConnectionStatementExecutorImpl
implements ConnectionStatementExecutor {
    private static final Map<RequestOptions.Priority, Options.RpcPriority> validRPCPriorityValues;
    private final ConnectionImpl connection;

    ConnectionStatementExecutorImpl(ConnectionImpl connection) {
        this.connection = connection;
    }

    ConnectionImpl getConnection() {
        return this.connection;
    }

    @Override
    public StatementResult statementSetAutocommit(Boolean autocommit) {
        Preconditions.checkNotNull((Object)autocommit);
        this.getConnection().setAutocommit(autocommit);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_AUTOCOMMIT);
    }

    @Override
    public StatementResult statementShowAutocommit() {
        return StatementResultImpl.resultSet("AUTOCOMMIT", this.getConnection().isAutocommit(), StatementResult.ClientSideStatementType.SHOW_AUTOCOMMIT);
    }

    @Override
    public StatementResult statementSetReadOnly(Boolean readOnly) {
        Preconditions.checkNotNull((Object)readOnly);
        this.getConnection().setReadOnly(readOnly);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_READONLY);
    }

    @Override
    public StatementResult statementShowReadOnly() {
        return StatementResultImpl.resultSet(String.format("%sREADONLY", DialectNamespaceMapper.getNamespace(this.connection.getDialect())), this.getConnection().isReadOnly(), StatementResult.ClientSideStatementType.SHOW_READONLY);
    }

    @Override
    public StatementResult statementSetRetryAbortsInternally(Boolean retryAbortsInternally) {
        Preconditions.checkNotNull((Object)retryAbortsInternally);
        this.getConnection().setRetryAbortsInternally(retryAbortsInternally);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_RETRY_ABORTS_INTERNALLY);
    }

    @Override
    public StatementResult statementShowRetryAbortsInternally() {
        return StatementResultImpl.resultSet(String.format("%sRETRY_ABORTS_INTERNALLY", DialectNamespaceMapper.getNamespace(this.connection.getDialect())), this.getConnection().isRetryAbortsInternally(), StatementResult.ClientSideStatementType.SHOW_RETRY_ABORTS_INTERNALLY);
    }

    @Override
    public StatementResult statementSetAutocommitDmlMode(AutocommitDmlMode mode) {
        this.getConnection().setAutocommitDmlMode(mode);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_AUTOCOMMIT_DML_MODE);
    }

    @Override
    public StatementResult statementShowAutocommitDmlMode() {
        return StatementResultImpl.resultSet(String.format("%sAUTOCOMMIT_DML_MODE", DialectNamespaceMapper.getNamespace(this.connection.getDialect())), this.getConnection().getAutocommitDmlMode(), StatementResult.ClientSideStatementType.SHOW_AUTOCOMMIT_DML_MODE);
    }

    @Override
    public StatementResult statementSetStatementTimeout(Duration duration) {
        if (duration.getSeconds() == 0L && duration.getNanos() == 0) {
            this.getConnection().clearStatementTimeout();
        } else {
            TimeUnit unit = ReadOnlyStalenessUtil.getAppropriateTimeUnit(new ReadOnlyStalenessUtil.DurationGetter(duration));
            this.getConnection().setStatementTimeout(ReadOnlyStalenessUtil.durationToUnits(duration, unit), unit);
        }
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_STATEMENT_TIMEOUT);
    }

    @Override
    public StatementResult statementShowStatementTimeout() {
        return StatementResultImpl.resultSet("STATEMENT_TIMEOUT", this.getConnection().hasStatementTimeout() ? ReadOnlyStalenessUtil.durationToString(new StatementTimeoutGetter(this.getConnection())) : (this.connection.getDialect() == Dialect.POSTGRESQL ? "0" : null), StatementResult.ClientSideStatementType.SHOW_STATEMENT_TIMEOUT);
    }

    @Override
    public StatementResult statementShowReadTimestamp() {
        return StatementResultImpl.resultSet(String.format("%sREAD_TIMESTAMP", DialectNamespaceMapper.getNamespace(this.connection.getDialect())), this.getConnection().getReadTimestampOrNull(), StatementResult.ClientSideStatementType.SHOW_READ_TIMESTAMP);
    }

    @Override
    public StatementResult statementShowCommitTimestamp() {
        return StatementResultImpl.resultSet(String.format("%sCOMMIT_TIMESTAMP", DialectNamespaceMapper.getNamespace(this.connection.getDialect())), this.getConnection().getCommitTimestampOrNull(), StatementResult.ClientSideStatementType.SHOW_COMMIT_TIMESTAMP);
    }

    @Override
    public StatementResult statementShowCommitResponse() {
        CommitResponse response = this.getConnection().getCommitResponseOrNull();
        CommitStats stats = null;
        if (response != null && response.hasCommitStats()) {
            stats = response.getCommitStats();
        }
        ResultSet resultSet = ResultSets.forRows(Type.struct(Type.StructField.of(String.format("%sCOMMIT_TIMESTAMP", DialectNamespaceMapper.getNamespace(this.connection.getDialect())), Type.timestamp()), Type.StructField.of(String.format("%sMUTATION_COUNT", DialectNamespaceMapper.getNamespace(this.connection.getDialect())), Type.int64())), Collections.singletonList(Struct.newBuilder().set(String.format("%sCOMMIT_TIMESTAMP", DialectNamespaceMapper.getNamespace(this.connection.getDialect()))).to(response == null ? null : response.getCommitTimestamp()).set(String.format("%sMUTATION_COUNT", DialectNamespaceMapper.getNamespace(this.connection.getDialect()))).to(stats == null ? null : Long.valueOf(stats.getMutationCount())).build()));
        return StatementResultImpl.of(resultSet, StatementResult.ClientSideStatementType.SHOW_COMMIT_RESPONSE);
    }

    @Override
    public StatementResult statementSetReadOnlyStaleness(TimestampBound staleness) {
        this.getConnection().setReadOnlyStaleness(staleness);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_READ_ONLY_STALENESS);
    }

    @Override
    public StatementResult statementShowReadOnlyStaleness() {
        TimestampBound staleness = this.getConnection().getReadOnlyStaleness();
        return StatementResultImpl.resultSet(String.format("%sREAD_ONLY_STALENESS", DialectNamespaceMapper.getNamespace(this.connection.getDialect())), ReadOnlyStalenessUtil.timestampBoundToString(staleness), StatementResult.ClientSideStatementType.SHOW_READ_ONLY_STALENESS);
    }

    @Override
    public StatementResult statementSetOptimizerVersion(String optimizerVersion) {
        this.getConnection().setOptimizerVersion(optimizerVersion);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_OPTIMIZER_VERSION);
    }

    @Override
    public StatementResult statementShowOptimizerVersion() {
        return StatementResultImpl.resultSet(String.format("%sOPTIMIZER_VERSION", DialectNamespaceMapper.getNamespace(this.connection.getDialect())), this.getConnection().getOptimizerVersion(), StatementResult.ClientSideStatementType.SHOW_OPTIMIZER_VERSION);
    }

    @Override
    public StatementResult statementSetOptimizerStatisticsPackage(String optimizerStatisticsPackage) {
        this.getConnection().setOptimizerStatisticsPackage(optimizerStatisticsPackage);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_OPTIMIZER_STATISTICS_PACKAGE);
    }

    @Override
    public StatementResult statementShowOptimizerStatisticsPackage() {
        return StatementResultImpl.resultSet(String.format("%sOPTIMIZER_STATISTICS_PACKAGE", DialectNamespaceMapper.getNamespace(this.connection.getDialect())), this.getConnection().getOptimizerStatisticsPackage(), StatementResult.ClientSideStatementType.SHOW_OPTIMIZER_STATISTICS_PACKAGE);
    }

    @Override
    public StatementResult statementSetReturnCommitStats(Boolean returnCommitStats) {
        this.getConnection().setReturnCommitStats(returnCommitStats);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_RETURN_COMMIT_STATS);
    }

    @Override
    public StatementResult statementShowReturnCommitStats() {
        return StatementResultImpl.resultSet(String.format("%sRETURN_COMMIT_STATS", DialectNamespaceMapper.getNamespace(this.connection.getDialect())), this.getConnection().isReturnCommitStats(), StatementResult.ClientSideStatementType.SHOW_RETURN_COMMIT_STATS);
    }

    @Override
    public StatementResult statementSetStatementTag(String tag) {
        this.getConnection().setStatementTag("".equals(tag) ? null : tag);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_STATEMENT_TAG);
    }

    @Override
    public StatementResult statementShowStatementTag() {
        return StatementResultImpl.resultSet(String.format("%sSTATEMENT_TAG", DialectNamespaceMapper.getNamespace(this.connection.getDialect())), (String)MoreObjects.firstNonNull((Object)this.getConnection().getStatementTag(), (Object)""), StatementResult.ClientSideStatementType.SHOW_STATEMENT_TAG);
    }

    @Override
    public StatementResult statementSetTransactionTag(String tag) {
        this.getConnection().setTransactionTag("".equals(tag) ? null : tag);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_TRANSACTION_TAG);
    }

    @Override
    public StatementResult statementShowTransactionTag() {
        return StatementResultImpl.resultSet(String.format("%sTRANSACTION_TAG", DialectNamespaceMapper.getNamespace(this.connection.getDialect())), (String)MoreObjects.firstNonNull((Object)this.getConnection().getTransactionTag(), (Object)""), StatementResult.ClientSideStatementType.SHOW_TRANSACTION_TAG);
    }

    @Override
    public StatementResult statementBeginTransaction() {
        this.getConnection().beginTransaction();
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.BEGIN);
    }

    @Override
    public StatementResult statementBeginPgTransaction(@Nullable PgTransactionMode transactionMode) {
        this.getConnection().beginTransaction();
        if (transactionMode != null) {
            this.statementSetPgTransactionMode(transactionMode);
        }
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.BEGIN);
    }

    @Override
    public StatementResult statementCommit() {
        this.getConnection().commit();
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.COMMIT);
    }

    @Override
    public StatementResult statementRollback() {
        this.getConnection().rollback();
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.ROLLBACK);
    }

    @Override
    public StatementResult statementSetTransactionMode(TransactionMode mode) {
        this.getConnection().setTransactionMode(mode);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_TRANSACTION_MODE);
    }

    @Override
    public StatementResult statementSetPgTransactionMode(PgTransactionMode transactionMode) {
        if (transactionMode.getAccessMode() != null) {
            switch (transactionMode.getAccessMode()) {
                case READ_ONLY_TRANSACTION: {
                    this.getConnection().setTransactionMode(TransactionMode.READ_ONLY_TRANSACTION);
                    break;
                }
                case READ_WRITE_TRANSACTION: {
                    this.getConnection().setTransactionMode(TransactionMode.READ_WRITE_TRANSACTION);
                    break;
                }
            }
        }
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_TRANSACTION_MODE);
    }

    @Override
    public StatementResult statementSetPgSessionCharacteristicsTransactionMode(PgTransactionMode transactionMode) {
        if (transactionMode.getAccessMode() != null) {
            switch (transactionMode.getAccessMode()) {
                case READ_ONLY_TRANSACTION: {
                    this.getConnection().setReadOnly(true);
                    break;
                }
                case READ_WRITE_TRANSACTION: {
                    this.getConnection().setReadOnly(false);
                    break;
                }
            }
        }
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_TRANSACTION_MODE);
    }

    @Override
    public StatementResult statementSetPgDefaultTransactionIsolation(PgTransactionMode.IsolationLevel isolationLevel) {
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_DEFAULT_TRANSACTION_ISOLATION);
    }

    @Override
    public StatementResult statementStartBatchDdl() {
        this.getConnection().startBatchDdl();
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.START_BATCH_DDL);
    }

    @Override
    public StatementResult statementStartBatchDml() {
        this.getConnection().startBatchDml();
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.START_BATCH_DML);
    }

    @Override
    public StatementResult statementRunBatch() {
        long[] updateCounts = this.getConnection().runBatch();
        return StatementResultImpl.resultSet("UPDATE_COUNTS", updateCounts, StatementResult.ClientSideStatementType.RUN_BATCH);
    }

    @Override
    public StatementResult statementAbortBatch() {
        this.getConnection().abortBatch();
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.ABORT_BATCH);
    }

    @Override
    public StatementResult statementSetRPCPriority(RequestOptions.Priority priority) {
        Options.RpcPriority value = validRPCPriorityValues.get(priority);
        this.getConnection().setRPCPriority(value);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_RPC_PRIORITY);
    }

    @Override
    public StatementResult statementShowRPCPriority() {
        return StatementResultImpl.resultSet(String.format("%sRPC_PRIORITY", DialectNamespaceMapper.getNamespace(this.connection.getDialect())), this.getConnection().getRPCPriority() == null ? RequestOptions.Priority.PRIORITY_UNSPECIFIED : this.getConnection().getRPCPriority(), StatementResult.ClientSideStatementType.SHOW_RPC_PRIORITY);
    }

    @Override
    public StatementResult statementSetSavepointSupport(SavepointSupport savepointSupport) {
        this.getConnection().setSavepointSupport(savepointSupport);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_SAVEPOINT_SUPPORT);
    }

    @Override
    public StatementResult statementShowSavepointSupport() {
        return StatementResultImpl.resultSet(String.format("%SAVEPOINT_SUPPORT", DialectNamespaceMapper.getNamespace(this.connection.getDialect())), this.getConnection().getSavepointSupport(), StatementResult.ClientSideStatementType.SHOW_SAVEPOINT_SUPPORT);
    }

    @Override
    public StatementResult statementShowTransactionIsolationLevel() {
        return StatementResultImpl.resultSet("transaction_isolation", "serializable", StatementResult.ClientSideStatementType.SHOW_TRANSACTION_ISOLATION_LEVEL);
    }

    private String processQueryPlan(PlanNode planNode) {
        StringBuilder planNodeDescription = new StringBuilder(" : { ");
        com.google.protobuf.Struct metadata = planNode.getMetadata();
        for (String key : metadata.getFieldsMap().keySet()) {
            planNodeDescription.append(key).append(" : ").append(((Value)metadata.getFieldsMap().get(key)).getStringValue()).append(" , ");
        }
        String substring = planNodeDescription.substring(0, planNodeDescription.length() - 3);
        planNodeDescription.setLength(0);
        planNodeDescription.append(substring).append(" }");
        return planNodeDescription.toString();
    }

    private String processExecutionStats(PlanNode planNode) {
        StringBuilder executionStats = new StringBuilder("");
        for (String key : planNode.getExecutionStats().getFieldsMap().keySet()) {
            executionStats.append(key).append(" : { ");
            com.google.protobuf.Struct value = ((Value)planNode.getExecutionStats().getFieldsMap().get(key)).getStructValue();
            for (String newKey : value.getFieldsMap().keySet()) {
                String newValue = ((Value)value.getFieldsMap().get(newKey)).getStringValue();
                executionStats.append(newKey).append(" : ").append(newValue).append(" , ");
            }
            String substring = executionStats.substring(0, executionStats.length() - 3);
            executionStats.setLength(0);
            executionStats.append(substring).append(" } , ");
        }
        String substring = executionStats.substring(0, executionStats.length() - 3);
        executionStats.setLength(0);
        executionStats.append(substring);
        return executionStats.toString();
    }

    private StatementResult getStatementResultFromQueryPlan(QueryPlan queryPlan, boolean isAnalyze) {
        ArrayList<Struct> list = new ArrayList<Struct>();
        for (PlanNode planNode : queryPlan.getPlanNodesList()) {
            String planNodeDescription = planNode.getDisplayName();
            String executionStats = "";
            if (!planNode.getMetadata().toString().equalsIgnoreCase("")) {
                planNodeDescription = planNodeDescription + this.processQueryPlan(planNode);
            }
            if (!planNode.getShortRepresentation().toString().equalsIgnoreCase("")) {
                planNodeDescription = planNodeDescription + " : " + planNode.getShortRepresentation().getDescription();
            }
            if (isAnalyze && !planNode.getExecutionStats().toString().equals("")) {
                executionStats = this.processExecutionStats(planNode);
            }
            Struct.Builder builder = Struct.newBuilder().set("QUERY PLAN").to(planNodeDescription);
            if (isAnalyze) {
                builder.set("EXECUTION STATS").to(executionStats);
            }
            list.add(builder.build());
        }
        ResultSet resultSet = isAnalyze ? ResultSets.forRows(Type.struct(Type.StructField.of("QUERY PLAN", Type.string()), Type.StructField.of("EXECUTION STATS", Type.string())), list) : ResultSets.forRows(Type.struct(Type.StructField.of("QUERY PLAN", Type.string())), list);
        return StatementResultImpl.of(resultSet);
    }

    private StatementResult executeStatement(String sql, ReadContext.QueryAnalyzeMode queryAnalyzeMode) {
        Statement statement = Statement.newBuilder(sql).build();
        try (ResultSet resultSet = this.getConnection().analyzeQuery(statement, queryAnalyzeMode);){
            while (resultSet.next()) {
            }
            if (resultSet.getStats() != null && resultSet.getStats().getQueryPlan() != null) {
                StatementResult statementResult = this.getStatementResultFromQueryPlan(resultSet.getStats().getQueryPlan(), queryAnalyzeMode.equals((Object)ReadContext.QueryAnalyzeMode.PROFILE));
                return statementResult;
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, String.format("Couldn't fetch stats for %s", sql));
    }

    private String removeParenthesisAndTrim(String sql) {
        if ((sql = sql.trim()).charAt(0) == '(') {
            sql = sql.substring(1, sql.length() - 1);
        }
        return sql.trim();
    }

    @Override
    public StatementResult statementExplain(String sql) {
        if (sql == null) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("Invalid String with Explain", new Object[0]));
        }
        if (sql.charAt(0) == '(') {
            String newSql;
            int index = sql.indexOf(41);
            if (index == -1) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("Missing closing parenthesis in the query: %s", sql));
            }
            String[] options = sql.substring(1, index).split("\\s*,\\s*");
            boolean isAnalyze = false;
            boolean startAfterIndex = false;
            for (String option : options) {
                String[] optionExpression = option.trim().split("\\s+");
                if (optionExpression.length >= 3) {
                    isAnalyze = false;
                    break;
                }
                if (ClientSideStatementExplainExecutor.EXPLAIN_OPTIONS.contains(optionExpression[0].toLowerCase())) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.UNIMPLEMENTED, String.format("%s is not implemented yet", optionExpression[0]));
                }
                if (!optionExpression[0].equalsIgnoreCase("analyse") && !optionExpression[0].equalsIgnoreCase("analyze")) {
                    isAnalyze = false;
                    break;
                }
                isAnalyze = true;
                if (optionExpression.length != 2) continue;
                if (optionExpression[1].equalsIgnoreCase("false") || optionExpression[1].equalsIgnoreCase("0") || optionExpression[1].equalsIgnoreCase("off")) {
                    isAnalyze = false;
                    startAfterIndex = true;
                    continue;
                }
                if (optionExpression[1].equalsIgnoreCase("true") || optionExpression[1].equalsIgnoreCase("1") || optionExpression[1].equalsIgnoreCase("on")) continue;
                isAnalyze = false;
                break;
            }
            if (isAnalyze) {
                newSql = this.removeParenthesisAndTrim(sql.substring(index + 1));
                return this.executeStatement(newSql, ReadContext.QueryAnalyzeMode.PROFILE);
            }
            if (startAfterIndex) {
                newSql = this.removeParenthesisAndTrim(sql.substring(index + 1));
                return this.executeStatement(newSql, ReadContext.QueryAnalyzeMode.PLAN);
            }
            return this.executeStatement(this.removeParenthesisAndTrim(sql), ReadContext.QueryAnalyzeMode.PLAN);
        }
        String[] arr = sql.split("\\s+", 2);
        if (arr.length >= 2) {
            String option = arr[0].toLowerCase();
            String statementToBeExplained = arr[1];
            if (ClientSideStatementExplainExecutor.EXPLAIN_OPTIONS.contains(option)) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.UNIMPLEMENTED, String.format("%s is not implemented yet", option));
            }
            if (option.equals("analyze") || option.equals("analyse")) {
                return this.executeStatement(this.removeParenthesisAndTrim(statementToBeExplained), ReadContext.QueryAnalyzeMode.PROFILE);
            }
        }
        return this.executeStatement(sql, ReadContext.QueryAnalyzeMode.PLAN);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)Options.RpcPriority.HIGH);
        builder.put((Object)RequestOptions.Priority.PRIORITY_MEDIUM, (Object)Options.RpcPriority.MEDIUM);
        builder.put((Object)RequestOptions.Priority.PRIORITY_LOW, (Object)Options.RpcPriority.LOW);
        validRPCPriorityValues = builder.build();
    }

    static final class StatementTimeoutGetter
    implements ReadOnlyStalenessUtil.DurationValueGetter {
        private final Connection connection;

        public StatementTimeoutGetter(Connection connection) {
            this.connection = connection;
        }

        @Override
        public long getDuration(TimeUnit unit) {
            return this.connection.getStatementTimeout(unit);
        }

        @Override
        public boolean hasDuration() {
            return this.connection.hasStatementTimeout();
        }
    }
}

