/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventhubs.AzureActiveDirectoryTokenProvider;
import com.microsoft.azure.eventhubs.ConnectionStringBuilder;
import com.microsoft.azure.eventhubs.EventHubClientOptions;
import com.microsoft.azure.eventhubs.ITokenProvider;
import com.microsoft.azure.eventhubs.RetryPolicy;
import com.microsoft.azure.eventhubs.TransportType;
import com.microsoft.azure.eventhubs.impl.StringUtil;
import com.microsoft.azure.eventprocessorhost.AzureStorageCheckpointLeaseManager;
import com.microsoft.azure.eventprocessorhost.AzureStoragePartitionManagerOptions;
import com.microsoft.azure.eventprocessorhost.DefaultEventProcessorFactory;
import com.microsoft.azure.eventprocessorhost.EventHubClientFactory;
import com.microsoft.azure.eventprocessorhost.EventProcessorOptions;
import com.microsoft.azure.eventprocessorhost.HostContext;
import com.microsoft.azure.eventprocessorhost.ICheckpointManager;
import com.microsoft.azure.eventprocessorhost.IEventProcessor;
import com.microsoft.azure.eventprocessorhost.IEventProcessorFactory;
import com.microsoft.azure.eventprocessorhost.ILeaseManager;
import com.microsoft.azure.eventprocessorhost.PartitionManager;
import com.microsoft.azure.eventprocessorhost.PartitionManagerOptions;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.time.Duration;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventProcessorHost {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(EventProcessorHost.class);
    private static final Object UUID_SYNCHRONIZER = new Object();
    private final boolean weOwnExecutor;
    private final ScheduledExecutorService executorService;
    private final int executorServicePoolSize = 16;
    private final HostContext hostContext;
    private boolean initializeLeaseManager = false;
    private volatile CompletableFuture<Void> unregistered = null;
    private PartitionManager partitionManager;
    private PartitionManagerOptions partitionManagerOptions = null;

    private EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, EventHubClientFactory eventHubClientFactory, ICheckpointManager checkpointManager, ILeaseManager leaseManager, boolean initializeLeaseManager, ScheduledExecutorService executorService) {
        this.initializeLeaseManager = initializeLeaseManager;
        this.partitionManagerOptions = this.initializeLeaseManager ? new AzureStoragePartitionManagerOptions() : new PartitionManagerOptions();
        if (executorService != null) {
            this.weOwnExecutor = false;
            this.executorService = executorService;
        } else {
            this.weOwnExecutor = true;
            this.executorService = Executors.newScheduledThreadPool(this.executorServicePoolSize, new EventProcessorHostThreadPoolFactory(hostName, eventHubPath, consumerGroupName));
        }
        eventHubClientFactory.setExecutor(this.executorService);
        this.hostContext = new HostContext(this.executorService, this, hostName, eventHubPath, consumerGroupName, eventHubClientFactory, leaseManager, checkpointManager);
        this.partitionManager = new PartitionManager(this.hostContext);
        TRACE_LOGGER.info(this.hostContext.withHost("New EventProcessorHost created."));
    }

    public static String createHostName(String prefix) {
        String usePrefix = prefix;
        if (usePrefix == null || usePrefix.isEmpty()) {
            usePrefix = "javahost";
        }
        return usePrefix + "-" + EventProcessorHost.safeCreateUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String safeCreateUUID() {
        Object object = UUID_SYNCHRONIZER;
        synchronized (object) {
            UUID newUuid = UUID.randomUUID();
            return newUuid.toString();
        }
    }

    public String getHostName() {
        return this.hostContext.getHostName();
    }

    void setPartitionManager(PartitionManager pm) {
        this.partitionManager = pm;
    }

    HostContext getHostContext() {
        return this.hostContext;
    }

    public PartitionManagerOptions getPartitionManagerOptions() {
        return this.partitionManagerOptions;
    }

    public void setPartitionManagerOptions(PartitionManagerOptions options) {
        this.partitionManagerOptions = options;
    }

    public <T extends IEventProcessor> CompletableFuture<Void> registerEventProcessor(Class<T> eventProcessorType) {
        DefaultEventProcessorFactory<T> defaultFactory = new DefaultEventProcessorFactory<T>();
        defaultFactory.setEventProcessorClass(eventProcessorType);
        return this.registerEventProcessorFactory(defaultFactory, EventProcessorOptions.getDefaultOptions());
    }

    public <T extends IEventProcessor> CompletableFuture<Void> registerEventProcessor(Class<T> eventProcessorType, EventProcessorOptions processorOptions) {
        DefaultEventProcessorFactory<T> defaultFactory = new DefaultEventProcessorFactory<T>();
        defaultFactory.setEventProcessorClass(eventProcessorType);
        return this.registerEventProcessorFactory(defaultFactory, processorOptions);
    }

    public CompletableFuture<Void> registerEventProcessorFactory(IEventProcessorFactory<?> factory) {
        return this.registerEventProcessorFactory(factory, EventProcessorOptions.getDefaultOptions());
    }

    public CompletableFuture<Void> registerEventProcessorFactory(IEventProcessorFactory<?> factory, EventProcessorOptions processorOptions) {
        if (this.unregistered != null) {
            throw new IllegalStateException("Register cannot be called on an EventProcessorHost after unregister. Please create a new EventProcessorHost instance.");
        }
        if (this.hostContext.getEventProcessorFactory() != null) {
            throw new IllegalStateException("Register has already been called on this EventProcessorHost");
        }
        this.hostContext.setEventProcessorFactory(factory);
        this.hostContext.setEventProcessorOptions(processorOptions);
        if (this.executorService.isShutdown() || this.executorService.isTerminated()) {
            TRACE_LOGGER.warn(this.hostContext.withHost("Calling registerEventProcessor/Factory after executor service has been shut down."));
            throw new RejectedExecutionException("EventProcessorHost executor service has been shut down");
        }
        if (this.initializeLeaseManager) {
            try {
                ((AzureStorageCheckpointLeaseManager)this.hostContext.getLeaseManager()).initialize(this.hostContext);
            }
            catch (StorageException | URISyntaxException | InvalidKeyException e) {
                TRACE_LOGGER.error(this.hostContext.withHost("Failure initializing default lease and checkpoint manager."));
                throw new RuntimeException("Failure initializing Storage lease manager", e);
            }
        }
        TRACE_LOGGER.info(this.hostContext.withHost("Starting event processing."));
        return this.partitionManager.initialize();
    }

    public CompletableFuture<Void> unregisterEventProcessor() {
        TRACE_LOGGER.info(this.hostContext.withHost("Stopping event processing"));
        if (this.unregistered == null) {
            this.unregistered = this.partitionManager.stopPartitions();
            if (this.weOwnExecutor) {
                this.unregistered = this.unregistered.thenRunAsync(() -> {
                    this.executorService.shutdown();
                    try {
                        this.executorService.awaitTermination(10L, TimeUnit.MINUTES);
                    }
                    catch (InterruptedException e) {
                        throw new CompletionException(e);
                    }
                }, ForkJoinPool.commonPool());
            }
        }
        return this.unregistered;
    }

    public static final class EventProcessorHostBuilder {
        public static ManagerStep newBuilder(String hostName, String consumerGroupName) {
            return new Steps(hostName, consumerGroupName);
        }

        private EventProcessorHostBuilder() {
        }

        private static class Steps
        implements ManagerStep,
        AuthStep,
        AADAuthStep,
        OptionalStep {
            private final String hostName;
            private final String consumerGroupName;
            private ScheduledExecutorService executor = null;
            private RetryPolicy retryPolicy = null;
            private TransportType transportType = null;
            private Duration operationTimeout = null;
            private String eventHubConnectionString = null;
            private String eventHubPath = null;
            private URI endpoint = null;
            private AzureActiveDirectoryTokenProvider.AuthenticationCallback authCallback = null;
            private String authority = null;
            private ITokenProvider tokenProvider = null;
            private ICheckpointManager checkpointManager;
            private ILeaseManager leaseManager;
            private boolean initializeManagers = false;

            Steps(String hostName, String consumerGroupName) {
                if (StringUtil.isNullOrWhiteSpace((String)hostName) || StringUtil.isNullOrWhiteSpace((String)consumerGroupName)) {
                    throw new IllegalArgumentException("hostName and consumerGroupName cannot be null or empty");
                }
                this.hostName = hostName;
                this.consumerGroupName = consumerGroupName;
            }

            @Override
            public OptionalStep setExecutor(ScheduledExecutorService executor) {
                this.executor = executor;
                return this;
            }

            @Override
            public OptionalStep setRetryPolicy(RetryPolicy retryPolicy) {
                this.retryPolicy = retryPolicy;
                return this;
            }

            @Override
            public OptionalStep setTransportType(TransportType transportType) {
                Objects.requireNonNull(transportType, "'transportType' cannot be null.");
                this.transportType = transportType;
                return this;
            }

            @Override
            public OptionalStep setOperationTimeout(Duration operationTimeout) {
                Objects.requireNonNull(operationTimeout, "'operationTimeout' cannot be null.");
                this.operationTimeout = operationTimeout;
                return this;
            }

            @Override
            public OptionalStep useAuthenticationCallback(AzureActiveDirectoryTokenProvider.AuthenticationCallback authCallback, String authority) {
                Objects.requireNonNull(authCallback, "'authCallback' cannot be null.");
                if (StringUtil.isNullOrWhiteSpace((String)authority)) {
                    throw new IllegalArgumentException("authority cannot be null or empty");
                }
                this.authCallback = authCallback;
                this.authority = authority;
                return this;
            }

            @Override
            public OptionalStep useTokenProvider(ITokenProvider tokenProvider) {
                Objects.requireNonNull(tokenProvider, "'tokenProvider' cannot be null.");
                this.tokenProvider = tokenProvider;
                return this;
            }

            @Override
            public OptionalStep useEventHubConnectionString(String eventHubConnectionString) {
                return this.useEventHubConnectionString(eventHubConnectionString, null);
            }

            @Override
            public OptionalStep useEventHubConnectionString(String eventHubConnectionString, String eventHubPath) {
                if (StringUtil.isNullOrWhiteSpace((String)eventHubConnectionString)) {
                    throw new IllegalArgumentException("eventHubConnectionString cannot be null or empty");
                }
                if (eventHubPath != null && StringUtil.isNullOrWhiteSpace((String)eventHubPath)) {
                    throw new IllegalArgumentException("eventHubPath cannot be empty. Use null if the connection string already contains the path.");
                }
                this.eventHubConnectionString = eventHubConnectionString;
                this.eventHubPath = eventHubPath;
                return this;
            }

            @Override
            public AADAuthStep useAADAuthentication(URI endpoint, String eventHubPath) {
                Objects.requireNonNull(endpoint, "'endpoint' cannot be null.");
                if (StringUtil.isNullOrWhiteSpace((String)eventHubPath)) {
                    throw new IllegalArgumentException("eventHubPath cannot be null or empty");
                }
                this.endpoint = endpoint;
                this.eventHubPath = eventHubPath;
                return this;
            }

            @Override
            public AuthStep useAzureStorageCheckpointLeaseManager(String storageConnectionString, String storageContainerName, String storageBlobPrefix) {
                AzureStorageCheckpointLeaseManager mgr = new AzureStorageCheckpointLeaseManager(storageConnectionString, storageContainerName, storageBlobPrefix);
                this.initializeManagers = true;
                return this.useUserCheckpointAndLeaseManagers(mgr, mgr);
            }

            @Override
            public AuthStep useAzureStorageCheckpointLeaseManager(StorageCredentials storageCredentials, String storageContainerName, String storageBlobPrefix) {
                AzureStorageCheckpointLeaseManager mgr = new AzureStorageCheckpointLeaseManager(storageCredentials, storageContainerName, storageBlobPrefix);
                this.initializeManagers = true;
                return this.useUserCheckpointAndLeaseManagers(mgr, mgr);
            }

            @Override
            public AuthStep useUserCheckpointAndLeaseManagers(ICheckpointManager checkpointManager, ILeaseManager leaseManager) {
                Objects.requireNonNull(checkpointManager, "'checkpointManager' cannot be null.");
                Objects.requireNonNull(leaseManager, "'leaseManager' cannot be null.");
                this.checkpointManager = checkpointManager;
                this.leaseManager = leaseManager;
                return this;
            }

            @Override
            public EventProcessorHost build() {
                EventHubClientFactory ehcFactory = null;
                if (this.eventHubConnectionString != null) {
                    this.normalizeConnectionStringAndEventHubPath();
                    ehcFactory = new EventHubClientFactory.EHCFWithConnectionString(this.eventHubConnectionString, this.retryPolicy);
                } else if (this.authCallback != null) {
                    ehcFactory = new EventHubClientFactory.EHCFWithAuthCallback(this.endpoint, this.eventHubPath, this.authCallback, this.authority, this.packOptions());
                } else if (this.tokenProvider != null) {
                    ehcFactory = new EventHubClientFactory.EHCFWithTokenProvider(this.endpoint, this.eventHubPath, this.tokenProvider, this.packOptions());
                }
                return new EventProcessorHost(this.hostName, this.eventHubPath, this.consumerGroupName, ehcFactory, this.checkpointManager, this.leaseManager, this.initializeManagers, this.executor);
            }

            private EventHubClientOptions packOptions() {
                return new EventHubClientOptions().setOperationTimeout(this.operationTimeout).setRetryPolicy(this.retryPolicy).setTransportType(this.transportType);
            }

            private void normalizeConnectionStringAndEventHubPath() {
                ConnectionStringBuilder csb = new ConnectionStringBuilder(this.eventHubConnectionString);
                String extractedEntityPath = csb.getEventHubName();
                if (this.eventHubPath != null && !this.eventHubPath.isEmpty()) {
                    if (extractedEntityPath != null) {
                        if (this.eventHubPath.compareTo(extractedEntityPath) != 0) {
                            throw new IllegalArgumentException("Provided EventHub path in eventHubPath parameter conflicts with the path in provided EventHub connection string");
                        }
                    } else {
                        csb.setEventHubName(this.eventHubPath);
                    }
                } else if (extractedEntityPath != null && !extractedEntityPath.isEmpty()) {
                    this.eventHubPath = extractedEntityPath;
                } else {
                    throw new IllegalArgumentException("Provide EventHub entity path in either eventHubPath argument or in eventHubConnectionString");
                }
                if (this.transportType != null) {
                    csb.setTransportType(this.transportType);
                }
                if (this.operationTimeout != null) {
                    csb.setOperationTimeout(this.operationTimeout);
                }
                this.eventHubConnectionString = csb.toString();
            }
        }

        public static interface OptionalStep {
            public OptionalStep setExecutor(ScheduledExecutorService var1);

            public OptionalStep setRetryPolicy(RetryPolicy var1);

            public OptionalStep setTransportType(TransportType var1);

            public OptionalStep setOperationTimeout(Duration var1);

            public EventProcessorHost build();
        }

        public static interface AADAuthStep {
            public OptionalStep useAuthenticationCallback(AzureActiveDirectoryTokenProvider.AuthenticationCallback var1, String var2);

            public OptionalStep useTokenProvider(ITokenProvider var1);
        }

        public static interface AuthStep {
            public OptionalStep useEventHubConnectionString(String var1);

            public OptionalStep useEventHubConnectionString(String var1, String var2);

            public AADAuthStep useAADAuthentication(URI var1, String var2);
        }

        public static interface ManagerStep {
            public AuthStep useAzureStorageCheckpointLeaseManager(String var1, String var2, String var3);

            public AuthStep useAzureStorageCheckpointLeaseManager(StorageCredentials var1, String var2, String var3);

            public AuthStep useUserCheckpointAndLeaseManagers(ICheckpointManager var1, ILeaseManager var2);
        }
    }

    static class EventProcessorHostThreadPoolFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final String namePrefix;
        private final String hostName;
        private final String entityName;
        private final String consumerGroupName;

        EventProcessorHostThreadPoolFactory(String hostName, String entityName, String consumerGroupName) {
            this.hostName = hostName;
            this.entityName = entityName;
            this.consumerGroupName = consumerGroupName;
            this.namePrefix = this.getNamePrefix();
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(false);
            t.setPriority(5);
            t.setUncaughtExceptionHandler(new ThreadUncaughtExceptionHandler());
            return t;
        }

        private String getNamePrefix() {
            return String.format(Locale.US, "[%s|%s|%s]-%s-", this.entityName, this.consumerGroupName, this.hostName, POOL_NUMBER.getAndIncrement());
        }

        static class ThreadUncaughtExceptionHandler
        implements Thread.UncaughtExceptionHandler {
            ThreadUncaughtExceptionHandler() {
            }

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                TRACE_LOGGER.warn("Uncaught exception occurred. Thread " + t.getName(), e);
            }
        }
    }
}

