/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.hopgui.file.IHopFileType;

public class HopFileTypeRegistry {
    private static final Class<?> PKG = HopFileTypeRegistry.class;
    private static HopFileTypeRegistry hopFileTypeRegistry;
    private List<IHopFileType> hopFileTypes = new ArrayList<IHopFileType>();

    private HopFileTypeRegistry() {
    }

    public static final HopFileTypeRegistry getInstance() {
        if (hopFileTypeRegistry == null) {
            hopFileTypeRegistry = new HopFileTypeRegistry();
        }
        return hopFileTypeRegistry;
    }

    public List<IHopFileType> getFileTypes() {
        return this.hopFileTypes;
    }

    public void registerHopFile(IHopFileType hopFileTypeInterface) {
        if (!this.hopFileTypes.contains(hopFileTypeInterface)) {
            this.hopFileTypes.add(hopFileTypeInterface);
        }
    }

    public IHopFileType findHopFileType(String filename) throws HopException {
        for (IHopFileType hopFile : this.hopFileTypes) {
            if (!hopFile.isHandledBy(filename, false)) continue;
            return hopFile;
        }
        for (IHopFileType hopFile : this.hopFileTypes) {
            if (!hopFile.isHandledBy(filename, true)) continue;
            return hopFile;
        }
        return null;
    }

    public String[] getFilterExtensions() {
        ArrayList<String> filterExtensions = new ArrayList<String>();
        for (IHopFileType hopFile : this.hopFileTypes) {
            filterExtensions.addAll(Arrays.asList(hopFile.getFilterExtensions()));
        }
        if (filterExtensions.size() > 1) {
            Object all = "";
            for (String filterExtension : filterExtensions) {
                if (((String)all).length() > 0) {
                    all = (String)all + ";";
                }
                all = (String)all + filterExtension;
            }
            filterExtensions.add(0, (String)all);
        }
        return filterExtensions.toArray(new String[0]);
    }

    public String[] getFilterNames() {
        ArrayList<String> filterNames = new ArrayList<String>();
        for (IHopFileType hopFile : this.hopFileTypes) {
            filterNames.addAll(Arrays.asList(hopFile.getFilterNames()));
        }
        if (filterNames.size() > 1) {
            filterNames.add(0, BaseMessages.getString(PKG, (String)"HopFileTypeRegistry.FileTypes.All.Label", (String[])new String[0]));
        }
        return filterNames.toArray(new String[0]);
    }

    public List<String> getFileTypeNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (IHopFileType fileType : this.hopFileTypes) {
            names.add(fileType.getName());
        }
        return names;
    }

    public IHopFileType getFileTypeByName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        for (IHopFileType fileType : this.hopFileTypes) {
            if (!fileType.getName().equalsIgnoreCase(name)) continue;
            return fileType;
        }
        return null;
    }
}

