/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.util.ErrorHandler;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import net.ucanaccess.converters.LoadJet;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.DBReference;
import net.ucanaccess.jdbc.DBReferenceSingleton;
import net.ucanaccess.jdbc.DefaultJackcessOpener;
import net.ucanaccess.jdbc.JackcessOpenerInterface;
import net.ucanaccess.jdbc.Session;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import net.ucanaccess.util.Logger;

public final class UcanaccessDriver
implements Driver {
    public static final String URL_PREFIX = "jdbc:ucanaccess://";

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(URL_PREFIX) && url.length() > URL_PREFIX.length();
    }

    @Override
    public Connection connect(String _url, Properties _props) throws SQLException {
        if (!this.acceptsURL(_url)) {
            return null;
        }
        this.readProperties(_props, _url);
        String fileMdbPath = _url.indexOf(";") > 0 ? _url.substring(URL_PREFIX.length(), _url.indexOf(";")) : _url.substring(URL_PREFIX.length());
        File mdb = new File(fileMdbPath);
        DBReferenceSingleton as = DBReferenceSingleton.getInstance();
        Class<UcanaccessDriver> clazz = UcanaccessDriver.class;
        synchronized (UcanaccessDriver.class) {
            try {
                String user;
                String pwd;
                DBReference dbRef;
                boolean useCustomOpener;
                Session session = new Session();
                boolean alreadyLoaded = as.loaded(mdb);
                Database.FileFormat ff = null;
                if (_props.containsKey("newdatabaseversion") && !mdb.exists()) {
                    ff = Database.FileFormat.valueOf((String)_props.getProperty("newdatabaseversion").toUpperCase());
                }
                DefaultJackcessOpener jko = (useCustomOpener = _props.containsKey("jackcessopener")) ? this.newJackcessOpenerInstance(_props.getProperty("jackcessopener")) : new DefaultJackcessOpener();
                DBReference dBReference = dbRef = alreadyLoaded ? as.getReference(mdb) : as.loadReference(mdb, ff, jko, _props.getProperty("password"));
                if (!alreadyLoaded) {
                    if ((useCustomOpener || _props.containsKey("encrypt") && Boolean.parseBoolean(_props.getProperty("encrypt"))) && (_props.containsKey("memory") && !Boolean.parseBoolean(_props.getProperty("memory")) || _props.containsKey("keepmirror"))) {
                        dbRef.setEncryptHSQLDB(true);
                    }
                    if (_props.containsKey("memory")) {
                        dbRef.setInMemory(Boolean.parseBoolean(_props.getProperty("memory")));
                    }
                    if (_props.containsKey("lobscale")) {
                        Integer vl = this.validateLobScale(_props.getProperty("lobscale"));
                        dbRef.setLobScale(vl);
                    }
                    if (_props.containsKey("keepmirror")) {
                        dbRef.setInMemory(false);
                        if (dbRef.isEncryptHSQLDB()) {
                            net.ucanaccess.util.Logger.logWarning(Logger.Messages.KEEP_MIRROR_AND_OTHERS);
                        } else {
                            File dbMirror = new File(_props.getProperty("keepmirror") + mdb.getName().toUpperCase().hashCode());
                            dbRef.setToKeepHsql(dbMirror);
                            if (_props.containsKey("readonlymirror")) {
                                dbRef.setMirrorReadOnly(Boolean.parseBoolean(_props.getProperty("readonlymirror")));
                            }
                        }
                    }
                    if (_props.containsKey("showschema")) {
                        dbRef.setShowSchema(Boolean.parseBoolean(_props.getProperty("showschema")));
                    }
                    if (_props.containsKey("inactivitytimeout")) {
                        int millis = 60000 * Integer.parseInt(_props.getProperty("inactivitytimeout"));
                        dbRef.setInactivityTimeout(millis);
                    }
                    if (_props.containsKey("singleconnection")) {
                        dbRef.setImmediatelyReleaseResources(Boolean.parseBoolean(_props.getProperty("singleconnection")));
                    }
                    if (_props.containsKey("immediatelyreleaseresources")) {
                        dbRef.setImmediatelyReleaseResources(Boolean.parseBoolean(_props.getProperty("immediatelyreleaseresources")));
                    }
                    if (_props.containsKey("lockmdb")) {
                        dbRef.setOpenExclusive(Boolean.parseBoolean(_props.getProperty("lockmdb")));
                    }
                    if (_props.containsKey("openexclusive")) {
                        dbRef.setOpenExclusive(Boolean.parseBoolean(_props.getProperty("openexclusive")));
                    }
                    if (_props.containsKey("concatnulls")) {
                        dbRef.setConcatNulls(Boolean.parseBoolean(_props.getProperty("concatnulls")));
                    }
                    if (_props.containsKey("preventreloading")) {
                        dbRef.setPreventReloading(Boolean.parseBoolean(_props.getProperty("preventreloading")));
                    }
                    if (_props.containsKey("remap")) {
                        dbRef.setExternalResourcesMapping(this.toMap(_props.getProperty("remap")));
                    }
                    if (_props.containsKey("supportsaccesslike")) {
                        SQLConverter.setSupportsAccessLike(Boolean.parseBoolean(_props.getProperty("supportsaccesslike")));
                    }
                    if (_props.containsKey("columnorder") && "display".equalsIgnoreCase(_props.getProperty("columnorder"))) {
                        dbRef.setColumnOrderDisplay();
                    }
                    if (_props.containsKey("mirrorfolder") && dbRef.getToKeepHsql() == null) {
                        dbRef.setInMemory(false);
                        String fd = _props.getProperty("mirrorfolder");
                        dbRef.setMirrorFolder(new File("java.io.tmpdir".equals(fd) ? System.getProperty("java.io.tmpdir") : fd));
                    }
                    if (_props.containsKey("ignorecase")) {
                        dbRef.setIgnoreCase(Boolean.parseBoolean(_props.getProperty("ignorecase")));
                    }
                    dbRef.getDbIO().setErrorHandler(new ErrorHandler(){

                        public Object handleRowError(Column cl, byte[] bt, ErrorHandler.Location location, Exception ex) throws IOException {
                            if (cl.getType().isTextual()) {
                                net.ucanaccess.util.Logger.logParametricWarning(Logger.Messages.INVALID_CHARACTER_SEQUENCE, cl.getTable().getName(), cl.getName(), new String(bt));
                            }
                            throw new IOException(ex.getMessage());
                        }
                    });
                }
                if ((pwd = dbRef.getDbIO().getDatabasePassword()) != null && !_props.containsKey("jackcessopener")) {
                    if (!pwd.equals(_props.get("password"))) {
                        throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.NOT_A_VALID_PASSWORD);
                    }
                } else if (_props.containsKey("jackcessopener")) {
                    String mpwd = _props.getProperty("password");
                    session.setPassword(mpwd);
                }
                if ((user = _props.getProperty("user")) != null) {
                    session.setUser(user);
                }
                SQLWarning sqlw = null;
                if (!alreadyLoaded) {
                    boolean toBeLoaded = !dbRef.loadedFromKeptMirror(session);
                    LoadJet la = new LoadJet(dbRef.getHSQLDBConnection(session), dbRef.getDbIO());
                    net.ucanaccess.util.Logger.turnOffJackcessLog();
                    if (_props.containsKey("sysschema")) {
                        boolean sysSchema = Boolean.parseBoolean(_props.getProperty("sysschema"));
                        dbRef.setSysSchema(sysSchema);
                        la.setSysSchema(sysSchema);
                    }
                    if (_props.containsKey("skipindexes")) {
                        boolean skipIndexes = Boolean.parseBoolean(_props.getProperty("skipindexes"));
                        dbRef.setSkipIndexes(skipIndexes);
                        la.setSkipIndexes(skipIndexes);
                    }
                    if (toBeLoaded) {
                        la.loadDB();
                    } else {
                        la.resetFunctionsDefault();
                    }
                    as.put(mdb.getAbsolutePath(), dbRef);
                    sqlw = la.getLoadingWarnings();
                }
                UcanaccessConnection uc = new UcanaccessConnection(as.getReference(mdb), _props, session);
                uc.addWarnings(sqlw);
                uc.setUrl(_url);
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return uc;
            }
            catch (Exception e) {
                throw new UcanaccessSQLException(e);
            }
        }
    }

    private Integer validateLobScale(String property) {
        try {
            Integer i = Integer.parseInt(property);
            if (i == 1 || i == 2 || i == 4 || i == 8 || i == 16 || i == 32) {
                return i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        net.ucanaccess.util.Logger.logWarning(Logger.Messages.LOBSCALE);
        return null;
    }

    private Map<String, String> toMap(String property) {
        HashMap<String, String> hm = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(property, "&");
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            if (entry.indexOf("|") < 0) continue;
            hm.put(entry.substring(0, entry.indexOf(124)).toLowerCase(), entry.substring(entry.indexOf(124) + 1));
        }
        return hm;
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties arg1) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    private JackcessOpenerInterface newJackcessOpenerInstance(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException, UcanaccessSQLException {
        Object newInstance = Class.forName(className).newInstance();
        if (!(newInstance instanceof JackcessOpenerInterface)) {
            throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.INVALID_JACKCESS_OPENER);
        }
        return (JackcessOpenerInterface)newInstance;
    }

    private void readProperties(Properties pr, String url) {
        Properties nb = new Properties();
        for (Map.Entry<Object, Object> entry : pr.entrySet()) {
            String key = (String)entry.getKey();
            if (key == null) continue;
            nb.put(key.toLowerCase(), entry.getValue());
        }
        pr.clear();
        pr.putAll((Map<?, ?>)nb);
        StringTokenizer st = new StringTokenizer(url, ";");
        while (st.hasMoreTokens()) {
            String string = st.nextToken();
            int sep = string.indexOf("=");
            if (sep <= 0 || string.length() <= sep) continue;
            pr.put(string.substring(0, sep).toLowerCase(), string.substring(sep + 1, string.length()));
        }
    }

    static {
        try {
            DriverManager.registerDriver(new UcanaccessDriver());
            Class.forName("org.hsqldb.jdbc.JDBCDriver");
        }
        catch (ClassNotFoundException e) {
            net.ucanaccess.util.Logger.logMessage(Logger.Messages.HSQLDB_DRIVER_NOT_FOUND);
            throw new RuntimeException(e.getMessage());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

