/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.internal;

import com.google.crypto.tink.internal.BuildDispatchedCode;
import com.google.crypto.tink.internal.TinkBugException;
import com.google.crypto.tink.util.Bytes;
import java.security.SecureRandom;
import javax.annotation.Nullable;

public final class Util {
    public static int randKeyId() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] rand = new byte[4];
        int result = 0;
        while (result == 0) {
            secureRandom.nextBytes(rand);
            result = (rand[0] & 0x7F) << 24 | (rand[1] & 0xFF) << 16 | (rand[2] & 0xFF) << 8 | rand[3] & 0xFF;
        }
        return result;
    }

    private static final byte toByteFromPrintableAscii(char c) {
        if (c < '!' || c > '~') {
            throw new TinkBugException("Not a printable ASCII character: " + c);
        }
        return (byte)c;
    }

    public static final Bytes toBytesFromPrintableAscii(String s) {
        byte[] result = new byte[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            result[i] = Util.toByteFromPrintableAscii(s.charAt(i));
        }
        return Bytes.copyFrom(result);
    }

    @Nullable
    public static Integer getAndroidApiLevel() {
        return BuildDispatchedCode.getApiLevel();
    }

    private Util() {
    }
}

