/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkConf;
import org.apache.spark.streaming.scheduler.RateController$;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.scheduler.StreamingListener;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchSubmitted;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverError;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStopped;
import org.apache.spark.streaming.scheduler.StreamingListenerStreamingStarted;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%cA\u0002\f\u0018\u0003\u0003I\u0012\u0005\u0003\u00050\u0001\t\u0015\r\u0011\"\u00012\u0011!)\u0004A!A!\u0002\u0013\u0011\u0004\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u000bu\u0002A\u0011\u0001 \t\u000b\t\u0003a\u0011C\"\t\u0013-\u0003\u0001\u0019!a\u0001\n\u0017a\u0005\"C*\u0001\u0001\u0004\u0005\r\u0011\"\u0003U\u0011%9\u0006\u00011A\u0001B\u0003&Q\nC\u0005]\u0001\u0001\u0007\t\u0019!C\u0005;\"I\u0011\u000e\u0001a\u0001\u0002\u0004%IA\u001b\u0005\nY\u0002\u0001\r\u0011!Q!\nyCQA\u001c\u0001\u0005\n=DQ\u0001\u001d\u0001\u0005\nEDQA\u001f\u0001\u0005\nmDq!!\u0003\u0001\t\u0003\tY\u0001C\u0004\u0002\u000e\u0001!\t%a\u0004\b\u000f\u0005mq\u0003#\u0001\u0002\u001e\u00191ac\u0006E\u0001\u0003?Aa!\u0010\n\u0005\u0002\u0005\u0005\u0002bBA\u0012%\u0011\u0005\u0011Q\u0005\u0005\n\u0003s\u0011\u0012\u0011!C\u0005\u0003w\u0011aBU1uK\u000e{g\u000e\u001e:pY2,'O\u0003\u0002\u00193\u0005I1o\u00195fIVdWM\u001d\u0006\u00035m\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005qi\u0012!B:qCJ\\'B\u0001\u0010 \u0003\u0019\t\u0007/Y2iK*\t\u0001%A\u0002pe\u001e\u001cB\u0001\u0001\u0012)YA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\u0004\"!\u000b\u0016\u000e\u0003]I!aK\f\u0003#M#(/Z1nS:<G*[:uK:,'\u000f\u0005\u0002$[%\u0011a\u0006\n\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\ngR\u0014X-Y7V\u0013\u0012\u001b\u0001!F\u00013!\t\u00193'\u0003\u00025I\t\u0019\u0011J\u001c;\u0002\u0015M$(/Z1n+&#\u0005%A\u0007sCR,Wi\u001d;j[\u0006$xN\u001d\t\u0003qmj\u0011!\u000f\u0006\u0003u]\tAA]1uK&\u0011A(\u000f\u0002\u000e%\u0006$X-R:uS6\fGo\u001c:\u0002\rqJg.\u001b;?)\ry\u0004)\u0011\t\u0003S\u0001AQa\f\u0003A\u0002IBQA\u000e\u0003A\u0002]\nq\u0001];cY&\u001c\b\u000e\u0006\u0002E\u000fB\u00111%R\u0005\u0003\r\u0012\u0012A!\u00168ji\")!(\u0002a\u0001\u0011B\u00111%S\u0005\u0003\u0015\u0012\u0012A\u0001T8oO\u0006\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010^\u000b\u0002\u001bB\u0011a*U\u0007\u0002\u001f*\u0011\u0001\u000bJ\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001*P\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u000bfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi~#S-\u001d\u000b\u0003\tVCqAV\u0004\u0002\u0002\u0003\u0007Q*A\u0002yIE\n\u0011#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;!Q\tA\u0011\f\u0005\u0002$5&\u00111\f\n\u0002\niJ\fgn]5f]R\f\u0011B]1uK2KW.\u001b;\u0016\u0003y\u0003\"aX4\u000e\u0003\u0001T!!\u00192\u0002\r\u0005$x.\\5d\u0015\t\u00016M\u0003\u0002eK\u0006!Q\u000f^5m\u0015\u00051\u0017\u0001\u00026bm\u0006L!\u0001\u001b1\u0003\u0015\u0005#x.\\5d\u0019>tw-A\u0007sCR,G*[7ji~#S-\u001d\u000b\u0003\t.DqA\u0016\u0006\u0002\u0002\u0003\u0007a,\u0001\u0006sCR,G*[7ji\u0002B#aC-\u0002\t%t\u0017\u000e\u001e\u000b\u0002\t\u0006Q!/Z1e\u001f\nTWm\u0019;\u0015\u0005\u0011\u0013\b\"B:\u000e\u0001\u0004!\u0018aA8jgB\u0011Q\u000f_\u0007\u0002m*\u0011q/Z\u0001\u0003S>L!!\u001f<\u0003#=\u0013'.Z2u\u0013:\u0004X\u000f^*ue\u0016\fW.A\td_6\u0004X\u000f^3B]\u0012\u0004VO\u00197jg\"$r\u0001\u0012?\u007f\u0003\u0003\t)\u0001C\u0003~\u001d\u0001\u0007\u0001*\u0001\u0003uS6,\u0007\"B@\u000f\u0001\u0004A\u0015!B3mK6\u001c\bBBA\u0002\u001d\u0001\u0007\u0001*A\u0005x_J\\G)\u001a7bs\"1\u0011q\u0001\bA\u0002!\u000b\u0011b^1ji\u0012+G.Y=\u0002\u001b\u001d,G\u000fT1uKN$(+\u0019;f)\u0005A\u0015\u0001E8o\u0005\u0006$8\r[\"p[BdW\r^3e)\r!\u0015\u0011\u0003\u0005\b\u0003'\u0001\u0002\u0019AA\u000b\u00039\u0011\u0017\r^2i\u0007>l\u0007\u000f\\3uK\u0012\u00042!KA\f\u0013\r\tIb\u0006\u0002 'R\u0014X-Y7j]\u001ed\u0015n\u001d;f]\u0016\u0014()\u0019;dQ\u000e{W\u000e\u001d7fi\u0016$\u0017A\u0004*bi\u0016\u001cuN\u001c;s_2dWM\u001d\t\u0003SI\u00192A\u0005\u0012-)\t\ti\"A\u000bjg\n\u000b7m\u001b)sKN\u001cXO]3F]\u0006\u0014G.\u001a3\u0015\t\u0005\u001d\u0012Q\u0006\t\u0004G\u0005%\u0012bAA\u0016I\t9!i\\8mK\u0006t\u0007bBA\u0018)\u0001\u0007\u0011\u0011G\u0001\u0005G>tg\r\u0005\u0003\u00024\u0005UR\"A\u000e\n\u0007\u0005]2DA\u0005Ta\u0006\u00148nQ8oM\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\u0004\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019%Z\u0001\u0005Y\u0006tw-\u0003\u0003\u0002H\u0005\u0005#AB(cU\u0016\u001cG\u000f")
public abstract class RateController
implements StreamingListener,
scala.Serializable {
    private final int streamUID;
    private final RateEstimator rateEstimator;
    private transient ExecutionContext executionContext;
    private transient AtomicLong rateLimit;

    public static boolean isBackPressureEnabled(SparkConf sparkConf) {
        return RateController$.MODULE$.isBackPressureEnabled(sparkConf);
    }

    @Override
    public void onStreamingStarted(StreamingListenerStreamingStarted streamingStarted) {
        StreamingListener.onStreamingStarted$(this, streamingStarted);
    }

    @Override
    public void onReceiverStarted(StreamingListenerReceiverStarted receiverStarted) {
        StreamingListener.onReceiverStarted$(this, receiverStarted);
    }

    @Override
    public void onReceiverError(StreamingListenerReceiverError receiverError) {
        StreamingListener.onReceiverError$(this, receiverError);
    }

    @Override
    public void onReceiverStopped(StreamingListenerReceiverStopped receiverStopped) {
        StreamingListener.onReceiverStopped$(this, receiverStopped);
    }

    @Override
    public void onBatchSubmitted(StreamingListenerBatchSubmitted batchSubmitted) {
        StreamingListener.onBatchSubmitted$(this, batchSubmitted);
    }

    @Override
    public void onBatchStarted(StreamingListenerBatchStarted batchStarted) {
        StreamingListener.onBatchStarted$(this, batchStarted);
    }

    @Override
    public void onOutputOperationStarted(StreamingListenerOutputOperationStarted outputOperationStarted) {
        StreamingListener.onOutputOperationStarted$(this, outputOperationStarted);
    }

    @Override
    public void onOutputOperationCompleted(StreamingListenerOutputOperationCompleted outputOperationCompleted) {
        StreamingListener.onOutputOperationCompleted$(this, outputOperationCompleted);
    }

    public int streamUID() {
        return this.streamUID;
    }

    public abstract void publish(long var1);

    private ExecutionContext executionContext() {
        return this.executionContext;
    }

    private void executionContext_$eq(ExecutionContext x$1) {
        this.executionContext = x$1;
    }

    private AtomicLong rateLimit() {
        return this.rateLimit;
    }

    private void rateLimit_$eq(AtomicLong x$1) {
        this.rateLimit = x$1;
    }

    private void init() {
        this.executionContext_$eq((ExecutionContext)ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)ThreadUtils$.MODULE$.newDaemonSingleThreadExecutor("stream-rate-update")));
        this.rateLimit_$eq(new AtomicLong(-1L));
    }

    private void readObject(ObjectInputStream ois) {
        Utils$.MODULE$.tryOrIOException((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ois.defaultReadObject();
            this.init();
        });
    }

    private void computeAndPublish(long time, long elems, long workDelay, long waitDelay) {
        Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Option<Object> newRate = $this.rateEstimator.compute(time, elems, workDelay, waitDelay);
            newRate.foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)s -> {
                this.rateLimit().set((long)s);
                this.publish(this.getLatestRate());
            });
        }, this.executionContext());
    }

    public long getLatestRate() {
        return this.rateLimit().get();
    }

    @Override
    public void onBatchCompleted(StreamingListenerBatchCompleted batchCompleted) {
        Map<Object, StreamInputInfo> elements = batchCompleted.batchInfo().streamIdToInputInfo();
        batchCompleted.batchInfo().processingEndTime().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)processingEnd -> batchCompleted.batchInfo().processingDelay().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)workDelay -> batchCompleted.batchInfo().schedulingDelay().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)waitDelay -> elements.get((Object)BoxesRunTime.boxToInteger((int)this.streamUID())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.numRecords())).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)elems -> this.computeAndPublish(processingEnd, elems, workDelay, waitDelay)))));
    }

    public RateController(int streamUID, RateEstimator rateEstimator) {
        this.streamUID = streamUID;
        this.rateEstimator = rateEstimator;
        StreamingListener.$init$(this);
        this.init();
    }
}

