/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.variables.Variables;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;

public class JarCache {
    public static final String ANNOTATION_INDEX_LOCATION = "META-INF/jandex.idx";
    private static JarCache instance;
    private final Map<File, Index> indexCache;
    private final Map<File, Set<File>> jarFiles;
    private final Set<File> nativeFiles = new HashSet<File>();
    private final Set<File> pluginFiles = new HashSet<File>();

    private JarCache() {
        this.jarFiles = new HashMap<File, Set<File>>();
        this.indexCache = new HashMap<File, Index>();
    }

    public static JarCache getInstance() {
        if (instance == null) {
            instance = new JarCache();
        }
        return instance;
    }

    public List<String> getPluginFolders() {
        String[] folders;
        ArrayList<String> pluginFolders = new ArrayList<String>();
        String folderPaths = Const.NVL(Variables.getADefaultVariableSpace().getVariable("HOP_PLUGIN_BASE_FOLDERS"), EnvUtil.getSystemProperty("HOP_PLUGIN_BASE_FOLDERS"));
        if (folderPaths == null) {
            folderPaths = "plugins";
        }
        for (String folder : folders = folderPaths.split(",")) {
            pluginFolders.add(folder.trim());
        }
        return pluginFolders;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<File> getNativeJars() throws HopFileException {
        if (!this.nativeFiles.isEmpty()) return this.nativeFiles;
        try {
            Enumeration<URL> indexFiles = this.getClass().getClassLoader().getResources(ANNOTATION_INDEX_LOCATION);
            while (indexFiles.hasMoreElements()) {
                URL url = indexFiles.nextElement();
                String path = url.getFile();
                File file = new File(StringUtils.substringBefore((String)path, (String)"!/"));
                this.nativeFiles.add(file);
                try {
                    InputStream stream = url.openStream();
                    try {
                        IndexReader reader = new IndexReader(stream);
                        Index index = reader.read();
                        this.indexCache.put(file, index);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (IOException e) {
                    throw new HopFileException(MessageFormat.format("Error reading annotation index from url ''{0}''", url), e);
                    return this.nativeFiles;
                }
            }
        }
        catch (Exception e) {
            throw new HopFileException("Error finding native plugin jar", e);
        }
    }

    public Set<File> getPluginJars() throws HopFileException {
        if (this.pluginFiles.isEmpty()) {
            for (String pluginFolder : this.getPluginFolders()) {
                for (File file : this.findJarFiles(new File(pluginFolder))) {
                    Index index = this.getIndex(file);
                    if (index == null) continue;
                    this.pluginFiles.add(file);
                }
            }
        }
        return this.pluginFiles;
    }

    public Index getIndex(File jarFile) throws HopFileException {
        Index index = this.indexCache.get(jarFile);
        if (index == null) {
            block14: {
                try (JarFile jar = new JarFile(jarFile);){
                    ZipEntry entry = jar.getEntry(ANNOTATION_INDEX_LOCATION);
                    if (entry == null) break block14;
                    try (InputStream stream = jar.getInputStream(entry);){
                        IndexReader reader = new IndexReader(stream);
                        index = reader.read();
                        this.indexCache.put(jarFile, index);
                    }
                }
                catch (IOException e) {
                    throw new HopFileException(MessageFormat.format("Error reading annotation index from file ''{0}''", jarFile), e);
                }
            }
            this.indexCache.put(jarFile, index);
        }
        return index;
    }

    public void clear() {
        this.nativeFiles.clear();
        this.pluginFiles.clear();
        this.indexCache.clear();
        this.jarFiles.clear();
    }

    public Set<File> findJarFiles(File folder) throws HopFileException {
        Set<File> files = this.jarFiles.get(folder);
        if (files == null) {
            try {
                files = JarCache.findFiles(folder);
                this.jarFiles.put(folder, files);
            }
            catch (Exception e) {
                throw new HopFileException("Unable to list jar files in plugin folder '" + folder + "'", e);
            }
        }
        return files;
    }

    private static Set<File> findFiles(File folder) {
        HashSet<File> files = new HashSet<File>();
        File[] children = folder.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isFile()) {
                    if (!child.getName().endsWith(".jar")) continue;
                    files.add(child);
                    continue;
                }
                if (!child.isDirectory() || "lib".equals(child.getName())) continue;
                files.addAll(JarCache.findFiles(child));
            }
        }
        return files;
    }
}

