/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.client.program.MutatedConfigurationException;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.execution.DetachedJobExecutionResult;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.execution.PipelineExecutorServiceLoader;
import org.apache.flink.runtime.dispatcher.ConfigurationNotAllowedMessage;
import org.apache.flink.shaded.guava30.com.google.common.collect.MapDifference;
import org.apache.flink.shaded.guava30.com.google.common.collect.Maps;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironmentFactory;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.ShutdownHookUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class StreamContextEnvironment
extends StreamExecutionEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionEnvironment.class);
    private static final Map<String, WildcardOption<?>> SUPPORTED_PROGRAM_CONFIG_WILDCARDS = new HashMap();
    private final boolean suppressSysout;
    private final boolean enforceSingleJobExecution;
    private final Configuration clusterConfiguration;
    private int jobCounter;
    private final boolean programConfigEnabled;
    private final Collection<String> programConfigWildcards;

    public StreamContextEnvironment(PipelineExecutorServiceLoader executorServiceLoader, Configuration configuration, ClassLoader userCodeClassLoader, boolean enforceSingleJobExecution, boolean suppressSysout) {
        this(executorServiceLoader, configuration, configuration, userCodeClassLoader, enforceSingleJobExecution, suppressSysout, true, Collections.emptyList());
    }

    @Internal
    public StreamContextEnvironment(PipelineExecutorServiceLoader executorServiceLoader, Configuration clusterConfiguration, Configuration configuration, ClassLoader userCodeClassLoader, boolean enforceSingleJobExecution, boolean suppressSysout, boolean programConfigEnabled, Collection<String> programConfigWildcards) {
        super(executorServiceLoader, configuration, userCodeClassLoader);
        this.suppressSysout = suppressSysout;
        this.enforceSingleJobExecution = enforceSingleJobExecution;
        this.clusterConfiguration = clusterConfiguration;
        this.jobCounter = 0;
        this.programConfigEnabled = programConfigEnabled;
        this.programConfigWildcards = programConfigWildcards;
    }

    public JobExecutionResult execute(StreamGraph streamGraph) throws Exception {
        JobClient jobClient = this.executeAsync(streamGraph);
        List jobListeners = this.getJobListeners();
        try {
            JobExecutionResult jobExecutionResult = this.getJobExecutionResult(jobClient);
            jobListeners.forEach(jobListener -> jobListener.onJobExecuted(jobExecutionResult, null));
            return jobExecutionResult;
        }
        catch (Throwable t) {
            jobListeners.forEach(jobListener -> jobListener.onJobExecuted(null, ExceptionUtils.stripExecutionException((Throwable)t)));
            ExceptionUtils.rethrowException((Throwable)t);
            return null;
        }
    }

    private JobExecutionResult getJobExecutionResult(JobClient jobClient) throws Exception {
        DetachedJobExecutionResult jobExecutionResult;
        Preconditions.checkNotNull((Object)jobClient);
        if (this.configuration.getBoolean(DeploymentOptions.ATTACHED)) {
            CompletableFuture jobExecutionResultFuture = jobClient.getJobExecutionResult();
            if (this.configuration.getBoolean(DeploymentOptions.SHUTDOWN_IF_ATTACHED)) {
                Thread shutdownHook = ShutdownHookUtil.addShutdownHook(() -> jobClient.cancel().get(1L, TimeUnit.SECONDS), (String)StreamContextEnvironment.class.getSimpleName(), (Logger)LOG);
                jobExecutionResultFuture.whenComplete((ignored, throwable) -> ShutdownHookUtil.removeShutdownHook((Thread)shutdownHook, (String)StreamContextEnvironment.class.getSimpleName(), (Logger)LOG));
            }
            jobExecutionResult = (JobExecutionResult)jobExecutionResultFuture.get();
            if (!this.suppressSysout) {
                System.out.println(jobExecutionResult);
            }
        } else {
            jobExecutionResult = new DetachedJobExecutionResult(jobClient.getJobID());
        }
        return jobExecutionResult;
    }

    public JobClient executeAsync(StreamGraph streamGraph) throws Exception {
        this.checkNotAllowedConfigurations();
        this.validateAllowedExecution();
        JobClient jobClient = super.executeAsync(streamGraph);
        if (!this.suppressSysout) {
            System.out.println("Job has been submitted with JobID " + jobClient.getJobID());
        }
        return jobClient;
    }

    private void validateAllowedExecution() {
        if (this.enforceSingleJobExecution && this.jobCounter > 0) {
            throw new FlinkRuntimeException("Cannot have more than one execute() or executeAsync() call in a single environment.");
        }
        ++this.jobCounter;
    }

    public static void setAsContext(PipelineExecutorServiceLoader executorServiceLoader, Configuration clusterConfiguration, ClassLoader userCodeClassLoader, boolean enforceSingleJobExecution, boolean suppressSysout) {
        StreamExecutionEnvironmentFactory factory = envInitConfig -> {
            boolean programConfigEnabled = (Boolean)clusterConfiguration.get(DeploymentOptions.PROGRAM_CONFIG_ENABLED);
            List programConfigWildcards = (List)clusterConfiguration.get(DeploymentOptions.PROGRAM_CONFIG_WILDCARDS);
            Configuration mergedEnvConfig = new Configuration();
            mergedEnvConfig.addAll(clusterConfiguration);
            mergedEnvConfig.addAll(envInitConfig);
            return new StreamContextEnvironment(executorServiceLoader, clusterConfiguration, mergedEnvConfig, userCodeClassLoader, enforceSingleJobExecution, suppressSysout, programConfigEnabled, programConfigWildcards);
        };
        StreamContextEnvironment.initializeContextEnvironment((StreamExecutionEnvironmentFactory)factory);
    }

    public static void unsetAsContext() {
        StreamContextEnvironment.resetContextEnvironment();
    }

    private void checkNotAllowedConfigurations() throws MutatedConfigurationException {
        Collection<String> errorMessages = this.collectNotAllowedConfigurations();
        if (!errorMessages.isEmpty()) {
            throw new MutatedConfigurationException(errorMessages);
        }
    }

    private Collection<String> collectNotAllowedConfigurations() {
        if (this.programConfigEnabled) {
            return Collections.emptyList();
        }
        ArrayList<String> errors = new ArrayList<String>();
        Configuration clusterConfigMap = new Configuration(this.clusterConfiguration);
        Configuration envConfigMap = new Configuration(this.configuration);
        this.removeProgramConfigWildcards(clusterConfigMap);
        this.removeProgramConfigWildcards(envConfigMap);
        MapDifference diff = Maps.difference((Map)clusterConfigMap.toMap(), (Map)envConfigMap.toMap());
        diff.entriesOnlyOnRight().forEach((k, v) -> errors.add(ConfigurationNotAllowedMessage.ofConfigurationKeyAndValue((String)k, (String)v)));
        diff.entriesOnlyOnLeft().forEach((k, v) -> errors.add(ConfigurationNotAllowedMessage.ofConfigurationRemoved((String)k, (String)v)));
        diff.entriesDiffering().forEach((k, v) -> errors.add(ConfigurationNotAllowedMessage.ofConfigurationChange((String)k, (MapDifference.ValueDifference)v)));
        Configuration enrichedClusterConfig = new Configuration(this.clusterConfiguration);
        this.enrichProgramConfigWildcards(enrichedClusterConfig);
        CheckpointConfig clusterCheckpointConfig = new CheckpointConfig();
        clusterCheckpointConfig.configure((ReadableConfig)enrichedClusterConfig);
        if (!Arrays.equals(StreamContextEnvironment.serializeConfig((Serializable)clusterCheckpointConfig), StreamContextEnvironment.serializeConfig((Serializable)this.checkpointCfg))) {
            errors.add(ConfigurationNotAllowedMessage.ofConfigurationObject((String)this.checkpointCfg.getClass().getSimpleName()));
        }
        ExecutionConfig clusterExecutionConfig = new ExecutionConfig();
        clusterExecutionConfig.configure((ReadableConfig)enrichedClusterConfig, this.getUserClassloader());
        if (!Arrays.equals(StreamContextEnvironment.serializeConfig((Serializable)clusterExecutionConfig), StreamContextEnvironment.serializeConfig((Serializable)this.config))) {
            errors.add(ConfigurationNotAllowedMessage.ofConfigurationObject((String)this.config.getClass().getSimpleName()));
        }
        return errors;
    }

    private void enrichProgramConfigWildcards(Configuration mutableConfig) {
        for (String key : this.programConfigWildcards) {
            WildcardOption<?> option = SUPPORTED_PROGRAM_CONFIG_WILDCARDS.get(key);
            if (option == null) {
                throw new FlinkRuntimeException(String.format("Unsupported option '%s' for program configuration wildcards.", key));
            }
            option.enrich(mutableConfig, this);
        }
    }

    private void removeProgramConfigWildcards(Configuration mutableConfig) {
        for (String key : this.programConfigWildcards) {
            WildcardOption<?> option = SUPPORTED_PROGRAM_CONFIG_WILDCARDS.get(key);
            if (option == null) {
                throw new FlinkRuntimeException(String.format("Unsupported option '%s' for program configuration wildcards.", key));
            }
            option.remove(mutableConfig);
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] serializeConfig(Serializable config) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        SUPPORTED_PROGRAM_CONFIG_WILDCARDS.put(PipelineOptions.GLOBAL_JOB_PARAMETERS.key(), new WildcardOption<Map>(PipelineOptions.GLOBAL_JOB_PARAMETERS, env -> env.getConfig().getGlobalJobParameters().toMap()));
    }

    private static final class WildcardOption<T> {
        private final ConfigOption<T> option;
        private final Function<StreamContextEnvironment, T> getter;

        WildcardOption(ConfigOption<T> option, Function<StreamContextEnvironment, T> getter) {
            this.option = option;
            this.getter = getter;
        }

        void enrich(Configuration mutableConfig, StreamContextEnvironment fromEnv) {
            mutableConfig.set(this.option, this.getter.apply(fromEnv));
        }

        void remove(Configuration mutableConfig) {
            mutableConfig.removeConfig(this.option);
        }
    }
}

