/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;

public final class NLS {
    private static final String CLASSNAME = "com.ibm.as400.access.NLS";
    private static int countryBytes_;
    private static int languageBytes_;
    private static final Hashtable languages_;
    private static final Hashtable countries_;
    static boolean forceJavaTables_;

    private NLS() {
    }

    public static String ccsidToEncoding(int n) {
        return (String)ConversionMaps.ccsidEncoding_.get(Integer.toString(n));
    }

    public static int encodingToCCSID(String string) {
        if (string == null) {
            return -1;
        }
        String string2 = (String)ConversionMaps.encodingCcsid_.get(string);
        if (string2 == null) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    public static int localeToCCSID(String string) {
        if (string == null) {
            return -1;
        }
        for (String string2 = string.trim(); string2 != null && string2.length() > 0; string2 = string2.substring(0, string2.lastIndexOf(95))) {
            String string3 = (String)ConversionMaps.localeCcsidMap_.get(string2);
            if (string3 == null) continue;
            return Integer.parseInt(string3);
        }
        return -1;
    }

    public static int localeToCCSID(Locale locale) {
        if (locale == null) {
            return -1;
        }
        String string = locale.toString();
        return NLS.localeToCCSID(string);
    }

    public static String localeToNLV(String string) {
        if (string == null) {
            return "";
        }
        for (String string2 = string.trim(); string2 != null && string2.length() > 0; string2 = string2.substring(0, string2.lastIndexOf(95))) {
            String string3 = (String)ConversionMaps.localeNlvMap_.get(string2);
            if (string3 == null) continue;
            return string3;
        }
        return "";
    }

    public static String localeToNLV(Locale locale) {
        if (locale == null) {
            return "";
        }
        String string = locale.toString();
        return NLS.localeToNLV(string);
    }

    public static String getCountryDescription(AS400 aS400, String string) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String string2 = (String)countries_.get(string = string.trim().toUpperCase());
        if (string2 == null) {
            int n = aS400.getCcsid();
            ConvTable convTable = ConvTable.getTable(n, null);
            ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(countryBytes_), new ProgramParameter(BinaryConverter.intToByteArray(countryBytes_)), new ProgramParameter(convTable.stringToByteArray("RTVC0100")), new ProgramParameter(new byte[4])};
            ProgramCall programCall = new ProgramCall(aS400, "/QSYS.LIB/QLGRTVCI.PGM", programParameterArray);
            if (!programCall.run()) {
                throw new AS400Exception(programCall.getMessageList());
            }
            byte[] byArray = programParameterArray[0].getOutputData();
            int n2 = BinaryConverter.byteArrayToInt(byArray, 0);
            int n3 = BinaryConverter.byteArrayToInt(byArray, 4);
            int n4 = BinaryConverter.byteArrayToInt(byArray, 12);
            if (n3 > n2) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Increasing RetrieveCountryID chunk size from " + countryBytes_ + " to " + (n3 + n4) + " and re-retrieving.");
                }
                countryBytes_ = n3 + n4;
                return NLS.getCountryDescription(aS400, string);
            }
            n = BinaryConverter.byteArrayToInt(byArray, 8);
            convTable = ConvTable.getTable(n, null);
            int n5 = BinaryConverter.byteArrayToInt(byArray, 16);
            for (int i = 0; i < n5; ++i) {
                String string3 = convTable.byteArrayToString(byArray, n4, 2).trim().toUpperCase();
                String string4 = convTable.byteArrayToString(byArray, n4 += 2, 40).trim();
                n4 += 40;
                countries_.put(string3, string4);
                if (!string3.equals(string)) continue;
                string2 = string4;
            }
        }
        return string2;
    }

    public static String getLanguageDescription(AS400 aS400, String string) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String string2 = (String)languages_.get(string = string.trim().toUpperCase());
        if (string2 == null) {
            int n = aS400.getCcsid();
            ConvTable convTable = ConvTable.getTable(n, null);
            ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(languageBytes_), new ProgramParameter(BinaryConverter.intToByteArray(languageBytes_)), new ProgramParameter(convTable.stringToByteArray("RTVL0100")), new ProgramParameter(new byte[4])};
            ProgramCall programCall = new ProgramCall(aS400, "/QSYS.LIB/QLGRTVLI.PGM", programParameterArray);
            if (!programCall.run()) {
                throw new AS400Exception(programCall.getMessageList());
            }
            byte[] byArray = programParameterArray[0].getOutputData();
            int n2 = BinaryConverter.byteArrayToInt(byArray, 0);
            int n3 = BinaryConverter.byteArrayToInt(byArray, 4);
            int n4 = BinaryConverter.byteArrayToInt(byArray, 16);
            if (n2 > n3) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Increasing RetrieveLanguageID chunk size from " + languageBytes_ + " to " + (n2 + n4) + " and re-retrieving.");
                }
                languageBytes_ = n2 + n4;
                return NLS.getLanguageDescription(aS400, string);
            }
            int n5 = BinaryConverter.byteArrayToInt(byArray, 8);
            n = BinaryConverter.byteArrayToInt(byArray, 12);
            convTable = ConvTable.getTable(n, null);
            for (int i = 0; i < n5; ++i) {
                String string3 = convTable.byteArrayToString(byArray, n4, 3).trim().toUpperCase();
                String string4 = convTable.byteArrayToString(byArray, n4 += 3, 40).trim();
                n4 += 40;
                languages_.put(string3, string4);
                if (!string3.equals(string)) continue;
                string2 = string4;
            }
        }
        return string2;
    }

    public static boolean isForceJavaConversion() {
        return forceJavaTables_;
    }

    public static void setForceJavaConversion(boolean bl) {
        forceJavaTables_ = bl;
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
        countryBytes_ = 11000;
        languageBytes_ = 3000;
        languages_ = new Hashtable();
        countries_ = new Hashtable();
        forceJavaTables_ = false;
    }
}

