/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Bin8;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryFieldDescription;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.HexFieldDescription;
import com.ibm.as400.access.RecordFormat;
import java.beans.PropertyVetoException;

class SystemStatusFormat
extends RecordFormat {
    static final long serialVersionUID = 4L;
    static AS400Bin4 bin4 = new AS400Bin4();
    static AS400Bin8 bin8;
    AS400 system_;

    SystemStatusFormat(AS400 aS400) {
        this.system_ = aS400;
        this.addBin4("numberOfBytesAvailable");
        this.addBin4("numberOfBytesReturned");
        this.addFieldDescription(new HexFieldDescription(new AS400ByteArray(8), "currentDateAndTime"));
        this.addChar(8, "systemName");
    }

    void addBin4(String string) {
        this.addFieldDescription(new BinaryFieldDescription(bin4, string));
    }

    void addBin8(String string) {
        if (bin8 == null) {
            bin8 = new AS400Bin8();
        }
        this.addFieldDescription(new BinaryFieldDescription(bin8, string));
    }

    void addChar(int n, String string) {
        this.addFieldDescription(new CharacterFieldDescription(new AS400Text(n, this.system_.getCcsid(), this.system_), string));
    }

    public void setName(String string) {
        try {
            super.setName(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }
}

