/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.VObject;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.Collator;
import java.util.Date;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

class VUtilities {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static Collator collator_;

    VUtilities() {
    }

    public static void constrain(Component component, JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        jPanel.add(component);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n4;
        gridBagConstraints.gridwidth = n2;
        gridBagConstraints.gridheight = n5;
        gridBagConstraints.fill = n7;
        gridBagConstraints.anchor = n8;
        gridBagConstraints.weightx = n3;
        gridBagConstraints.weighty = n6;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    public static void constrain(Component component, JPanel jPanel, GridBagLayout gridBagLayout, int n, int n2, int n3, int n4) {
        jPanel.add(component);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    public static void constrain(Component component, Component component2, JPanel jPanel, GridBagLayout gridBagLayout, int n) {
        VUtilities.constrain(component, jPanel, gridBagLayout, 0, n, 1, 1);
        VUtilities.constrain(component2, jPanel, gridBagLayout, 1, n, 1, 1);
    }

    public static void constrain(String string, String string2, JPanel jPanel, GridBagLayout gridBagLayout, int n) {
        VUtilities.constrain(new JLabel(string), new JLabel(string2), jPanel, gridBagLayout, n);
    }

    public static void constrain(Component component, JPanel jPanel, GridBagLayout gridBagLayout, int n) {
        VUtilities.constrain(component, jPanel, gridBagLayout, 0, n, 2, 1);
    }

    public static String formatHelp(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (n3 == n) {
                stringBuffer.append("\n");
                n3 = 0;
            }
            if (string.charAt(n4) == '&') {
                stringBuffer.append("\n");
                n3 = 0;
                ++n4;
            } else {
                stringBuffer = stringBuffer.append(string.charAt(n4));
            }
            ++n4;
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String formatHelp2(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = 0;
        int n3 = n;
        while (n3 < stringBuffer.length()) {
            int n4;
            for (n4 = n3; n4 > n2; --n4) {
                if (stringBuffer.charAt(n4) != ' ') continue;
                stringBuffer.setCharAt(n4, '\n');
                break;
            }
            if (n4 == n2) {
                stringBuffer = stringBuffer.insert(n3, '\n');
                n2 = n3;
                n3 += n;
                continue;
            }
            n3 = n4 + n;
            n2 = n4;
        }
        return stringBuffer.toString();
    }

    public static String getExceptionText(Exception exception) {
        String string = exception.getMessage();
        if (string == null) {
            string = exception.getClass().toString();
        } else if (string.length() == 0) {
            string = exception.getClass().toString();
        }
        return string;
    }

    public static Frame getFrame(Component component) {
        Component component2 = component;
        while (component2 != null && !(component2 instanceof Frame)) {
            component2 = VUtilities.getParentComponent(component2);
        }
        return (Frame)component2;
    }

    private static Component getParentComponent(Component component) {
        Component component2 = component instanceof JPopupMenu ? ((JPopupMenu)component).getInvoker() : component.getParent();
        return component2;
    }

    public static void sort(VObject[] vObjectArray, Object[] objectArray, boolean[] blArray) {
        int n;
        Object object;
        boolean[] blArray2;
        if (objectArray.length > blArray.length) {
            blArray2 = new boolean[objectArray.length];
            System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
        } else {
            blArray2 = blArray;
        }
        if (Trace.isTraceOn()) {
            object = new StringBuffer();
            for (n = 0; n < objectArray.length; ++n) {
                ((StringBuffer)object).append(objectArray[n]);
                ((StringBuffer)object).append(" (");
                ((StringBuffer)object).append(blArray2[n] ? "ascending" : "descending");
                ((StringBuffer)object).append(")");
                if (n == objectArray.length - 1) continue;
                ((StringBuffer)object).append(", ");
            }
            Trace.log(3, "Sorting by " + object + ".");
        }
        n = vObjectArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (!VUtilities.sortCompare(vObjectArray[i], vObjectArray[j], objectArray, blArray)) continue;
                object = vObjectArray[i];
                vObjectArray[i] = vObjectArray[j];
                vObjectArray[j] = object;
            }
        }
    }

    public static void sort(Vector vector, Object[] objectArray, boolean[] blArray) {
        Object[] objectArray2 = new VObject[vector.size()];
        vector.copyInto(objectArray2);
        VUtilities.sort((VObject[])objectArray2, objectArray, blArray);
        vector.removeAllElements();
        for (int i = 0; i < objectArray2.length; ++i) {
            vector.addElement(objectArray2[i]);
        }
    }

    private static boolean sortCompare(VObject vObject, VObject vObject2, Object[] objectArray, boolean[] blArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            boolean bl;
            Object object;
            Object object2;
            if (objectArray[i] != null) {
                object2 = vObject.getPropertyValue(objectArray[i]);
                object = vObject2.getPropertyValue(objectArray[i]);
            } else {
                object2 = vObject.toString();
                object = vObject2.toString();
            }
            if (object2 == null) {
                object2 = "";
            }
            if (object == null) {
                object = "";
            }
            if (object2 instanceof Date) {
                bl = ((Date)object2).after((Date)object);
            } else {
                if (object2.toString().equals(object.toString())) continue;
                if (object2 instanceof Number || object instanceof Number) {
                    long l = object2 instanceof Number ? ((Number)object2).longValue() : -1L;
                    long l2 = object instanceof Number ? ((Number)object).longValue() : -1L;
                    bl = l < l2;
                } else {
                    bl = collator_ != null ? collator_.compare(object2.toString(), object.toString()) < 0 : object2.toString().compareTo(object.toString()) < 0;
                }
            }
            return bl != blArray[i];
        }
        return true;
    }

    static {
        try {
            collator_ = Collator.getInstance();
            collator_.setStrength(0);
        }
        catch (Exception exception) {
            collator_ = null;
        }
    }
}

