/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum;

import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.RemotePeerMXBean;

public class RemotePeerBean
implements RemotePeerMXBean,
ZKMBeanInfo {
    private QuorumPeer.QuorumServer peer;
    private final QuorumPeer localPeer;

    public RemotePeerBean(QuorumPeer localPeer, QuorumPeer.QuorumServer peer) {
        this.peer = peer;
        this.localPeer = localPeer;
    }

    public void setQuorumServer(QuorumPeer.QuorumServer peer) {
        this.peer = peer;
    }

    @Override
    public String getName() {
        return "replica." + this.peer.id;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public String getQuorumAddress() {
        return this.peer.addr.getHostString() + ":" + this.peer.addr.getPort();
    }

    @Override
    public String getElectionAddress() {
        return this.peer.electionAddr.getHostString() + ":" + this.peer.electionAddr.getPort();
    }

    @Override
    public String getClientAddress() {
        if (null == this.peer.clientAddr) {
            return "";
        }
        return this.peer.clientAddr.getHostString() + ":" + this.peer.clientAddr.getPort();
    }

    @Override
    public String getLearnerType() {
        return this.peer.type.toString();
    }

    @Override
    public boolean isLeader() {
        return this.localPeer.isLeader(this.peer.getId());
    }
}

