/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.util.List;
import java.util.stream.IntStream;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;

public class ArrowResultChunkIndexSorter {
    private List<ValueVector> resultChunk;
    private List<ArrowVectorConverter> converters;
    private IntVector indices;

    public ArrowResultChunkIndexSorter(List<ValueVector> resultChunk, List<ArrowVectorConverter> converters) {
        this.resultChunk = resultChunk;
        this.converters = converters;
        this.initIndices();
    }

    private void initIndices() {
        BufferAllocator rootAllocator = this.resultChunk.get(0).getAllocator();
        FieldType fieldType = new FieldType(true, Types.MinorType.INT.getType(), null, null);
        this.indices = new IntVector("indices", fieldType, rootAllocator);
        IntStream.range(0, this.resultChunk.get(0).getValueCount()).forEach(i -> this.indices.setSafe(i, i));
    }

    public IntVector sort() throws SFException {
        this.quickSort(0, this.resultChunk.get(0).getValueCount() - 1);
        return this.indices;
    }

    private void quickSort(int low, int high) throws SFException {
        if (low < high) {
            int mid = this.partition(low, high);
            this.quickSort(low, mid - 1);
            this.quickSort(mid + 1, high);
        }
    }

    private int partition(int low, int high) throws SFException {
        int pivotIndex = this.indices.get(low);
        while (low < high) {
            while (low < high && this.compare(this.indices.get(high), pivotIndex) >= 0) {
                --high;
            }
            this.indices.set(low, this.indices.get(high));
            while (low < high && this.compare(this.indices.get(low), pivotIndex) <= 0) {
                ++low;
            }
            this.indices.set(high, this.indices.get(low));
        }
        this.indices.setSafe(low, pivotIndex);
        return low;
    }

    private int compare(int index1, int index2) throws SFException {
        int numCols = this.converters.size();
        for (int colIdx = 0; colIdx < numCols; ++colIdx) {
            if (this.converters.get(colIdx).isNull(index1) && this.converters.get(colIdx).isNull(index2)) continue;
            if (this.converters.get(colIdx).isNull(index1)) {
                return 1;
            }
            if (this.converters.get(colIdx).isNull(index2)) {
                return -1;
            }
            int res = this.converters.get(colIdx).toString(index1).compareTo(this.converters.get(colIdx).toString(index2));
            if (res == 0) continue;
            return res;
        }
        return 0;
    }
}

