/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.clients.admin.ScramCredentialInfo;

public class UserScramCredentialsDescription {
    private final String name;
    private final List<ScramCredentialInfo> credentialInfos;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserScramCredentialsDescription that = (UserScramCredentialsDescription)o;
        return this.name.equals(that.name) && this.credentialInfos.equals(that.credentialInfos);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.credentialInfos);
    }

    public String toString() {
        return "UserScramCredentialsDescription{name='" + this.name + '\'' + ", credentialInfos=" + this.credentialInfos + '}';
    }

    public UserScramCredentialsDescription(String name, List<ScramCredentialInfo> credentialInfos) {
        this.name = Objects.requireNonNull(name);
        this.credentialInfos = Collections.unmodifiableList(new ArrayList<ScramCredentialInfo>(credentialInfos));
    }

    public String name() {
        return this.name;
    }

    public List<ScramCredentialInfo> credentialInfos() {
        return this.credentialInfos;
    }
}

