/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.drools.core.base.ValueType;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.NetworkNode;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.SingleObjectSinkAdapter;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.ReadAccessor;
import org.drools.core.util.index.AlphaRangeIndex;
import org.drools.core.util.index.IndexUtil;

public class CompositeObjectSinkAdapter
implements ObjectSinkPropagator {
    private static final long serialVersionUID = 510L;
    private List<ObjectSinkNode> otherSinks;
    private List<AlphaNode> hashableSinks;
    private List<AlphaNode> rangeIndexableSinks = null;
    private List<FieldIndex> hashedFieldIndexes;
    private List<FieldIndex> rangeIndexedFieldIndexes;
    private Map<HashKey, AlphaNode> hashedSinkMap;
    private Map<FieldIndex, AlphaRangeIndex> rangeIndexMap;
    private int alphaNodeHashingThreshold;
    private int alphaNodeRangeIndexThreshold;
    private ObjectSink[] sinks;
    private Map<NetworkNode, NetworkNode> sinksMap;

    public CompositeObjectSinkAdapter() {
        this(3, 3);
    }

    public CompositeObjectSinkAdapter(int alphaNodeHashingThreshold, int alphaNodeRangeIndexThreshold) {
        this.alphaNodeHashingThreshold = alphaNodeHashingThreshold;
        this.alphaNodeRangeIndexThreshold = alphaNodeRangeIndexThreshold;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.otherSinks = (List)in.readObject();
        this.hashableSinks = (List)in.readObject();
        this.rangeIndexableSinks = (List)in.readObject();
        this.hashedFieldIndexes = (List)in.readObject();
        this.rangeIndexedFieldIndexes = (List)in.readObject();
        this.hashedSinkMap = (Map)in.readObject();
        this.rangeIndexMap = (Map)in.readObject();
        this.alphaNodeHashingThreshold = in.readInt();
        this.alphaNodeRangeIndexThreshold = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.otherSinks);
        out.writeObject(this.hashableSinks);
        out.writeObject(this.rangeIndexableSinks);
        out.writeObject(this.hashedFieldIndexes);
        out.writeObject(this.rangeIndexedFieldIndexes);
        out.writeObject(this.hashedSinkMap);
        out.writeObject(this.rangeIndexMap);
        out.writeInt(this.alphaNodeHashingThreshold);
        out.writeInt(this.alphaNodeRangeIndexThreshold);
    }

    public List<ObjectSinkNode> getOthers() {
        return this.otherSinks;
    }

    public List<AlphaNode> getHashableSinks() {
        return this.hashableSinks;
    }

    public Map<HashKey, AlphaNode> getHashedSinkMap() {
        return this.hashedSinkMap;
    }

    public List<AlphaNode> getRangeIndexableSinks() {
        return this.rangeIndexableSinks;
    }

    public Map<FieldIndex, AlphaRangeIndex> getRangeIndexMap() {
        return this.rangeIndexMap;
    }

    public ObjectSinkPropagator addObjectSink(ObjectSink sink) {
        return this.addObjectSink(sink, 0, 0);
    }

    @Override
    public ObjectSinkPropagator addObjectSink(ObjectSink sink, int alphaNodeHashingThreshold, int alphaNodeRangeIndexThreshold) {
        this.sinks = null;
        if (this.sinksMap != null) {
            this.sinksMap.put(sink, sink);
        }
        if (sink.getType() == 40) {
            AlphaNode alphaNode = (AlphaNode)sink;
            InternalReadAccessor readAccessor = CompositeObjectSinkAdapter.getHashableAccessor(alphaNode);
            if (readAccessor != null) {
                int index = readAccessor.getIndex();
                FieldIndex fieldIndex = this.registerFieldIndex(index, readAccessor);
                FieldValue value = ((IndexableConstraint)((Object)alphaNode.getConstraint())).getField();
                if (fieldIndex.getCount() >= this.alphaNodeHashingThreshold && this.alphaNodeHashingThreshold != 0 && !value.isNull()) {
                    if (!fieldIndex.isHashed()) {
                        this.hashSinks(fieldIndex);
                    }
                    this.hashedSinkMap.put(new HashKey(index, value, fieldIndex.getFieldExtractor()), alphaNode);
                } else {
                    if (this.hashableSinks == null) {
                        this.hashableSinks = new ArrayList<AlphaNode>();
                    }
                    this.hashableSinks.add(alphaNode);
                }
                return this;
            }
            if (this.isRangeIndexable(alphaNode)) {
                IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)alphaNode.getConstraint());
                InternalReadAccessor internalReadAccessor = indexableConstraint.getFieldExtractor();
                int index = internalReadAccessor.getIndex();
                FieldIndex fieldIndex = this.registerFieldIndexForRange(index, internalReadAccessor);
                FieldValue value = indexableConstraint.getField();
                if (fieldIndex.getCount() >= this.alphaNodeRangeIndexThreshold && this.alphaNodeRangeIndexThreshold != 0 && !value.isNull()) {
                    if (!fieldIndex.isRangeIndexed()) {
                        this.rangeIndexSinks(fieldIndex);
                    }
                    this.rangeIndexMap.get(fieldIndex).add(alphaNode);
                } else {
                    if (this.rangeIndexableSinks == null) {
                        this.rangeIndexableSinks = new ArrayList<AlphaNode>();
                    }
                    this.rangeIndexableSinks.add(alphaNode);
                }
                return this;
            }
        }
        if (this.otherSinks == null) {
            this.otherSinks = new ArrayList<ObjectSinkNode>();
        }
        this.otherSinks.add((ObjectSinkNode)sink);
        return this;
    }

    static InternalReadAccessor getHashableAccessor(AlphaNode alphaNode) {
        IndexableConstraint indexableConstraint;
        AlphaNodeFieldConstraint fieldConstraint = alphaNode.getConstraint();
        if (fieldConstraint instanceof IndexableConstraint && CompositeObjectSinkAdapter.isHashable(indexableConstraint = (IndexableConstraint)((Object)fieldConstraint))) {
            return indexableConstraint.getFieldExtractor();
        }
        return null;
    }

    private static boolean isHashable(IndexableConstraint indexableConstraint) {
        return indexableConstraint.getConstraintType() == IndexUtil.ConstraintType.EQUAL && indexableConstraint.getField() != null && indexableConstraint.getFieldExtractor().getValueType() != ValueType.OBJECT_TYPE && indexableConstraint.getFieldExtractor().getIndex() >= 0;
    }

    @Override
    public ObjectSinkPropagator removeObjectSink(ObjectSink sink) {
        AlphaNode alphaNode;
        AlphaNodeFieldConstraint fieldConstraint;
        this.sinks = null;
        if (this.sinksMap != null) {
            this.sinksMap.remove(sink);
        }
        if (sink.getType() == 40 && (fieldConstraint = (alphaNode = (AlphaNode)sink).getConstraint()) instanceof IndexableConstraint) {
            IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)fieldConstraint);
            FieldValue value = indexableConstraint.getField();
            if (CompositeObjectSinkAdapter.isHashable(indexableConstraint)) {
                InternalReadAccessor fieldAccessor = indexableConstraint.getFieldExtractor();
                int index = fieldAccessor.getIndex();
                FieldIndex fieldIndex = this.unregisterFieldIndex(index);
                if (fieldIndex.isHashed()) {
                    HashKey hashKey = new HashKey(index, value, fieldAccessor);
                    this.hashedSinkMap.remove(hashKey);
                    if (fieldIndex.getCount() <= this.alphaNodeHashingThreshold - 1) {
                        this.unHashSinks(fieldIndex);
                    }
                } else {
                    this.hashableSinks.remove(alphaNode);
                }
                if (this.hashableSinks != null && this.hashableSinks.isEmpty()) {
                    this.hashableSinks = null;
                }
                return this.size() == 1 ? new SingleObjectSinkAdapter(this.getSinks()[0]) : this;
            }
            if (this.isRangeIndexable(alphaNode)) {
                InternalReadAccessor fieldAccessor = indexableConstraint.getFieldExtractor();
                int index = fieldAccessor.getIndex();
                FieldIndex fieldIndex = this.unregisterFieldIndexForRange(index);
                if (fieldIndex.isRangeIndexed()) {
                    AlphaRangeIndex alphaRangeIndex = this.rangeIndexMap.get(fieldIndex);
                    alphaRangeIndex.remove(alphaNode);
                    if (fieldIndex.getCount() <= this.alphaNodeRangeIndexThreshold - 1) {
                        this.unRangeIndexSinks(fieldIndex, alphaRangeIndex);
                    }
                } else {
                    this.rangeIndexableSinks.remove(alphaNode);
                }
                if (this.rangeIndexableSinks != null && this.rangeIndexableSinks.isEmpty()) {
                    this.rangeIndexableSinks = null;
                }
                return this.size() == 1 ? new SingleObjectSinkAdapter(this.getSinks()[0]) : this;
            }
        }
        this.otherSinks.remove((ObjectSinkNode)sink);
        if (this.otherSinks.isEmpty()) {
            this.otherSinks = null;
        }
        return this.size() == 1 ? new SingleObjectSinkAdapter(this.getSinks()[0]) : this;
    }

    void hashSinks(FieldIndex fieldIndex) {
        if (this.hashedSinkMap == null) {
            this.hashedSinkMap = new HashMap<HashKey, AlphaNode>();
        }
        int index = fieldIndex.getIndex();
        InternalReadAccessor fieldReader = fieldIndex.getFieldExtractor();
        Iterator<AlphaNode> sinkIterator = this.hashableSinks.iterator();
        while (sinkIterator.hasNext()) {
            AlphaNode alphaNode = sinkIterator.next();
            AlphaNodeFieldConstraint fieldConstraint = alphaNode.getConstraint();
            IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)fieldConstraint);
            if (index != indexableConstraint.getFieldExtractor().getIndex()) continue;
            FieldValue value = indexableConstraint.getField();
            this.hashedSinkMap.put(new HashKey(index, value, fieldReader), alphaNode);
            sinkIterator.remove();
        }
        if (this.hashableSinks.isEmpty()) {
            this.hashableSinks = null;
        }
        fieldIndex.setHashed(true);
    }

    void unHashSinks(FieldIndex fieldIndex) {
        int index = fieldIndex.getIndex();
        ArrayList<HashKey> unhashedSinks = new ArrayList<HashKey>();
        for (AlphaNode alphaNode : this.hashedSinkMap.values()) {
            IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)alphaNode.getConstraint());
            if (index != indexableConstraint.getFieldExtractor().getIndex()) continue;
            FieldValue value = indexableConstraint.getField();
            if (this.hashableSinks == null) {
                this.hashableSinks = new ArrayList<AlphaNode>();
            }
            this.hashableSinks.add(alphaNode);
            unhashedSinks.add(new HashKey(index, value, fieldIndex.getFieldExtractor()));
        }
        for (HashKey hashKey : unhashedSinks) {
            this.hashedSinkMap.remove(hashKey);
        }
        if (this.hashedSinkMap.isEmpty()) {
            this.hashedSinkMap = null;
        }
        fieldIndex.setHashed(false);
    }

    private FieldIndex registerFieldIndex(int index, InternalReadAccessor fieldExtractor) {
        FieldIndex fieldIndex = null;
        if (this.hashedFieldIndexes == null) {
            this.hashedFieldIndexes = new ArrayList<FieldIndex>();
            fieldIndex = new FieldIndex(index, fieldExtractor);
            this.hashedFieldIndexes.add(fieldIndex);
        }
        if (fieldIndex == null) {
            fieldIndex = this.findFieldIndex(index);
        }
        if (fieldIndex == null) {
            fieldIndex = new FieldIndex(index, fieldExtractor);
            this.hashedFieldIndexes.add(fieldIndex);
        }
        fieldIndex.increaseCounter();
        return fieldIndex;
    }

    private FieldIndex unregisterFieldIndex(int index) {
        FieldIndex fieldIndex = this.findFieldIndex(index);
        if (fieldIndex == null) {
            throw new IllegalStateException("Cannot find field index for index " + index + "!");
        }
        fieldIndex.decreaseCounter();
        if (fieldIndex.getCount() == 0) {
            this.hashedFieldIndexes.remove(fieldIndex);
            if (this.hashedFieldIndexes.isEmpty()) {
                this.hashedFieldIndexes = null;
            }
        }
        return fieldIndex;
    }

    private FieldIndex findFieldIndex(int index) {
        for (FieldIndex node : this.hashedFieldIndexes) {
            if (node.getIndex() != index) continue;
            return node;
        }
        return null;
    }

    void rangeIndexSinks(FieldIndex fieldIndex) {
        if (this.rangeIndexMap == null) {
            this.rangeIndexMap = new HashMap<FieldIndex, AlphaRangeIndex>();
        }
        AlphaRangeIndex alphaRangeIndex = this.rangeIndexMap.computeIfAbsent(fieldIndex, AlphaRangeIndex::new);
        int index = fieldIndex.getIndex();
        if (this.rangeIndexableSinks != null) {
            Iterator<AlphaNode> sinkIterator = this.rangeIndexableSinks.iterator();
            while (sinkIterator.hasNext()) {
                AlphaNode alphaNode = sinkIterator.next();
                AlphaNodeFieldConstraint fieldConstraint = alphaNode.getConstraint();
                IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)fieldConstraint);
                if (index != indexableConstraint.getFieldExtractor().getIndex()) continue;
                alphaRangeIndex.add(alphaNode);
                sinkIterator.remove();
            }
            if (this.rangeIndexableSinks.isEmpty()) {
                this.rangeIndexableSinks = null;
            }
        }
        fieldIndex.setRangeIndexed(true);
    }

    void unRangeIndexSinks(FieldIndex fieldIndex, AlphaRangeIndex alphaRangeIndex) {
        if (this.rangeIndexableSinks == null) {
            this.rangeIndexableSinks = new ArrayList<AlphaNode>();
        }
        this.rangeIndexableSinks.addAll(alphaRangeIndex.getAllValues());
        alphaRangeIndex.clear();
        this.rangeIndexMap.remove(fieldIndex);
        if (this.rangeIndexMap.isEmpty()) {
            this.rangeIndexMap = null;
        }
        fieldIndex.setRangeIndexed(false);
    }

    private boolean isRangeIndexable(AlphaNode alphaNode) {
        AlphaNodeFieldConstraint fieldConstraint = alphaNode.getConstraint();
        if (fieldConstraint instanceof IndexableConstraint) {
            IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)fieldConstraint);
            IndexUtil.ConstraintType constraintType = indexableConstraint.getConstraintType();
            return (constraintType.isAscending() || constraintType.isDescending()) && indexableConstraint.getField() != null && !indexableConstraint.getField().isNull() && indexableConstraint.getFieldExtractor().getValueType() != ValueType.OBJECT_TYPE && indexableConstraint.getFieldExtractor().getIndex() >= 0;
        }
        return false;
    }

    private FieldIndex registerFieldIndexForRange(int index, InternalReadAccessor fieldExtractor) {
        FieldIndex fieldIndex;
        if (this.rangeIndexedFieldIndexes == null) {
            this.rangeIndexedFieldIndexes = new ArrayList<FieldIndex>();
        }
        if ((fieldIndex = this.findFieldIndexForRange(index)) == null) {
            fieldIndex = new FieldIndex(index, fieldExtractor);
            this.rangeIndexedFieldIndexes.add(fieldIndex);
        }
        fieldIndex.increaseCounter();
        return fieldIndex;
    }

    private FieldIndex unregisterFieldIndexForRange(int index) {
        FieldIndex fieldIndex = this.findFieldIndexForRange(index);
        if (fieldIndex == null) {
            throw new IllegalStateException("Cannot find field index for index " + index + "!");
        }
        fieldIndex.decreaseCounter();
        if (fieldIndex.getCount() == 0) {
            this.rangeIndexedFieldIndexes.remove(fieldIndex);
        }
        if (this.rangeIndexedFieldIndexes.isEmpty()) {
            this.rangeIndexedFieldIndexes = null;
        }
        return fieldIndex;
    }

    private FieldIndex findFieldIndexForRange(int index) {
        if (this.rangeIndexedFieldIndexes == null) {
            return null;
        }
        for (FieldIndex node : this.rangeIndexedFieldIndexes) {
            if (node.getIndex() != index) continue;
            return node;
        }
        return null;
    }

    @Override
    public void propagateAssertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object object = factHandle.getObject();
        if (this.hashedFieldIndexes != null) {
            for (FieldIndex fieldIndex : this.hashedFieldIndexes) {
                AlphaNode sink;
                if (!fieldIndex.isHashed() || (sink = this.hashedSinkMap.get(new HashKey(fieldIndex, object))) == null) continue;
                sink.getObjectSinkPropagator().propagateAssertObject(factHandle, context, workingMemory);
            }
        }
        if (this.rangeIndexMap != null) {
            for (Map.Entry entry : this.rangeIndexMap.entrySet()) {
                if (!((FieldIndex)entry.getKey()).isRangeIndexed()) continue;
                for (AlphaNode sink : ((AlphaRangeIndex)entry.getValue()).getMatchingAlphaNodes(object)) {
                    sink.getObjectSinkPropagator().propagateAssertObject(factHandle, context, workingMemory);
                }
            }
        }
        if (this.hashableSinks != null) {
            for (ObjectSinkNode objectSinkNode : this.hashableSinks) {
                this.doPropagateAssertObject(factHandle, context, workingMemory, objectSinkNode);
            }
        }
        if (this.rangeIndexableSinks != null) {
            for (ObjectSinkNode objectSinkNode : this.rangeIndexableSinks) {
                this.doPropagateAssertObject(factHandle, context, workingMemory, objectSinkNode);
            }
        }
        if (this.otherSinks != null) {
            for (ObjectSinkNode objectSinkNode : this.otherSinks) {
                this.doPropagateAssertObject(factHandle, context, workingMemory, objectSinkNode);
            }
        }
    }

    @Override
    public void propagateModifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object object = factHandle.getObject();
        if (this.hashedFieldIndexes != null) {
            for (FieldIndex fieldIndex : this.hashedFieldIndexes) {
                AlphaNode sink;
                if (!fieldIndex.isHashed() || (sink = this.hashedSinkMap.get(new HashKey(fieldIndex, object))) == null) continue;
                sink.getObjectSinkPropagator().propagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
            }
        }
        if (this.rangeIndexMap != null) {
            for (Map.Entry entry : this.rangeIndexMap.entrySet()) {
                if (!((FieldIndex)entry.getKey()).isRangeIndexed()) continue;
                for (AlphaNode sink : ((AlphaRangeIndex)entry.getValue()).getMatchingAlphaNodes(object)) {
                    sink.getObjectSinkPropagator().propagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
                }
            }
        }
        if (this.hashableSinks != null) {
            for (ObjectSinkNode objectSinkNode : this.hashableSinks) {
                this.doPropagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory, objectSinkNode);
            }
        }
        if (this.rangeIndexableSinks != null) {
            for (ObjectSinkNode objectSinkNode : this.rangeIndexableSinks) {
                this.doPropagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory, objectSinkNode);
            }
        }
        if (this.otherSinks != null) {
            for (ObjectSinkNode objectSinkNode : this.otherSinks) {
                this.doPropagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory, objectSinkNode);
            }
        }
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object object = factHandle.getObject();
        if (this.hashedFieldIndexes != null) {
            for (FieldIndex fieldIndex : this.hashedFieldIndexes) {
                AlphaNode sink;
                if (!fieldIndex.isHashed() || (sink = this.hashedSinkMap.get(new HashKey(fieldIndex, object))) == null) continue;
                sink.getObjectSinkPropagator().byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
            }
        }
        if (this.rangeIndexMap != null) {
            for (Map.Entry entry : this.rangeIndexMap.entrySet()) {
                if (!((FieldIndex)entry.getKey()).isRangeIndexed()) continue;
                for (AlphaNode sink : ((AlphaRangeIndex)entry.getValue()).getMatchingAlphaNodes(object)) {
                    sink.getObjectSinkPropagator().byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
                }
            }
        }
        if (this.hashableSinks != null) {
            for (AlphaNode alphaNode : this.hashableSinks) {
                alphaNode.getObjectSinkPropagator().byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
            }
        }
        if (this.rangeIndexableSinks != null) {
            for (AlphaNode alphaNode : this.rangeIndexableSinks) {
                alphaNode.getObjectSinkPropagator().byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
            }
        }
        if (this.otherSinks != null) {
            for (ObjectSinkNode objectSinkNode : this.otherSinks) {
                objectSinkNode.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
            }
        }
    }

    protected void doPropagateAssertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory, ObjectSink sink) {
        sink.assertObject(factHandle, context, workingMemory);
    }

    protected void doPropagateModifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory, ObjectSink sink) {
        sink.modifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    @Override
    public BaseNode getMatchingNode(BaseNode candidate) {
        if (this.sinksMap == null) {
            this.reIndexNodes();
        }
        return (BaseNode)this.sinksMap.get(candidate);
    }

    public void reIndexNodes() {
        this.sinksMap = new HashMap<NetworkNode, NetworkNode>();
        if (this.otherSinks != null) {
            for (ObjectSinkNode objectSinkNode : this.otherSinks) {
                this.sinksMap.put(objectSinkNode, objectSinkNode);
            }
        }
        if (this.hashableSinks != null) {
            for (ObjectSinkNode objectSinkNode : this.hashableSinks) {
                this.sinksMap.put(objectSinkNode, objectSinkNode);
            }
        }
        if (this.rangeIndexableSinks != null) {
            for (ObjectSinkNode objectSinkNode : this.rangeIndexableSinks) {
                this.sinksMap.put(objectSinkNode, objectSinkNode);
            }
        }
        if (this.hashedSinkMap != null) {
            for (ObjectSink objectSink : this.hashedSinkMap.values()) {
                this.sinksMap.put(objectSink, objectSink);
            }
        }
        if (this.rangeIndexMap != null) {
            Collection<AlphaRangeIndex> alphaRangeIndexes = this.rangeIndexMap.values();
            for (AlphaRangeIndex alphaRangeIndex : alphaRangeIndexes) {
                Collection<AlphaNode> alphaNodes = alphaRangeIndex.getAllValues();
                alphaNodes.forEach(sink -> this.sinksMap.put((NetworkNode)sink, (NetworkNode)sink));
            }
        }
    }

    @Override
    public ObjectSink[] getSinks() {
        if (this.sinks != null) {
            return this.sinks;
        }
        ObjectSink[] newSinks = new ObjectSink[this.size()];
        int at = 0;
        if (this.hashedFieldIndexes != null) {
            for (FieldIndex fieldIndex : this.hashedFieldIndexes) {
                if (!fieldIndex.isHashed()) continue;
                int index = fieldIndex.getIndex();
                for (Map.Entry<HashKey, AlphaNode> entry : this.hashedSinkMap.entrySet()) {
                    if (entry.getKey().getIndex() != index) continue;
                    newSinks[at++] = entry.getValue();
                }
            }
        }
        if (this.rangeIndexedFieldIndexes != null) {
            for (FieldIndex fieldIndex : this.rangeIndexedFieldIndexes) {
                if (!fieldIndex.isRangeIndexed()) continue;
                Collection<AlphaNode> alphaNodes = this.rangeIndexMap.get(fieldIndex).getAllValues();
                for (AlphaNode sink : alphaNodes) {
                    newSinks[at++] = sink;
                }
            }
        }
        if (this.hashableSinks != null) {
            for (ObjectSinkNode objectSinkNode : this.hashableSinks) {
                newSinks[at++] = objectSinkNode;
            }
        }
        if (this.rangeIndexableSinks != null) {
            for (ObjectSinkNode objectSinkNode : this.rangeIndexableSinks) {
                newSinks[at++] = objectSinkNode;
            }
        }
        if (this.otherSinks != null) {
            for (ObjectSinkNode objectSinkNode : this.otherSinks) {
                newSinks[at++] = objectSinkNode;
            }
        }
        this.sinks = newSinks;
        return newSinks;
    }

    @Override
    public void doLinkRiaNode(InternalWorkingMemory wm) {
        if (this.otherSinks != null) {
            for (ObjectSinkNode sink : this.otherSinks) {
                SingleObjectSinkAdapter.staticDoLinkRiaNode(sink, wm);
            }
        }
    }

    @Override
    public void doUnlinkRiaNode(InternalWorkingMemory wm) {
        if (this.otherSinks != null) {
            for (ObjectSinkNode sink : this.otherSinks) {
                SingleObjectSinkAdapter.staticDoUnlinkRiaNode(sink, wm);
            }
        }
    }

    @Override
    public int size() {
        return (this.otherSinks != null ? this.otherSinks.size() : 0) + (this.hashableSinks != null ? this.hashableSinks.size() : 0) + (this.hashedSinkMap != null ? this.hashedSinkMap.size() : 0) + (this.rangeIndexableSinks != null ? this.rangeIndexableSinks.size() : 0) + (this.rangeIndexMap != null ? this.rangeIndexMap.values().stream().map(AlphaRangeIndex::size).reduce(0, Integer::sum) : 0);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public List getOtherSinks() {
        return this.otherSinks;
    }

    public List<FieldIndex> getHashedFieldIndexes() {
        return this.hashedFieldIndexes;
    }

    public List<FieldIndex> getRangeIndexedFieldIndexes() {
        return this.rangeIndexedFieldIndexes;
    }

    public static class FieldIndex
    implements Externalizable {
        private static final long serialVersionUID = 510L;
        private int index;
        private InternalReadAccessor fieldExtactor;
        private int count;
        private boolean hashed;
        private boolean rangeIndexed;

        public FieldIndex() {
        }

        public FieldIndex(int index, InternalReadAccessor fieldExtractor) {
            this.index = index;
            this.fieldExtactor = fieldExtractor;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.index = in.readInt();
            this.fieldExtactor = (InternalReadAccessor)in.readObject();
            this.count = in.readInt();
            this.hashed = in.readBoolean();
            this.rangeIndexed = in.readBoolean();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.index);
            out.writeObject(this.fieldExtactor);
            out.writeInt(this.count);
            out.writeBoolean(this.hashed);
            out.writeBoolean(this.rangeIndexed);
        }

        public InternalReadAccessor getFieldExtractor() {
            return this.fieldExtactor;
        }

        public int getIndex() {
            return this.index;
        }

        public int getCount() {
            return this.count;
        }

        public ReadAccessor getFieldExtactor() {
            return this.fieldExtactor;
        }

        public boolean isHashed() {
            return this.hashed;
        }

        public void setHashed(boolean hashed) {
            this.hashed = hashed;
        }

        public boolean isRangeIndexed() {
            return this.rangeIndexed;
        }

        public void setRangeIndexed(boolean rangeIndexed) {
            this.rangeIndexed = rangeIndexed;
        }

        public void increaseCounter() {
            ++this.count;
        }

        public void decreaseCounter() {
            --this.count;
        }
    }

    public static class HashKey
    implements Externalizable {
        private int index;
        private Object value;
        private boolean isNull;
        private int hashCode;

        public HashKey() {
        }

        public HashKey(FieldIndex fieldIndex, Object value) {
            this.setValue(fieldIndex.getIndex(), value, fieldIndex.getFieldExtractor());
        }

        public HashKey(int index, FieldValue value, InternalReadAccessor extractor) {
            this.setValue(index, extractor, value);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.index = in.readInt();
            this.value = in.readObject();
            this.isNull = in.readBoolean();
            this.hashCode = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.index);
            out.writeObject(this.value);
            out.writeBoolean(this.isNull);
            out.writeInt(this.hashCode);
        }

        public int getIndex() {
            return this.index;
        }

        public void setValue(int index, Object value, InternalReadAccessor extractor) {
            this.index = index;
            this.isNull = extractor.isNullValue(null, value);
            if (!this.isNull) {
                this.value = extractor.getValue(null, value);
                this.setHashCode(this.value != null ? this.value.hashCode() : 0);
            } else {
                this.setHashCode(0);
            }
        }

        public void setValue(int index, InternalReadAccessor extractor, FieldValue value) {
            this.index = index;
            this.isNull = value.isNull();
            if (!this.isNull) {
                this.value = extractor.getValueType().coerce(value.getValue());
                this.setHashCode(this.value != null ? this.value.hashCode() : 0);
            } else {
                this.setHashCode(0);
            }
        }

        private void setHashCode(int hashSeed) {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + hashSeed;
            this.hashCode = result = 31 * result + this.index;
        }

        public Object getObjectValue() {
            return this.value;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (!(object instanceof HashKey)) {
                return false;
            }
            HashKey other = (HashKey)object;
            if (this.isNull != other.isNull || this.index != other.index) {
                return false;
            }
            return Objects.equals(this.value, other.getObjectValue());
        }
    }
}

