/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.cql;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.PrepareRequest;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.cql.DefaultPrepareRequest;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;

public interface AsyncCqlSession
extends Session {
    @NonNull
    default public CompletionStage<AsyncResultSet> executeAsync(@NonNull Statement<?> statement) {
        return Objects.requireNonNull(this.execute(statement, Statement.ASYNC), "The CQL processor should never return a null result");
    }

    @NonNull
    default public CompletionStage<AsyncResultSet> executeAsync(@NonNull String query) {
        return this.executeAsync(SimpleStatement.newInstance(query));
    }

    @NonNull
    default public CompletionStage<AsyncResultSet> executeAsync(@NonNull String query, Object ... values) {
        return this.executeAsync(SimpleStatement.newInstance(query, values));
    }

    @NonNull
    default public CompletionStage<AsyncResultSet> executeAsync(@NonNull String query, @NonNull Map<String, Object> values) {
        return this.executeAsync(SimpleStatement.newInstance(query, values));
    }

    @NonNull
    default public CompletionStage<PreparedStatement> prepareAsync(@NonNull SimpleStatement statement) {
        return Objects.requireNonNull(this.execute(new DefaultPrepareRequest(statement), PrepareRequest.ASYNC), "The CQL prepare processor should never return a null result");
    }

    @NonNull
    default public CompletionStage<PreparedStatement> prepareAsync(@NonNull String query) {
        return Objects.requireNonNull(this.execute(new DefaultPrepareRequest(query), PrepareRequest.ASYNC), "The CQL prepare processor should never return a null result");
    }

    @NonNull
    default public CompletionStage<PreparedStatement> prepareAsync(PrepareRequest request) {
        return Objects.requireNonNull(this.execute(request, PrepareRequest.ASYNC), "The CQL prepare processor should never return a null result");
    }
}

