/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import com.google.common.base.Objects;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

final class WritetimeOrTTLSelector
extends Selector {
    protected static final Selector.SelectorDeserializer deserializer = new Selector.SelectorDeserializer(){

        @Override
        protected Selector deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            ByteBuffer columnName = ByteBufferUtil.readWithVIntLength(in);
            ColumnMetadata column = metadata.getColumn(columnName);
            int idx = in.readInt();
            boolean isWritetime = in.readBoolean();
            return new WritetimeOrTTLSelector(column, idx, isWritetime);
        }
    };
    private final ColumnMetadata column;
    private final int idx;
    private final boolean isWritetime;
    private ByteBuffer current;
    private boolean isSet;

    public static Selector.Factory newFactory(final ColumnMetadata def, final int idx, final boolean isWritetime) {
        return new Selector.Factory(){

            @Override
            protected String getColumnName() {
                return String.format("%s(%s)", isWritetime ? "writetime" : "ttl", def.name.toString());
            }

            @Override
            protected AbstractType<?> getReturnType() {
                return isWritetime ? LongType.instance : Int32Type.instance;
            }

            @Override
            protected void addColumnMapping(SelectionColumnMapping mapping, ColumnSpecification resultsColumn) {
                mapping.addMapping(resultsColumn, def);
            }

            @Override
            public Selector newInstance(QueryOptions options) {
                return new WritetimeOrTTLSelector(def, idx, isWritetime);
            }

            @Override
            public boolean isWritetimeSelectorFactory() {
                return isWritetime;
            }

            @Override
            public boolean isTTLSelectorFactory() {
                return !isWritetime;
            }

            @Override
            public boolean areAllFetchedColumnsKnown() {
                return true;
            }

            @Override
            public void addFetchedColumns(ColumnFilter.Builder builder) {
                builder.add(def);
            }
        };
    }

    @Override
    public void addFetchedColumns(ColumnFilter.Builder builder) {
        builder.add(this.column);
    }

    @Override
    public void addInput(ProtocolVersion protocolVersion, Selector.InputRow input) {
        int ttl;
        long ts;
        if (this.isSet) {
            return;
        }
        this.isSet = true;
        this.current = this.isWritetime ? ((ts = input.getTimestamp(this.idx)) != Long.MIN_VALUE ? ByteBufferUtil.bytes(ts) : null) : ((ttl = input.getTtl(this.idx)) > 0 ? ByteBufferUtil.bytes(ttl) : null);
    }

    @Override
    public ByteBuffer getOutput(ProtocolVersion protocolVersion) {
        return this.current;
    }

    @Override
    public void reset() {
        this.isSet = false;
        this.current = null;
    }

    @Override
    public AbstractType<?> getType() {
        return this.isWritetime ? LongType.instance : Int32Type.instance;
    }

    public String toString() {
        return this.column.name.toString();
    }

    private WritetimeOrTTLSelector(ColumnMetadata column, int idx, boolean isWritetime) {
        super(Selector.Kind.WRITETIME_OR_TTL_SELECTOR);
        this.column = column;
        this.idx = idx;
        this.isWritetime = isWritetime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WritetimeOrTTLSelector)) {
            return false;
        }
        WritetimeOrTTLSelector s = (WritetimeOrTTLSelector)o;
        return Objects.equal((Object)this.column, (Object)s.column) && Objects.equal((Object)this.idx, (Object)s.idx) && Objects.equal((Object)this.isWritetime, (Object)s.isWritetime);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.column, this.idx, this.isWritetime});
    }

    @Override
    protected int serializedSize(int version) {
        return ByteBufferUtil.serializedSizeWithVIntLength(this.column.name.bytes) + TypeSizes.sizeof(this.idx) + TypeSizes.sizeof(this.isWritetime);
    }

    @Override
    protected void serialize(DataOutputPlus out, int version) throws IOException {
        ByteBufferUtil.writeWithVIntLength(this.column.name.bytes, out);
        out.writeInt(this.idx);
        out.writeBoolean(this.isWritetime);
    }
}

