/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.columniterator;

import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.UnfilteredDeserializer;
import org.apache.cassandra.db.UnfilteredValidation;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.DeserializationHelper;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredSerializer;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.IndexInfo;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.DataPosition;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class AbstractSSTableIterator
implements UnfilteredRowIterator {
    protected final SSTableReader sstable;
    protected final TableMetadata metadata;
    protected final DecoratedKey key;
    protected final DeletionTime partitionLevelDeletion;
    protected final ColumnFilter columns;
    protected final DeserializationHelper helper;
    protected final Row staticRow;
    protected final Reader reader;
    protected final FileHandle ifile;
    private boolean isClosed;
    protected final Slices slices;

    protected AbstractSSTableIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, RowIndexEntry indexEntry, Slices slices, ColumnFilter columnFilter, FileHandle ifile) {
        this.sstable = sstable;
        this.metadata = sstable.metadata();
        this.ifile = ifile;
        this.key = key;
        this.columns = columnFilter;
        this.slices = slices;
        this.helper = new DeserializationHelper(this.metadata, sstable.descriptor.version.correspondingMessagingVersion(), DeserializationHelper.Flag.LOCAL, columnFilter);
        if (indexEntry == null) {
            this.partitionLevelDeletion = DeletionTime.LIVE;
            this.reader = null;
            this.staticRow = Rows.EMPTY_STATIC_ROW;
        } else {
            boolean shouldCloseFile = file == null;
            try {
                boolean needSeekAtPartitionStart;
                boolean bl = needSeekAtPartitionStart = !indexEntry.isIndexed() || !this.columns.fetchedColumns().statics.isEmpty();
                if (needSeekAtPartitionStart) {
                    if (file == null) {
                        file = sstable.getFileDataInput(indexEntry.position);
                    } else {
                        file.seek(indexEntry.position);
                    }
                    ByteBufferUtil.skipShortLength(file);
                    this.partitionLevelDeletion = DeletionTime.serializer.deserialize(file);
                    this.reader = this.createReader(indexEntry, file, shouldCloseFile);
                    this.staticRow = AbstractSSTableIterator.readStaticRow(sstable, file, this.helper, this.columns.fetchedColumns().statics);
                } else {
                    this.partitionLevelDeletion = indexEntry.deletionTime();
                    this.staticRow = Rows.EMPTY_STATIC_ROW;
                    this.reader = this.createReader(indexEntry, file, shouldCloseFile);
                }
                if (!this.partitionLevelDeletion.validate()) {
                    UnfilteredValidation.handleInvalid(this.metadata(), key, sstable, "partitionLevelDeletion=" + this.partitionLevelDeletion.toString());
                }
                if (this.reader != null && !slices.isEmpty()) {
                    this.reader.setForSlice(this.nextSlice());
                }
                if (this.reader == null && file != null && shouldCloseFile) {
                    file.close();
                }
            }
            catch (IOException e) {
                sstable.markSuspect();
                String filePath = file.getPath();
                if (shouldCloseFile) {
                    try {
                        file.close();
                    }
                    catch (IOException suppressed) {
                        e.addSuppressed(suppressed);
                    }
                }
                throw new CorruptSSTableException((Throwable)e, filePath);
            }
        }
    }

    private Slice nextSlice() {
        return this.slices.get(this.nextSliceIndex());
    }

    protected abstract int nextSliceIndex();

    protected abstract boolean hasMoreSlices();

    private static Row readStaticRow(SSTableReader sstable, FileDataInput file, DeserializationHelper helper, Columns statics) throws IOException {
        if (!sstable.header.hasStatic()) {
            return Rows.EMPTY_STATIC_ROW;
        }
        if (statics.isEmpty()) {
            UnfilteredSerializer.serializer.skipStaticRow(file, sstable.header, helper);
            return Rows.EMPTY_STATIC_ROW;
        }
        return UnfilteredSerializer.serializer.deserializeStaticRow(file, sstable.header, helper);
    }

    protected abstract Reader createReaderInternal(RowIndexEntry var1, FileDataInput var2, boolean var3);

    private Reader createReader(RowIndexEntry indexEntry, FileDataInput file, boolean shouldCloseFile) {
        return this.slices.isEmpty() ? new NoRowsReader(file, shouldCloseFile) : this.createReaderInternal(indexEntry, file, shouldCloseFile);
    }

    @Override
    public TableMetadata metadata() {
        return this.metadata;
    }

    @Override
    public RegularAndStaticColumns columns() {
        return this.columns.fetchedColumns();
    }

    @Override
    public DecoratedKey partitionKey() {
        return this.key;
    }

    @Override
    public DeletionTime partitionLevelDeletion() {
        return this.partitionLevelDeletion;
    }

    @Override
    public Row staticRow() {
        return this.staticRow;
    }

    @Override
    public EncodingStats stats() {
        return this.sstable.stats();
    }

    @Override
    public boolean hasNext() {
        while (this.reader != null) {
            if (this.reader.hasNext()) {
                return true;
            }
            if (!this.hasMoreSlices()) {
                return false;
            }
            this.slice(this.nextSlice());
        }
        return false;
    }

    @Override
    public Unfiltered next() {
        assert (this.reader != null);
        return this.reader.next();
    }

    private void slice(Slice slice) {
        try {
            if (this.reader != null) {
                this.reader.setForSlice(slice);
            }
        }
        catch (IOException e) {
            try {
                this.closeInternal();
            }
            catch (IOException suppressed) {
                e.addSuppressed(suppressed);
            }
            this.sstable.markSuspect();
            throw new CorruptSSTableException((Throwable)e, this.reader.file.getPath());
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void closeInternal() throws IOException {
        if (this.isClosed) {
            return;
        }
        if (this.reader != null) {
            this.reader.close();
        }
        this.isClosed = true;
    }

    @Override
    public void close() {
        try {
            this.closeInternal();
        }
        catch (IOException e) {
            this.sstable.markSuspect();
            throw new CorruptSSTableException((Throwable)e, this.reader.file.getPath());
        }
    }

    public static class IndexState
    implements AutoCloseable {
        private final Reader reader;
        private final ClusteringComparator comparator;
        private final RowIndexEntry indexEntry;
        private final RowIndexEntry.IndexInfoRetriever indexInfoRetriever;
        private final boolean reversed;
        private int currentIndexIdx;
        private DataPosition mark;

        public IndexState(Reader reader, ClusteringComparator comparator, RowIndexEntry indexEntry, boolean reversed, FileHandle indexFile) {
            this.reader = reader;
            this.comparator = comparator;
            this.indexEntry = indexEntry;
            this.indexInfoRetriever = indexEntry.openWithIndex(indexFile);
            this.reversed = reversed;
            this.currentIndexIdx = reversed ? indexEntry.columnsIndexCount() : -1;
        }

        public boolean isDone() {
            return this.reversed ? this.currentIndexIdx < 0 : this.currentIndexIdx >= this.indexEntry.columnsIndexCount();
        }

        public void setToBlock(int blockIdx) throws IOException {
            if (blockIdx >= 0 && blockIdx < this.indexEntry.columnsIndexCount()) {
                this.reader.seekToPosition(this.columnOffset(blockIdx));
                this.mark = this.reader.file.mark();
                this.reader.deserializer.clearState();
            }
            this.currentIndexIdx = blockIdx;
            this.reader.openMarker = blockIdx > 0 ? this.index((int)(blockIdx - 1)).endOpenMarker : null;
        }

        private long columnOffset(int i) throws IOException {
            return this.indexEntry.position + this.index((int)i).offset;
        }

        public int blocksCount() {
            return this.indexEntry.columnsIndexCount();
        }

        public void updateBlock() throws IOException {
            assert (!this.reversed);
            if (this.currentIndexIdx < 0) {
                this.setToBlock(0);
                return;
            }
            while (this.currentIndexIdx + 1 < this.indexEntry.columnsIndexCount() && this.isPastCurrentBlock()) {
                long currentFilePointer;
                this.reader.openMarker = this.currentIndex().endOpenMarker;
                ++this.currentIndexIdx;
                long startOfBlock = this.columnOffset(this.currentIndexIdx);
                if (startOfBlock == (currentFilePointer = this.reader.file.getFilePointer())) {
                    this.mark = this.reader.file.mark();
                    continue;
                }
                this.reader.seekToPosition(startOfBlock);
                this.mark = this.reader.file.mark();
                this.reader.seekToPosition(currentFilePointer);
            }
        }

        public boolean isPastCurrentBlock() throws IOException {
            assert (this.reader.deserializer != null);
            return this.reader.file.bytesPastMark(this.mark) >= this.currentIndex().width;
        }

        public int currentBlockIdx() {
            return this.currentIndexIdx;
        }

        public IndexInfo currentIndex() throws IOException {
            return this.index(this.currentIndexIdx);
        }

        public IndexInfo index(int i) throws IOException {
            return this.indexInfoRetriever.columnsIndex(i);
        }

        public int findBlockIndex(ClusteringBound<?> bound, int fromIdx) throws IOException {
            if (bound.isBottom()) {
                return -1;
            }
            if (bound.isTop()) {
                return this.blocksCount();
            }
            return this.indexFor(bound, fromIdx);
        }

        public int indexFor(ClusteringPrefix<?> name, int lastIndex) throws IOException {
            int index;
            IndexInfo target = new IndexInfo(name, name, 0L, 0L, null);
            int startIdx = 0;
            int endIdx = this.indexEntry.columnsIndexCount() - 1;
            if (this.reversed) {
                if (lastIndex < endIdx) {
                    endIdx = lastIndex;
                }
            } else if (lastIndex > 0) {
                startIdx = lastIndex;
            }
            return (index = this.binarySearch(target, this.comparator.indexComparator(this.reversed), startIdx, endIdx)) < 0 ? -index - (this.reversed ? 2 : 1) : index;
        }

        private int binarySearch(IndexInfo key, Comparator<IndexInfo> c, int low, int high) throws IOException {
            while (low <= high) {
                int mid = low + high >>> 1;
                IndexInfo midVal = this.index(mid);
                int cmp = c.compare(midVal, key);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        public String toString() {
            return String.format("IndexState(indexSize=%d, currentBlock=%d, reversed=%b)", this.indexEntry.columnsIndexCount(), this.currentIndexIdx, this.reversed);
        }

        @Override
        public void close() throws IOException {
            this.indexInfoRetriever.close();
        }
    }

    private class NoRowsReader
    extends Reader {
        private NoRowsReader(FileDataInput file, boolean shouldCloseFile) {
            super(file, shouldCloseFile);
        }

        @Override
        public void setForSlice(Slice slice) throws IOException {
        }

        @Override
        protected boolean hasNextInternal() throws IOException {
            return false;
        }

        @Override
        protected Unfiltered nextInternal() throws IOException {
            throw new NoSuchElementException();
        }
    }

    protected abstract class Reader
    implements Iterator<Unfiltered> {
        private final boolean shouldCloseFile;
        public FileDataInput file;
        protected UnfilteredDeserializer deserializer;
        protected DeletionTime openMarker = null;

        protected Reader(FileDataInput file, boolean shouldCloseFile) {
            this.file = file;
            this.shouldCloseFile = shouldCloseFile;
            if (file != null) {
                this.createDeserializer();
            }
        }

        private void createDeserializer() {
            assert (this.file != null && this.deserializer == null);
            this.deserializer = UnfilteredDeserializer.create(AbstractSSTableIterator.this.metadata, this.file, AbstractSSTableIterator.this.sstable.header, AbstractSSTableIterator.this.helper);
        }

        protected void seekToPosition(long position) throws IOException {
            if (this.file == null) {
                this.file = AbstractSSTableIterator.this.sstable.getFileDataInput(position);
                this.createDeserializer();
            } else {
                this.file.seek(position);
            }
        }

        protected void updateOpenMarker(RangeTombstoneMarker marker) {
            this.openMarker = marker.isOpen(false) ? marker.openDeletionTime(false) : null;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.hasNextInternal();
            }
            catch (IOException | IndexOutOfBoundsException e) {
                try {
                    AbstractSSTableIterator.this.closeInternal();
                }
                catch (IOException suppressed) {
                    e.addSuppressed(suppressed);
                }
                AbstractSSTableIterator.this.sstable.markSuspect();
                throw new CorruptSSTableException((Throwable)e, AbstractSSTableIterator.this.reader.file.getPath());
            }
        }

        @Override
        public Unfiltered next() {
            try {
                return this.nextInternal();
            }
            catch (IOException e) {
                try {
                    AbstractSSTableIterator.this.closeInternal();
                }
                catch (IOException suppressed) {
                    e.addSuppressed(suppressed);
                }
                AbstractSSTableIterator.this.sstable.markSuspect();
                throw new CorruptSSTableException((Throwable)e, AbstractSSTableIterator.this.reader.file.getPath());
            }
        }

        public abstract void setForSlice(Slice var1) throws IOException;

        protected abstract boolean hasNextInternal() throws IOException;

        protected abstract Unfiltered nextInternal() throws IOException;

        public void close() throws IOException {
            if (this.shouldCloseFile && this.file != null) {
                this.file.close();
            }
        }
    }
}

