/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.cql3;

import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TokenRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CqlClientHelper {
    private CqlClientHelper() {
    }

    public static Map<TokenRange, List<Host>> getLocalPrimaryRangeForDC(String keyspace, Metadata metadata, String targetDC) {
        Objects.requireNonNull(keyspace, "keyspace");
        Objects.requireNonNull(metadata, "metadata");
        Objects.requireNonNull(targetDC, "targetDC");
        ArrayList<Token> tokens = new ArrayList<Token>();
        HashMap<Token, Host> tokenToHost = new HashMap<Token, Host>();
        for (Host host : metadata.getAllHosts()) {
            if (!targetDC.equals(host.getDatacenter())) continue;
            for (Token token : host.getTokens()) {
                Host previous = tokenToHost.putIfAbsent(token, host);
                if (previous != null) {
                    throw new IllegalStateException("Two hosts share the same token; hosts " + host.getHostId() + ":" + host.getTokens() + ", " + previous.getHostId() + ":" + previous.getTokens());
                }
                tokens.add(token);
            }
        }
        Collections.sort(tokens);
        HashMap<TokenRange, List<Host>> rangeToReplicas = new HashMap<TokenRange, List<Host>>();
        Token start = (Token)tokens.get(tokens.size() - 1);
        Token end = (Token)tokens.get(0);
        CqlClientHelper.addRange(keyspace, metadata, tokenToHost, rangeToReplicas, start, end);
        for (int i = 1; i < tokens.size(); ++i) {
            start = (Token)tokens.get(i - 1);
            end = (Token)tokens.get(i);
            CqlClientHelper.addRange(keyspace, metadata, tokenToHost, rangeToReplicas, start, end);
        }
        return rangeToReplicas;
    }

    private static void addRange(String keyspace, Metadata metadata, Map<Token, Host> tokenToHost, Map<TokenRange, List<Host>> rangeToReplicas, Token start, Token end) {
        Host host = tokenToHost.get(end);
        String dc = host.getDatacenter();
        TokenRange range = metadata.newTokenRange(start, end);
        ArrayList<Host> replicas = new ArrayList<Host>();
        replicas.add(host);
        for (Host replica : metadata.getReplicas(keyspace, range)) {
            if (!dc.equals(replica.getDatacenter()) || host.equals((Object)replica)) continue;
            replicas.add(replica);
        }
        List previous = rangeToReplicas.put(range, replicas);
        if (previous != null) {
            throw new IllegalStateException("Two hosts (" + host + ", " + previous + ") map to the same token range: " + range);
        }
    }
}

