/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.cql3;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TokenRange;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.dht.ByteOrderedPartitioner;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.OrderPreservingPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.hadoop.ColumnFamilySplit;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.cassandra.hadoop.ReporterWrapper;
import org.apache.cassandra.hadoop.cql3.CqlClientHelper;
import org.apache.cassandra.hadoop.cql3.CqlConfigHelper;
import org.apache.cassandra.hadoop.cql3.CqlRecordReader;
import org.apache.cassandra.utils.BiMultiValMap;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MapContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlInputFormat
extends InputFormat<Long, Row>
implements org.apache.hadoop.mapred.InputFormat<Long, Row> {
    public static final String MAPRED_TASK_ID = "mapred.task.id";
    private static final Logger logger = LoggerFactory.getLogger(CqlInputFormat.class);
    private String keyspace;
    private String cfName;
    private IPartitioner partitioner;

    public org.apache.hadoop.mapred.RecordReader<Long, Row> getRecordReader(InputSplit split, JobConf jobConf, Reporter reporter) throws IOException {
        MapContext tac = HadoopCompat.newMapContext((Configuration)jobConf, TaskAttemptID.forName((String)jobConf.get(MAPRED_TASK_ID)), null, null, null, new ReporterWrapper(reporter), null);
        CqlRecordReader recordReader = new CqlRecordReader();
        recordReader.initialize((org.apache.hadoop.mapreduce.InputSplit)split, (TaskAttemptContext)tac);
        return recordReader;
    }

    public RecordReader<Long, Row> createRecordReader(org.apache.hadoop.mapreduce.InputSplit arg0, TaskAttemptContext arg1) throws IOException, InterruptedException {
        return new CqlRecordReader();
    }

    protected void validateConfiguration(Configuration conf) {
        if (ConfigHelper.getInputKeyspace(conf) == null || ConfigHelper.getInputColumnFamily(conf) == null) {
            throw new UnsupportedOperationException("you must set the keyspace and table with setInputColumnFamily()");
        }
        if (ConfigHelper.getInputInitialAddress(conf) == null) {
            throw new UnsupportedOperationException("You must set the initial output address to a Cassandra node with setInputInitialAddress");
        }
        if (ConfigHelper.getInputPartitioner(conf) == null) {
            throw new UnsupportedOperationException("You must set the Cassandra partitioner class with setInputPartitioner");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<org.apache.hadoop.mapreduce.InputSplit> getSplits(JobContext context) throws IOException {
        Configuration conf = HadoopCompat.getConfiguration(context);
        this.validateConfiguration(conf);
        this.keyspace = ConfigHelper.getInputKeyspace(conf);
        this.cfName = ConfigHelper.getInputColumnFamily(conf);
        this.partitioner = ConfigHelper.getInputPartitioner(conf);
        logger.trace("partitioner is {}", (Object)this.partitioner);
        Object executor = ExecutorFactory.Global.executorFactory().pooled("HadoopInput", 128);
        ArrayList<org.apache.hadoop.mapreduce.InputSplit> splits = new ArrayList<org.apache.hadoop.mapreduce.InputSplit>();
        String[] inputInitialAddress = ConfigHelper.getInputInitialAddress(conf).split(",");
        try (Cluster cluster = CqlConfigHelper.getInputCluster(inputInitialAddress, conf);
             Session session = cluster.connect();){
            ArrayList<SplitFuture> splitfutures = new ArrayList<SplitFuture>();
            Pair<String, String> jobKeyRange = ConfigHelper.getInputKeyRange(conf);
            Range<Token> jobRange = null;
            if (jobKeyRange != null) {
                jobRange = new Range<Token>(this.partitioner.getTokenFactory().fromString((String)jobKeyRange.left), this.partitioner.getTokenFactory().fromString((String)jobKeyRange.right));
            }
            Metadata metadata = cluster.getMetadata();
            Map<TokenRange, List<Host>> masterRangeNodes = CqlInputFormat.getRangeMap(this.keyspace, metadata, CqlInputFormat.getTargetDC(metadata, inputInitialAddress));
            for (TokenRange range : masterRangeNodes.keySet()) {
                if (jobRange == null) {
                    for (TokenRange unwrapped : range.unwrap()) {
                        SplitFuture task = new SplitFuture(new SplitCallable(unwrapped, masterRangeNodes.get(range), conf, session));
                        executor.submit(task);
                        splitfutures.add(task);
                    }
                    continue;
                }
                TokenRange jobTokenRange = this.rangeToTokenRange(metadata, jobRange);
                if (!range.intersects(jobTokenRange)) continue;
                for (TokenRange intersection : range.intersectWith(jobTokenRange)) {
                    for (TokenRange unwrapped : intersection.unwrap()) {
                        SplitFuture task = new SplitFuture(new SplitCallable(unwrapped, masterRangeNodes.get(range), conf, session));
                        executor.submit(task);
                        splitfutures.add(task);
                    }
                }
            }
            ArrayList<SplitFuture> failedTasks = new ArrayList<SplitFuture>();
            int maxSplits = 0;
            long expectedPartionsForFailedRanges = 0L;
            for (SplitFuture task : splitfutures) {
                try {
                    List tokenRangeSplits = (List)task.get();
                    if (tokenRangeSplits.size() > maxSplits) {
                        maxSplits = tokenRangeSplits.size();
                        expectedPartionsForFailedRanges = ((ColumnFamilySplit)((Object)tokenRangeSplits.get(0))).getLength();
                    }
                    splits.addAll(tokenRangeSplits);
                }
                catch (Exception e) {
                    failedTasks.add(task);
                }
            }
            if (!failedTasks.isEmpty()) {
                if (maxSplits == 0) {
                    CqlInputFormat.throwAllSplitsFailed(failedTasks);
                }
                for (SplitFuture task : failedTasks) {
                    try {
                        task.get();
                    }
                    catch (Exception cause) {
                        logger.warn("Unable to get estimate for {}, the host {} had a exception; falling back to default estimate", new Object[]{task.splitCallable.tokenRange, task.splitCallable.hosts.get(0), cause});
                    }
                }
                for (SplitFuture task : failedTasks) {
                    splits.addAll(this.toSplit(task.splitCallable.hosts, CqlInputFormat.splitTokenRange(task.splitCallable.tokenRange, maxSplits, expectedPartionsForFailedRanges)));
                }
            }
        }
        finally {
            executor.shutdownNow();
        }
        assert (splits.size() > 0);
        Collections.shuffle(splits, new Random(Clock.Global.nanoTime()));
        return splits;
    }

    private static IllegalStateException throwAllSplitsFailed(List<SplitFuture> failedTasks) {
        IllegalStateException exception = new IllegalStateException("No successful tasks found");
        for (SplitFuture task : failedTasks) {
            try {
                task.get();
            }
            catch (Exception cause) {
                exception.addSuppressed(cause);
            }
        }
        throw exception;
    }

    private static String getTargetDC(Metadata metadata, String[] inputInitialAddress) {
        BiMultiValMap<InetAddress, String> addressToDc = new BiMultiValMap<InetAddress, String>();
        Multimap dcToAddresses = addressToDc.inverse();
        HashSet<InetAddress> addresses = new HashSet<InetAddress>(inputInitialAddress.length);
        for (String string : inputInitialAddress) {
            addresses.addAll(CqlInputFormat.parseAddress(string));
        }
        for (Host host : metadata.getAllHosts()) {
            InetAddress address = host.getBroadcastAddress();
            if (!addresses.contains(address)) continue;
            addressToDc.put(address, host.getDatacenter());
        }
        switch (dcToAddresses.keySet().size()) {
            case 1: {
                return (String)Iterables.getOnlyElement((Iterable)dcToAddresses.keySet());
            }
            case 0: {
                throw new IllegalStateException("Input addresses could not be used to find DC; non match client metadata");
            }
        }
        for (String string : inputInitialAddress) {
            for (InetAddress add : CqlInputFormat.parseAddress(string)) {
                String dc = (String)addressToDc.get(add);
                if (dc == null) continue;
                return dc;
            }
        }
        throw new AssertionError((Object)("Unable to infer datacenter from initial addresses; multiple datacenters found " + dcToAddresses.keySet() + ", should only use addresses from one datacenter"));
    }

    private static List<InetAddress> parseAddress(String str) {
        try {
            return Arrays.asList(InetAddress.getAllByName(str));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private TokenRange rangeToTokenRange(Metadata metadata, Range<Token> range) {
        return metadata.newTokenRange(metadata.newToken(this.partitioner.getTokenFactory().toString((Token)range.left)), metadata.newToken(this.partitioner.getTokenFactory().toString((Token)range.right)));
    }

    private Map<TokenRange, Long> getSubSplits(String keyspace, String cfName, TokenRange range, Host host, Configuration conf, Session session) {
        int splitSize = ConfigHelper.getInputSplitSize(conf);
        int splitSizeMiB = ConfigHelper.getInputSplitSizeInMb(conf);
        return this.describeSplits(keyspace, cfName, range, host, splitSize, splitSizeMiB, session);
    }

    private static Map<TokenRange, List<Host>> getRangeMap(String keyspace, Metadata metadata, String targetDC) {
        return CqlClientHelper.getLocalPrimaryRangeForDC(keyspace, metadata, targetDC);
    }

    private Map<TokenRange, Long> describeSplits(String keyspace, String table, TokenRange tokenRange, Host host, int splitSize, int splitSizeMb, Session session) {
        ResultSet resultSet = CqlInputFormat.queryTableEstimates(session, host, keyspace, table, tokenRange);
        Row row = resultSet.one();
        long meanPartitionSize = 0L;
        long partitionCount = 0L;
        int splitCount = 0;
        if (row != null) {
            meanPartitionSize = row.getLong("mean_partition_size");
            partitionCount = row.getLong("partitions_count");
            int n = splitCount = splitSizeMb > 0 ? (int)(meanPartitionSize * partitionCount / (long)splitSizeMb / 1024L / 1024L) : (int)(partitionCount / (long)splitSize);
        }
        if (splitCount == 0) {
            HashMap<TokenRange, Long> wrappedTokenRange = new HashMap<TokenRange, Long>();
            wrappedTokenRange.put(tokenRange, partitionCount == 0L ? 128L : partitionCount);
            return wrappedTokenRange;
        }
        return CqlInputFormat.splitTokenRange(tokenRange, splitCount, partitionCount / (long)splitCount);
    }

    private static ResultSet queryTableEstimates(Session session, Host host, String keyspace, String table, TokenRange tokenRange) {
        try {
            String query = String.format("SELECT mean_partition_size, partitions_count FROM %s.%s WHERE keyspace_name = ? AND table_name = ? AND range_type = '%s' AND range_start = ? AND range_end = ?", "system", "table_estimates", "local_primary");
            Statement stmt = new SimpleStatement(query, new Object[]{keyspace, table, tokenRange.getStart().toString(), tokenRange.getEnd().toString()}).setHost(host);
            return session.execute(stmt);
        }
        catch (InvalidQueryException e) {
            String query = String.format("SELECT mean_partition_size, partitions_count FROM %s.%s WHERE keyspace_name = ? AND table_name = ? AND range_start = ? AND range_end = ?", "system", "size_estimates");
            Statement stmt = new SimpleStatement(query, new Object[]{keyspace, table, tokenRange.getStart().toString(), tokenRange.getEnd().toString()}).setHost(host);
            return session.execute(stmt);
        }
    }

    private static Map<TokenRange, Long> splitTokenRange(TokenRange tokenRange, int splitCount, long partitionCount) {
        List splitRanges = tokenRange.splitEvenly(splitCount);
        HashMap rangesWithLength = Maps.newHashMapWithExpectedSize((int)splitRanges.size());
        for (TokenRange range : splitRanges) {
            rangesWithLength.put(range, partitionCount);
        }
        return rangesWithLength;
    }

    public InputSplit[] getSplits(JobConf jobConf, int numSplits) throws IOException {
        TaskAttemptContext tac = HadoopCompat.newTaskAttemptContext((Configuration)jobConf, new TaskAttemptID());
        List<org.apache.hadoop.mapreduce.InputSplit> newInputSplits = this.getSplits((JobContext)tac);
        InputSplit[] oldInputSplits = new InputSplit[newInputSplits.size()];
        for (int i = 0; i < newInputSplits.size(); ++i) {
            oldInputSplits[i] = (ColumnFamilySplit)newInputSplits.get(i);
        }
        return oldInputSplits;
    }

    private List<ColumnFamilySplit> toSplit(List<Host> hosts, Map<TokenRange, Long> subSplits) {
        String[] endpoints = new String[hosts.size()];
        int endpointIndex = 0;
        for (Host endpoint : hosts) {
            endpoints[endpointIndex++] = endpoint.getAddress().getHostName();
        }
        boolean partitionerIsOpp = this.partitioner instanceof OrderPreservingPartitioner || this.partitioner instanceof ByteOrderedPartitioner;
        ArrayList<ColumnFamilySplit> splits = new ArrayList<ColumnFamilySplit>();
        for (Map.Entry<TokenRange, Long> subSplitEntry : subSplits.entrySet()) {
            TokenRange subrange = subSplitEntry.getKey();
            ColumnFamilySplit split = new ColumnFamilySplit(partitionerIsOpp ? subrange.getStart().toString().substring(2) : subrange.getStart().toString(), partitionerIsOpp ? subrange.getEnd().toString().substring(2) : subrange.getEnd().toString(), subSplitEntry.getValue(), endpoints);
            logger.trace("adding {}", (Object)split);
            splits.add(split);
        }
        return splits;
    }

    private static class SplitFuture
    extends FutureTask<List<ColumnFamilySplit>> {
        private final SplitCallable splitCallable;

        SplitFuture(SplitCallable splitCallable) {
            super(splitCallable);
            this.splitCallable = splitCallable;
        }
    }

    class SplitCallable
    implements Callable<List<ColumnFamilySplit>> {
        private final TokenRange tokenRange;
        private final List<Host> hosts;
        private final Configuration conf;
        private final Session session;

        public SplitCallable(TokenRange tokenRange, List<Host> hosts, Configuration conf, Session session) {
            Preconditions.checkArgument((!hosts.isEmpty() ? 1 : 0) != 0, (Object)"hosts list requires at least 1 host but was empty");
            this.tokenRange = tokenRange;
            this.hosts = hosts;
            this.conf = conf;
            this.session = session;
        }

        @Override
        public List<ColumnFamilySplit> call() throws Exception {
            Map subSplits = CqlInputFormat.this.getSubSplits(CqlInputFormat.this.keyspace, CqlInputFormat.this.cfName, this.tokenRange, this.hosts.get(0), this.conf, this.session);
            return CqlInputFormat.this.toSplit(this.hosts, subSplits);
        }
    }
}

